package com.bcxin.ars.service.supervision;

import com.bcxin.ars.dao.supervision.OtherPunishDao;
import com.bcxin.ars.dao.supervision.OtherPunishInvolverDao;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.page.supervision.OtherPunishPageSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.supervision.OtherPunish;
import com.bcxin.ars.model.supervision.OtherPunishInvolver;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author linqinglin
 * @date 2020/01/09 0009 17:29
 */
@Service
@Transactional
public class OtherPunishServiceImpl implements OtherPunishService {

    @Autowired
    private OtherPunishDao otherPunishDao;

    @Autowired
    private OtherPunishInvolverDao otherPunishInvolverDao;

    @Autowired
    private ArsUtil arsUtil;

    @Override
    public int delete(OtherPunish record) {
        User currentUser = arsUtil.getCurrentUser();
        record.setUpdateTime(new Date());
        record.setUpdateBy(currentUser.getUsername());
        return otherPunishDao.delete(record);
    }

    @Override
    public void save(OtherPunish record) {
        User currentUser = arsUtil.getCurrentUser();
        if(record.getId() == null){
            record.setCreateTime(new Date());
        }else{
            OtherPunish dbRecord = otherPunishDao.findById(record.getId());
            boolean flag = false;
            if(!dbRecord.getPunishType().equals(record.getPunishType())
                    && Constants.PUNISHTYPE_PERSON.equals(record.getPunishType())){
                flag = true;
            }
            BeanUtils.copyPropertiesIgnore(record,dbRecord,true);
            BeanUtils.copyPropertiesIgnore(dbRecord,record,false);

            if(flag){
                record.setCompanyName(null);
                record.setAddress(null);
            }
        }

        record.setActive(true);
        record.setUpdateBy(currentUser.getUsername());
        record.setUpdateTime(new Date());
        record.setUpdateflag(true);
        record.setAreaCode(currentUser.getPolice().getAreacode());
        otherPunishDao.save(record);
        if(!Constants.PUNISHTYPE_PERSON.equals(record.getPunishType())){
            otherPunishInvolverDao.deleteByPunishId(record.getId());
            if(record.getInvolvers() != null && record.getInvolvers().size() > 0){
                List<OtherPunishInvolver> involverList = new ArrayList<>();
                for (OtherPunishInvolver involver : record.getInvolvers()) {
                    if(StringUtil.isNotEmpty(involver.getName()) && StringUtil.isNotEmpty(involver.getIdnum())) {
                        involver.setActive(true);
                        involver.setCreateTime(new Date());
                        involver.setUpdateTime(new Date());
                        involver.setUpdateBy(currentUser.getUsername());
                        involver.setUpdateflag(true);
                        involver.setPunishId(record.getId());

                        involverList.add(involver);
                    }
                }
                if(involverList.size() >0){
                    otherPunishInvolverDao.saveBatch(involverList);
                }
            }
        }
    }

    @Override
    public OtherPunish findById(Long id) {
        OtherPunish otherPunish = otherPunishDao.findById(id);
        if(!Constants.PUNISHTYPE_PERSON.equals(otherPunish.getPunishType())){
            otherPunish.setInvolvers(otherPunishInvolverDao.findByPunishId(id));
        }
        return otherPunish;
    }

    @Override
    public void searchForPage(SearchDto dto, AjaxPageResponse page) {
        arsUtil.setPoliceSearch(dto);
        otherPunishDao.searchForPage((OtherPunishPageSearchDto)dto,page);
    }
}
