package com.bcxin.ars.service.statistics;

import com.bcxin.ars.dao.PoliceDao;
import com.bcxin.ars.dao.statistics.FlowStatisticsDao;
import com.bcxin.ars.dto.statistics.ParamDTO;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.SysAreaUtil;
import com.bcxin.ars.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;


/**
 * <p>
 * 流程情况分析
 * </p>
 *
 * @author 罗鹏
 * @date 2018/4/16
 */
@Service
public class FlowStatisticsServiceImpl implements FlowStatisticsService {
	
	@Autowired
	private FlowStatisticsDao flowStatisticsDao;

	@Autowired
	private SysAreaUtil sysAreaUtil;

	@Autowired
	private ArsUtil arsUtil;

	@Autowired
	private PoliceDao policeDao;


	//保安公司区域分析
	@Override
	public List<Map> flowDetail(ParamDTO paramDTO){
		if (StringUtil.isNotEmpty(paramDTO.getStation())){
			Police police = policeDao.findById(Long.parseLong(paramDTO.getStation()));
			paramDTO.setAreaCode(police.getCode());
		}

		if (StringUtil.isNotEmpty(paramDTO.getProvince())) {
			paramDTO.setAreaCode(paramDTO.getProvince());
		}
		if (StringUtil.isNotEmpty(paramDTO.getCity())) {
			paramDTO.setAreaCode(paramDTO.getCity());
		}
		if (StringUtil.isNotEmpty(paramDTO.getArea())){
			paramDTO.setAreaCode(paramDTO.getArea());
		}

		if (StringUtil.isEmpty(paramDTO.getAreaCode())) {
			String areaCode = arsUtil.getCurrentUser().getPolice().getAreacode();
			paramDTO.setAreaCode(areaCode);
		}
		return flowStatisticsDao.getApproveProDetail(paramDTO);
	}

	/****************************************** 保安员页面 **************************/
}
