package com.bcxin.ars.service.sb.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.*;
import com.bcxin.ars.dao.sb.*;
import com.bcxin.ars.dao.sys.ApprovalDAO;
import com.bcxin.ars.dao.sys.MessageLogDao;
import com.bcxin.ars.dao.task.ComContractDao;
import com.bcxin.ars.dao.task.TaskDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.PersonLevelDto;
import com.bcxin.ars.dto.ReportData;
import com.bcxin.ars.dto.page.task.ComContractSearchDto;
import com.bcxin.ars.dto.report.PersonPolicyDto;
import com.bcxin.ars.dto.report.TaskExecutionDto;
import com.bcxin.ars.dto.report.YearReportDto;
import com.bcxin.ars.dto.report.YearReportsSearchDto;
import com.bcxin.ars.dto.sb.*;
import com.bcxin.ars.model.*;
import com.bcxin.ars.model.sb.*;
import com.bcxin.ars.model.sys.Approval;
import com.bcxin.ars.service.sb.YearreportdataService;
import com.bcxin.ars.service.util.ApprovalUtil;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.SysBaseUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.approval.ApprovalState;
import com.bcxin.ars.util.approval.BusinessType;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.util.Date;
import java.util.List;


@Service
@Transactional
@DataSyncAnnotation(getClazz = Yearreportdata.class)
public class YearreportdataServiceImpl implements YearreportdataService{

    @Autowired
    private YearreportdataDAO yearreportdataDAO;
    @Autowired
    private ArsUtil arsUtil;

    @Autowired
    private YearreportdataManagerDAO yearreportdataManagerDAO;

    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private SecurityCompanyInsuranceDao securityCompanyInsuranceDao;
    
    @Autowired
    private SecurityPersonDao personDao;
	@Autowired
	private ApprovalDAO approvalDAO;
    
    @Autowired
    private SecurityCompanyDao companyDao;
    
    @Autowired
    private TaskDao taskDao;

    @Autowired
    private InvestorDao investorDao;
    
    @Autowired
    private YearReportInvestorDao yearReportinvestorDao;
    
    @Autowired
    private YearReportInsuranceDao yearReportInsuranceDao;

    @Autowired
    private SbSubsidiaryBaseDao sbSubsidiaryBaseDao;

    @Autowired
    private VehicleDao vehicleDao;

    @Autowired
    private FirearmsDao firearmsDao;

    @Autowired
    private SafetyDao safetyDao;

    @Autowired
    private ApprovalDAO approvalDao;

    @Autowired
    private ManagementInfoDao managementInfoDao;
    
    @Autowired
    private CyServerhtDao cyServerhtDao;

    @Autowired
    private ApprovalUtil approvalUtil;
	@Autowired
	private MessageLogDao messageLogDao;

	@Autowired
	private PoliceDao policeDao;

	@Autowired
	private SecurityPersonDao securityPersonDao;

	@Autowired
	private ComContractDao comContractDao;

    @Override
    public Yearreportdata findByUserId(long userId) {
        Yearreportdata result = yearreportdataDAO.findByUserId(userId,getFilingYear());
        if(result!=null) {
            YearreportdataManager querydto = new YearreportdataManager();
            querydto.setUserid(arsUtil.getCurrentUser().getId());
            //查询总经理
            querydto.setManagertype("001");
            result.setManges(yearreportdataManagerDAO.findByUserId(querydto));
            //查询副总经理
            querydto.setManagertype("002");
            result.setFontmanges(yearreportdataManagerDAO.findByUserId(querydto));

            //保险信息
            result.setInsuranceList(yearReportInsuranceDao.findByYearReportId(result.getId()));
            
            //出资人信息
            result.setInvestorList(yearReportinvestorDao.findByYearReportId(result.getId()));

			Approval approval =approvalDAO.findBybusinessidAndType(result.getId(),BusinessType.NDBG);
			result.setApproval(approval);
        }
        return result;
    }
	@Override
	public  List<Yearreportdata> findByBatchId(List<Approval> approvalList){
		return  yearreportdataDAO.findByBatchId(approvalList);
	}
	@Override
	public  void updateBatch(List<Yearreportdata> list){
		yearreportdataDAO.updateBatch(list);
	}

	private String getFilingYear(){
		//备案年份：去年的11月1到明年的11月1号之前提交的都算去年，比如2017年份的是从2017年11月1号到2018年11月1号之前提提交的都是2017年份的。
		Integer startMonth = 10;

		String filingYear = "";
		Date now = new Date();

		Config config = configUtils.getConfigByKey(Constants.YEAR_REPORT_STARTMONTH);

		if(config != null){
			startMonth = Integer.parseInt(config.getValue());
		}

		if(now.getMonth() <startMonth){
			filingYear = DateUtil.getLastYear();
		}else{
			filingYear = DateUtil.getCurrentDate(DateUtil.FORMAT10);
		}
		return filingYear;
	}

	@Override
	public void saveOrUpdateDateForUserId(Yearreportdata yearreportdata) {

		/**
		 * 最后一级机构id处理
		 */
		if(yearreportdata.getOrgid() == null){
			if(yearreportdata.getDistrictOrgId() != null){
				yearreportdata.setOrgid(Long.parseLong(yearreportdata.getDistrictOrgId()));
			}else if(yearreportdata.getCityOrgId() != null){
				yearreportdata.setOrgid(Long.parseLong(yearreportdata.getCityOrgId()));
			}
		}

		if(yearreportdata.getId() == null) {
			//服务
			yearreportdata.setActive(true);
			yearreportdata.setCreateTime(new Date());
			yearreportdata.setUpdateTime(new Date());
			if(StringUtil.isEmpty(yearreportdata.getApprovalstate())) {
				if ("002".equals(yearreportdata.getZc())){
					yearreportdata.setApprovalstate(ApprovalState.WTJ);
				}
			}
//          备案年份：去年的11月1到明年的11月1号之前提交的都算去年，比如2017年份的是从2017年11月1号到2018年11月1号之前提提交的都是2017年份的。
			String filingYear = getFilingYear();

			yearreportdata.setFilingYear(filingYear);
			yearreportdata.setUpdateBy(arsUtil.getCurrentUser().getUsername());
			yearreportdata.setUserid(arsUtil.getCurrentUser().getId());

			SecurityCompany company = companyDao.findByUserid(arsUtil.getCurrentUser().getId());
			if(company != null){
				yearreportdata.setCompanyname(company.getName());
				yearreportdata.setAreaCode(company.getAreaCode());
			}

			yearreportdataDAO.save(yearreportdata);
			//保险
			if(yearreportdata.isLineInsure()){
				saveInsuranceCompany(yearreportdata);
			}

			//保存总经理信息
			saveManager(yearreportdata);
			//非暂存，则保存其信息
			if(yearreportdata.getZc()!=null && yearreportdata.getZc().equals("002")) {
				saveStatistics(yearreportdata);
			}
		}else{

			Yearreportdata dbYearreport = yearreportdataDAO.findById(yearreportdata.getId());
			dbYearreport.setApprovalstate(yearreportdata.getApprovalstate());
			dbYearreport.setApprovaldate(yearreportdata.getApprovaldate());
			dbYearreport.setApprovalfile(yearreportdata.getApprovalfile());
			dbYearreport.setApprovalperson(yearreportdata.getApprovalperson());
			dbYearreport.setApprovalreason(yearreportdata.getApprovalreason());
			dbYearreport.setBjly(yearreportdata.getBjly());
			dbYearreport.setBzcgpic(yearreportdata.getBzcgpic());
			dbYearreport.setDxbayrs(yearreportdata.getDxbayrs());
			dbYearreport.setDyhdnr(yearreportdata.getDyhdnr());
			dbYearreport.setDyrs(yearreportdata.getDyrs());
			dbYearreport.setFbq(yearreportdata.getFbq());
			dbYearreport.setFeducation(yearreportdata.getFeducation());
			dbYearreport.setFpfpic(yearreportdata.getFpfpic());
			dbYearreport.setFpzpic(yearreportdata.getFpzpic());
			dbYearreport.setFtbx(yearreportdata.getFtbx());
			dbYearreport.setGdzc(yearreportdata.getGdzc());
			dbYearreport.setGmsbrs(yearreportdata.getGmsbrs());
			dbYearreport.setGsbx(yearreportdata.getGsbx());
			dbYearreport.setJyywrs(yearreportdata.getJyywrs());
			dbYearreport.setKhsl(yearreportdata.getKhsl());
			dbYearreport.setNdbg(yearreportdata.getNdbg());
			dbYearreport.setNlx(yearreportdata.getNlx());
			dbYearreport.setNyye(yearreportdata.getNyye());
			dbYearreport.setSfdjzz(yearreportdata.getSfdjzz());
			dbYearreport.setSffzbj(yearreportdata.getSffzbj());
			dbYearreport.setSffzsg(yearreportdata.getSffzsg());
			dbYearreport.setSfzqqc(yearreportdata.getSfzqqc());
			dbYearreport.setSjczgz(yearreportdata.getSjczgz());
			dbYearreport.setSqgbzrs(yearreportdata.getSqgbzrs());
			dbYearreport.setSshijbzrs(yearreportdata.getSshijbzrs());
			dbYearreport.setSsjbzrs(yearreportdata.getSsjbzrs());
			dbYearreport.setSybx(yearreportdata.getSybx());
			dbYearreport.setSyebx(yearreportdata.getSyebx());
			dbYearreport.setSzacrs(yearreportdata.getSzacrs());
			dbYearreport.setSzgpxrs(yearreportdata.getSzgpxrs());
			dbYearreport.setTgpaxs(yearreportdata.getTgpaxs());

//        	dbYearreport.setWgmsbrs(yearreportdata.getWgmsbrs());

			dbYearreport.setWhjjss(yearreportdata.getWhjjss());
			dbYearreport.setWtzlhdrc(yearreportdata.getWtzlhdrc());
			dbYearreport.setSjczgzrc(yearreportdata.getSjczgzrc());
			dbYearreport.setWtzlhd(yearreportdata.getWtzlhd());
			dbYearreport.setWz(yearreportdata.getWz());
			dbYearreport.setWzmc(yearreportdata.getWzmc());
			dbYearreport.setXgqpxrs(yearreportdata.getXgqpxrs());
			dbYearreport.setXjg(yearreportdata.getXjg());
			dbYearreport.setXpxrs(yearreportdata.getXpxrs());
			dbYearreport.setXzgpxrs(yearreportdata.getXzgpxrs());
			dbYearreport.setYcc(yearreportdata.getYcc());
			dbYearreport.setYfszsg(yearreportdata.getYfszsg());
			dbYearreport.setYgfsrs(yearreportdata.getYgfsrs());
			dbYearreport.setYgxxrs(yearreportdata.getYgxxrs());
			dbYearreport.setYlaobx(yearreportdata.getYlaobx());
			dbYearreport.setYlbx(yearreportdata.getYlbx());
			dbYearreport.setZbqkqt(yearreportdata.getZbqkqt());
			dbYearreport.setZhxyr(yearreportdata.getZhxyr());
			dbYearreport.setZjjk(yearreportdata.getZjjk());
			dbYearreport.setZjxszrrs(yearreportdata.getZjxszrrs());

			dbYearreport.setMalenum(yearreportdata.getMalenum());
			dbYearreport.setEscortnum(yearreportdata.getEscortnum());
			dbYearreport.setArmnum(yearreportdata.getArmnum());
			dbYearreport.setFemalenum(yearreportdata.getFemalenum());
			dbYearreport.setPersonnum(yearreportdata.getPersonnum());
			dbYearreport.setCjnum(yearreportdata.getCjnum());
			dbYearreport.setZjnum(yearreportdata.getZjnum());
			dbYearreport.setGjnum(yearreportdata.getGjnum());
			dbYearreport.setManagernum(yearreportdata.getManagernum());
			dbYearreport.setGjmanagernum(yearreportdata.getGjmanagernum());
			dbYearreport.setCertificateCount(yearreportdata.getCertificateCount());

			dbYearreport.setLineInsure(yearreportdata.isLineInsure());
			dbYearreport.setSzss(yearreportdata.getSzss());
			dbYearreport.setProvince(yearreportdata.getProvince());
			dbYearreport.setCity(yearreportdata.getCity());
			dbYearreport.setDistrict(yearreportdata.getDistrict());
        	dbYearreport.setOrgid(yearreportdata.getOrgid());

			if(StringUtil.isNotEmpty(yearreportdata.getZc())){
				dbYearreport.setZc(yearreportdata.getZc());
			}
			dbYearreport.setUpdateTime(new Date());
			String filingYear = getFilingYear();

			dbYearreport.setFilingYear(filingYear);

			//更新人员
			dbYearreport.setUpdateBy(arsUtil.getCurrentUser().getUsername());

			yearreportdataDAO.update(dbYearreport);

			if(yearreportdata.getZc()!=null && yearreportdata.getZc().equals("002")) {
				yearreportdata.setApprovalstate(ApprovalState.WTJ);
				yearreportdata.setUpdateTime(new Date());
				saveStatistics(yearreportdata);
			}
		}
	}

	@Override
	public  PersonPolicyDto getPersonPolicyReportByCompanyId(){
		User currentUser = arsUtil.getCurrentUser();
		SecurityCompany dbcompany = null;

		if(currentUser.getPlatform() == 2){
			dbcompany = companyDao.findByUserid(currentUser.getId());
		}
    	return  personDao.getPersonPolicyReportByCompanyId(dbcompany.getId());
	}

    @Override
    public void saveOrUpdate(Yearreportdata yearreportdata) {
		User currentUser = arsUtil.getCurrentUser();

		/**
		 * 最后一级机构id处理
		 */
		if(yearreportdata.getOrgid() == null){
			if(yearreportdata.getDistrictOrgId() != null){
				yearreportdata.setOrgid(Long.parseLong(yearreportdata.getDistrictOrgId()));
			}else if(yearreportdata.getCityOrgId() != null){
				yearreportdata.setOrgid(Long.parseLong(yearreportdata.getCityOrgId()));
			}
		}

		if(currentUser.getPlatform() == 2 || currentUser.getPlatform() == 4){
			yearreportdata.setUserid(currentUser.getId());
		}

        if(yearreportdata.getId() == null) {
            //服务
            yearreportdata.setActive(true);
            yearreportdata.setCreateTime(new Date());
            yearreportdata.setUpdateTime(new Date());
            if(StringUtil.isEmpty(yearreportdata.getApprovalstate())) {
                if ("002".equals(yearreportdata.getZc())){
                    yearreportdata.setApprovalstate(ApprovalState.WTJ);
                }
            }
//          备案年份：去年的11月1到明年的11月1号之前提交的都算去年，比如2017年份的是从2017年11月1号到2018年11月1号之前提提交的都是2017年份的。
            String filingYear = getFilingYear();
            
            yearreportdata.setFilingYear(filingYear);
            yearreportdata.setUpdateBy(arsUtil.getCurrentUser().getUsername());

            SecurityCompany company = companyDao.findByUserid(arsUtil.getCurrentUser().getId());
            if(company != null){
            	yearreportdata.setCompanyname(company.getName());
            	yearreportdata.setAreaCode(company.getAreaCode());
            }
            
            yearreportdataDAO.save(yearreportdata);
            //保险
            if(yearreportdata.isLineInsure()){
            	saveInsuranceCompany(yearreportdata);
            }

            //保存总经理信息
            saveManager(yearreportdata);
            //非暂存，则保存其信息
            if(yearreportdata.getZc()!=null && yearreportdata.getZc().equals("002")) {
                saveStatistics(yearreportdata);
            }
        }else{
            
        	Yearreportdata dbYearreport = yearreportdataDAO.findById(yearreportdata.getId());
            dbYearreport.setApprovalstate(yearreportdata.getApprovalstate());
			dbYearreport.setApprovaldate(yearreportdata.getApprovaldate());
        	dbYearreport.setApprovalfile(yearreportdata.getApprovalfile());
        	dbYearreport.setApprovalperson(yearreportdata.getApprovalperson());
        	dbYearreport.setApprovalreason(yearreportdata.getApprovalreason());
        	dbYearreport.setBjly(yearreportdata.getBjly());
        	dbYearreport.setBzcgpic(yearreportdata.getBzcgpic());
        	dbYearreport.setDxbayrs(yearreportdata.getDxbayrs());
        	dbYearreport.setDyhdnr(yearreportdata.getDyhdnr());
        	dbYearreport.setDyrs(yearreportdata.getDyrs());
        	dbYearreport.setFbq(yearreportdata.getFbq());
        	dbYearreport.setFeducation(yearreportdata.getFeducation());
        	dbYearreport.setFpfpic(yearreportdata.getFpfpic());
        	dbYearreport.setFpzpic(yearreportdata.getFpzpic());
        	dbYearreport.setFtbx(yearreportdata.getFtbx());
        	dbYearreport.setGdzc(yearreportdata.getGdzc());
        	dbYearreport.setGmsbrs(yearreportdata.getGmsbrs());
        	dbYearreport.setGsbx(yearreportdata.getGsbx());
        	dbYearreport.setJyywrs(yearreportdata.getJyywrs());
        	dbYearreport.setKhsl(yearreportdata.getKhsl());
        	dbYearreport.setNdbg(yearreportdata.getNdbg());
        	dbYearreport.setNlx(yearreportdata.getNlx());
        	dbYearreport.setNyye(yearreportdata.getNyye());
        	dbYearreport.setSfdjzz(yearreportdata.getSfdjzz());
        	dbYearreport.setSffzbj(yearreportdata.getSffzbj());
        	dbYearreport.setSffzsg(yearreportdata.getSffzsg());
        	dbYearreport.setSfzqqc(yearreportdata.getSfzqqc());
        	dbYearreport.setSjczgz(yearreportdata.getSjczgz());
        	dbYearreport.setSqgbzrs(yearreportdata.getSqgbzrs());
        	dbYearreport.setSshijbzrs(yearreportdata.getSshijbzrs());
        	dbYearreport.setSsjbzrs(yearreportdata.getSsjbzrs());
        	dbYearreport.setSybx(yearreportdata.getSybx());
        	dbYearreport.setSyebx(yearreportdata.getSyebx());
        	dbYearreport.setSzacrs(yearreportdata.getSzacrs());
        	dbYearreport.setSzgpxrs(yearreportdata.getSzgpxrs());
        	dbYearreport.setTgpaxs(yearreportdata.getTgpaxs());
        	
//        	dbYearreport.setWgmsbrs(yearreportdata.getWgmsbrs());
        	
        	dbYearreport.setWhjjss(yearreportdata.getWhjjss());
        	dbYearreport.setWtzlhd(yearreportdata.getWtzlhd());
        	dbYearreport.setWtzlhdrc(yearreportdata.getWtzlhdrc());
        	dbYearreport.setSjczgzrc(yearreportdata.getSjczgzrc());
        	dbYearreport.setWz(yearreportdata.getWz());
        	dbYearreport.setWzmc(yearreportdata.getWzmc());
        	dbYearreport.setXgqpxrs(yearreportdata.getXgqpxrs());
        	dbYearreport.setXjg(yearreportdata.getXjg());
        	dbYearreport.setXpxrs(yearreportdata.getXpxrs());
        	dbYearreport.setXzgpxrs(yearreportdata.getXzgpxrs());
        	dbYearreport.setYcc(yearreportdata.getYcc());
        	dbYearreport.setYfszsg(yearreportdata.getYfszsg());
        	dbYearreport.setYgfsrs(yearreportdata.getYgfsrs());
        	dbYearreport.setYgxxrs(yearreportdata.getYgxxrs());
        	dbYearreport.setYlaobx(yearreportdata.getYlaobx());
        	dbYearreport.setYlbx(yearreportdata.getYlbx());
        	dbYearreport.setZbqkqt(yearreportdata.getZbqkqt());
        	dbYearreport.setZhxyr(yearreportdata.getZhxyr());
        	dbYearreport.setZjjk(yearreportdata.getZjjk());
        	dbYearreport.setZjxszrrs(yearreportdata.getZjxszrrs());
        	
        	dbYearreport.setMalenum(yearreportdata.getMalenum());
        	dbYearreport.setEscortnum(yearreportdata.getEscortnum());
        	dbYearreport.setArmnum(yearreportdata.getArmnum());
        	dbYearreport.setFemalenum(yearreportdata.getFemalenum());
        	dbYearreport.setPersonnum(yearreportdata.getPersonnum());
        	dbYearreport.setCjnum(yearreportdata.getCjnum());
        	dbYearreport.setZjnum(yearreportdata.getZjnum());
        	dbYearreport.setGjnum(yearreportdata.getGjnum());
        	dbYearreport.setManagernum(yearreportdata.getManagernum());
        	dbYearreport.setGjmanagernum(yearreportdata.getGjmanagernum());
        	dbYearreport.setCertificateCount(yearreportdata.getCertificateCount());
        	
        	dbYearreport.setLineInsure(yearreportdata.isLineInsure());
        	dbYearreport.setSzss(yearreportdata.getSzss());
        	dbYearreport.setProvince(yearreportdata.getProvince());
        	dbYearreport.setCity(yearreportdata.getCity());
        	dbYearreport.setDistrict(yearreportdata.getDistrict());
        	dbYearreport.setOrgid(yearreportdata.getOrgid());
			dbYearreport.setCityOrgId(yearreportdata.getCityOrgId());
			dbYearreport.setDistrictOrgId(yearreportdata.getDistrictOrgId());

        	if(StringUtil.isNotEmpty(yearreportdata.getZc())){
        		dbYearreport.setZc(yearreportdata.getZc());
        	}
        	dbYearreport.setUpdateTime(new Date());
        	String filingYear = getFilingYear();
            
            dbYearreport.setFilingYear(filingYear);

            //更新人员
            dbYearreport.setUpdateBy(arsUtil.getCurrentUser().getUsername());
            
            yearreportdataDAO.update(dbYearreport);
            //保存保险信息
            if(yearreportdata.isLineInsure()){
            	saveInsuranceCompany(yearreportdata);
            }
            //保存总经理信息
            saveManager(yearreportdata);

            if(yearreportdata.getZc()!=null && yearreportdata.getZc().equals("002")) {
                yearreportdata.setApprovalstate(ApprovalState.WTJ);
                yearreportdata.setUpdateTime(new Date());
                saveStatistics(yearreportdata);
            }
        }
    }
    
    public void saveStatistics(Yearreportdata yearreportdata){
    	
    	User currentUser = arsUtil.getCurrentUser();
    	SecurityCompany dbcompany = null;

		if(currentUser.getPlatform() == 2){
			dbcompany = companyDao.findByUserid(currentUser.getId());
		}
		
		if(dbcompany != null){
			//企业基本信息
            String securityScopeStr ="";
			String securityScopes = dbcompany.getSecurityScopeType();
			if(StringUtil.isNotEmpty(securityScopes)) {
				for (String securityScope : securityScopes.split(",")) {
					if (StringUtil.isEmpty(securityScopeStr)) {
						securityScopeStr = SysBaseUtil.getDictLabel("securityScopeType", securityScope);
					} else {
						securityScopeStr = securityScopeStr + "," + SysBaseUtil.getDictLabel("securityScopeType", securityScope);
					}
				}
			}
            
            yearreportdata.setCompanyname(dbcompany.getName());
            yearreportdata.setAreaCode(dbcompany.getAreaCode());
            yearreportdata.setLegalPhone(dbcompany.getUser().getPhone());
            yearreportdata.setLegalPerson(dbcompany.getLegalPerson());
            yearreportdata.setLegalPersonNo(dbcompany.getLegalPersonNo());
            yearreportdata.setPublicSecurityLicenseNumber(dbcompany.getPublicSecurityLicenseNumber());
            yearreportdata.setSecurityScope(securityScopeStr);
            yearreportdata.setSocialCode(dbcompany.getSocialCode());
            yearreportdata.setTel(dbcompany.getTel());
            yearreportdata.setLocation(dbcompany.getLocation());
            //注册资金
            if(dbcompany.getRegisteredMoney()!=null) {
				yearreportdata.setRegisteredMoney(dbcompany.getRegisteredMoney().toString());
			}
            yearreportdata.setPostalcode(dbcompany.getPostalcode());
			
			/***
	         * 获取每人月学时
	         */
//	        Config coninsConfig = configService.findByKey(Constants.TRAIN);
////	        Config trackidConfig = configService.findByKey("trackid");
//
//	        String url = coninsConfig.getValue()  + ThirdPartyURL.testTrainRport+"?companyid="+dbcompany.getId()+"&trackid=8";
//	        String resultStr = messageUtils.getJsonByInternet(url);
//	        JSONObject resultjson = (JSONObject)JSONObject.parse(resultStr);
//	        if(null!=resultjson){
//				JSONObject resultData = (JSONObject)resultjson.get("data");
//				String zgzsTrainCount = resultData.getString("zgzsTrainCount");
//				if(StringUtil.isNotEmpty(zgzsTrainCount)) {
//					yearreportdata.setSgqpxrs(zgzsTrainCount);
//				}else{
//					yearreportdata.setSgqpxrs("0");
//				}
//
//				String onGuardCount = resultData.getString("onGuardCount");
//				if(StringUtil.isNotEmpty(onGuardCount)) {
//					yearreportdata.setSzgpxrs(onGuardCount);
//				}else{
//					yearreportdata.setSzgpxrs("0");
//				}
//
//				Long xspxrs = Long.parseLong(yearreportdata.getSgqpxrs())+Long.parseLong(yearreportdata.getSzgpxrs());
//				yearreportdata.setXspxrs(xspxrs.toString());
//
//				//平均学时
//				String  periodAvgMonth = resultData.getString("periodAvgMonth");
//				if(StringUtil.isNotEmpty(periodAvgMonth)) {
//					Double hours = Double.parseDouble(periodAvgMonth)/60;
//					DecimalFormat    df   = new DecimalFormat("#0.00");
//					yearreportdata.setMryxs(df.format(hours));
//				}else{
//					yearreportdata.setMryxs("0");
//				}
//			}





			PersonLevelDto personLevel = personDao.dataStatisticsLevelCountReport(dbcompany.getId());
			//统计男保安员
            Long malenum = personDao.countManByCompanyId(dbcompany.getId());
            //统计女保安员
            Long femalenum = Long.parseLong(personLevel.getPersonnum()) -malenum;
            //统计武装押运人员
            Long escortnum = personDao.countArmPersonByCompanyId(dbcompany.getId());
            
            yearreportdata.setMalenum(malenum.toString());
            yearreportdata.setFemalenum(femalenum.toString());
			yearreportdata.setPersonnum(personLevel.getPersonnum());
			yearreportdata.setEscortnum(escortnum.toString());
			
	    	Long personCount = personDao.countPersonByCompanyId(dbcompany.getId());
			Long initCount = personDao.countInitPersonByCompanyId(dbcompany.getId());
			Long authCount = personDao.countAuthPersonByCompanyId(dbcompany.getId());
			Long unAuthCount = personDao.countUnAuthPersonByCompanyId(dbcompany.getId());

            //是否录入出资人信息
            InvestorSearchDto investorSearchDto =new InvestorSearchDto();
            investorSearchDto.setUserid(dbcompany.getUser().getId());
            if(investorDao.searchCount(investorSearchDto)>0){
                yearreportdata.setInvestor("1");
            }else{
                yearreportdata.setInvestor("0");
            }

            //是否录入分公司信息
            SbSubsidiaryBaseSearchDto sbSubsidiaryBaseSearchDto = new SbSubsidiaryBaseSearchDto();
            sbSubsidiaryBaseSearchDto.setUserid(dbcompany.getUser().getId());
            if(sbSubsidiaryBaseDao.count(sbSubsidiaryBaseSearchDto)>0){
                yearreportdata.setBranch("1");
            }else{
                yearreportdata.setBranch("0");
            }

            //是否录入管理层信息
            ManagementInfoSearchDto managementInfoSearchDto = new ManagementInfoSearchDto();
            managementInfoSearchDto.setUserid(dbcompany.getUser().getId());
            if(managementInfoDao.searchCount(managementInfoSearchDto)>0){
                yearreportdata.setManagement("1");
            }else{
                yearreportdata.setManagement("0");
            }
            //是否录入服务合同信息
			ComContractSearchDto dto = new ComContractSearchDto();
			dto.setComId(Long.parseLong(dbcompany.getComId()));
			dto.setContractStatus(Constants.CONTRACTSTATUS_1);
			dto.setContractType(Constants.CONTRACTTYPE_COMSER);
			if(comContractDao.searchCount(dto)>0){
				yearreportdata.setServiceHt("1");
			}else{
				yearreportdata.setServiceHt("0");
			}

			//是否录入劳动合同信息
			dto.setContractType(Constants.CONTRACTTYPE_PER);
			if(comContractDao.searchCount(dto)>0){
				yearreportdata.setLaborHt("1");
			}else{
				yearreportdata.setLaborHt("0");
			}

            //车辆/枪支/技防设备信息
            VehicleSearchDto vehicleSearchDto = new VehicleSearchDto();
            vehicleSearchDto.setUserid(dbcompany.getUser().getId());
            long vehicle = vehicleDao.searchCount(vehicleSearchDto);

            FirearmsSearchDto firearmsSearchDto = new FirearmsSearchDto();
            firearmsSearchDto.setUserid(dbcompany.getUser().getId());
            long firearms = firearmsDao.searchCount(firearmsSearchDto);

            SafetySearchDto safetySearchDto = new SafetySearchDto();
            safetySearchDto.setUserid(dbcompany.getUser().getId());
            long safety = safetyDao.searchCount(safetySearchDto);

            if(vehicle>0||firearms>0||safety>0){
                yearreportdata.setDevice("1");
            }else{
                yearreportdata.setDevice("0");
            }

			yearreportdata.setPersonCount(personCount.toString());
			yearreportdata.setInitCount(initCount.toString());
			yearreportdata.setAuthCount(authCount.toString());
			yearreportdata.setUnAuthCount(unAuthCount.toString());
			
			TaskExecutionDto taskInfo = taskDao.findTaskExecutionReport(dbcompany.getId());
			yearreportdata.setTaskTotal(taskInfo.getTaskTotal());
			yearreportdata.setCycleCount(taskInfo.getCycleCount());
			yearreportdata.setTemporaryCount(taskInfo.getTemporaryCount());
			yearreportdata.setUrgentCount(taskInfo.getUrgentCount());

			PersonPolicyDto personPolicy = personDao.getPersonPolicyReportByCompanyId(dbcompany.getId());
			Long personnum = personPolicy.getPersonnum();
			Long policyCount =  personPolicy.getPolicyCount();
			Long quotaCount = personPolicy.getQuotaCount();
			
			yearReportInsuranceDao.deleteByYearReportId(yearreportdata.getId());
			
			if(!yearreportdata.isLineInsure()){
				policyCount =  personPolicy.getPolicyCount();
				quotaCount = personPolicy.getQuotaCount();
			}else{
				//线下投保
				List<SecurityCompanyInsurance> insurances = securityCompanyInsuranceDao.findByCompanyId(dbcompany.getUser().getId());
				if(insurances != null && insurances.size() > 0){
					YearReportInsurance yearReportInsurance = null;
					for (SecurityCompanyInsurance securityCompanyInsurance : insurances) {
						//保存到企业年报
						yearReportInsurance = new YearReportInsurance();
						yearReportInsurance.setYearReportId(yearreportdata.getId());
						yearReportInsurance.setActive(true);
						yearReportInsurance.setCompany_id(securityCompanyInsurance.getCompany_id());
						yearReportInsurance.setCreateTime(new Date());
						yearReportInsurance.setUpdateTime(new Date());
						yearReportInsurance.setUpdateBy(securityCompanyInsurance.getUpdateBy());
						yearReportInsurance.setEnd_date(securityCompanyInsurance.getEnd_date());
						yearReportInsurance.setFlfy(securityCompanyInsurance.getFlfy());
						yearReportInsurance.setInsurance_company(securityCompanyInsurance.getInsurance_company());
						yearReportInsurance.setInsurance_number(securityCompanyInsurance.getInsurance_number());
						yearReportInsurance.setInsurance_pic(securityCompanyInsurance.getInsurance_pic());
						yearReportInsurance.setInsurance_product(securityCompanyInsurance.getInsurance_product());
						yearReportInsurance.setInsured_num(securityCompanyInsurance.getInsured_num());
						yearReportInsurance.setJtyw(securityCompanyInsurance.getJtyw());
						yearReportInsurance.setJyjt(securityCompanyInsurance.getJyjt());
						yearReportInsurance.setPremium_person(securityCompanyInsurance.getPremium_person());
						yearReportInsurance.setProtection_date(securityCompanyInsurance.getProtection_date());
						yearReportInsurance.setYwsg(securityCompanyInsurance.getYwsg());
						yearReportInsurance.setYwyl(securityCompanyInsurance.getYwyl());
						yearReportInsurance.setZdcj(securityCompanyInsurance.getZdcj());
						yearReportInsuranceDao.save(yearReportInsurance);
						
						//统计
						Long ywsg = Long.parseLong(securityCompanyInsurance.getYwsg());
						Long insured_num = Long.parseLong(securityCompanyInsurance.getInsured_num());
						policyCount = policyCount + insured_num;
						if(ywsg >= 370000l){
							quotaCount = quotaCount + insured_num;
						}
					}
				}
				if(StringUtil.isNotEmpty(yearreportdata.getQuotaCount())){
					quotaCount = Long.parseLong(yearreportdata.getQuotaCount());
				}
			}
			
			if(policyCount > personnum){
				policyCount = personnum;
			}
			if(quotaCount > policyCount){
				quotaCount = policyCount;
			}
			
			Long unPolicyCount = personnum - policyCount;
			Long unQuotaCount = policyCount - quotaCount;
			
			yearreportdata.setUnPolicyCount(unPolicyCount.toString());
			yearreportdata.setPolicyCount(policyCount.toString());
			yearreportdata.setQuotaCount(quotaCount.toString());
			yearreportdata.setUnQuotaCount(unQuotaCount.toString());

            List<ReportData> approvalReports = approvalDao.getTypeGroupByUserId(dbcompany.getUser().getId());
            Long personcertificateCount = 0l;
            Long crosscompanyCount = 0l;
            Long subsidiaryCount = 0l;
            Long traincompanyCount = 0l;
            Long legalchangeCount = 0l;
            Long approvalCount = 0l;
            for (ReportData reportData : approvalReports) {
                approvalCount = approvalCount + reportData.getValue();
                if(reportData.getName().equals(BusinessType.BAYZ)) {
                    personcertificateCount = reportData.getValue();
                }else if(reportData.getName().equals(BusinessType.KQYBAGS)) {
                    crosscompanyCount = reportData.getValue();
                }else if(reportData.getName().equals(BusinessType.BAGSZGS)) {
                    subsidiaryCount = reportData.getValue();
                }else if(reportData.getName().equals(BusinessType.PXDW)) {
                    traincompanyCount = reportData.getValue();
                }else if(reportData.getName().equals(BusinessType.FRBG)) {
                    legalchangeCount = reportData.getValue();
                }
            }
            yearreportdata.setApprovalCount(approvalCount.toString());
            yearreportdata.setPersoncertificateCount(personcertificateCount.toString());
            yearreportdata.setCrosscompanyCount(crosscompanyCount.toString());
            yearreportdata.setSubsidiaryCount(subsidiaryCount.toString());
            yearreportdata.setTraincompanyCount(traincompanyCount.toString());
            yearreportdata.setLegalchangeCount(legalchangeCount.toString());
            
            Long securityNum = cyServerhtDao.countGroupByServerObjByUserId(dbcompany.getUser().getId());
            yearreportdata.setSecurityNum(securityNum.toString());
            

        	Long gmsbrs = Long.parseLong(yearreportdata.getGmsbrs());
        	if(gmsbrs > personnum){
        		gmsbrs = personnum;
        	}
        	Long wgmsbrs = personnum - gmsbrs;
        	yearreportdata.setGmsbrs(gmsbrs.toString());
        	yearreportdata.setWgmsbrs(wgmsbrs.toString());
			//保存统计信息
			yearreportdataDAO.updateStatistics(yearreportdata);

			List<Investor> investors = investorDao.findByUserId(dbcompany.getUser().getId());
			yearReportinvestorDao.deleteByYearReportId(yearreportdata.getId());
			YearReportInvestor yearReportInvestor = null;
			for (Investor investor : investors) {
				yearReportInvestor = new YearReportInvestor();
				yearReportInvestor.setActive(true);
				yearReportInvestor.setAddress(investor.getAddress());
				yearReportInvestor.setChangeRecord(investor.getChangeRecord());
				yearReportInvestor.setCreateTime(new Date());
				yearReportInvestor.setFundedNumber(investor.getFundedNumber());
				yearReportInvestor.setIdNumber(investor.getIdNumber());
				yearReportInvestor.setInvestorsType(investor.getInvestorsType());
				yearReportInvestor.setName(investor.getName());
				yearReportInvestor.setNation(investor.getNation());
				yearReportInvestor.setNational(investor.getNational());
				yearReportInvestor.setNowaddress(investor.getNowaddress());
				yearReportInvestor.setPhone(investor.getPhone());
				yearReportInvestor.setRatioBefor(investor.getRatioBefor());
				yearReportInvestor.setRatioTransfer(investor.getRatioTransfer());
				yearReportInvestor.setSex(investor.getSex());
				yearReportInvestor.setShareholderBefore(investor.getShareholderBefore());
				yearReportInvestor.setStockProportion(investor.getStockProportion());
				yearReportInvestor.setTransferTime(investor.getTransferTime());
				yearReportInvestor.setUpdateBy(investor.getUpdateBy());
				yearReportInvestor.setUpdateTime(new Date());
				yearReportInvestor.setUserid(investor.getUserid());
				yearReportInvestor.setYearReportId(yearreportdata.getId());
				
				yearReportinvestorDao.save(yearReportInvestor);
			}
			
		}
    }
    
    public void saveManager(Yearreportdata yearreportdata) {
		User currentUser= arsUtil.getCurrentUser();
		if(yearreportdata.getGeneralList() != null && yearreportdata.getGeneralList().size()>0){
			//1先删除原有的
			yearreportdataManagerDAO.del(arsUtil.getCurrentUser().getId());
        	for(YearreportdataManager yearreportdataManager:yearreportdata.getGeneralList()){
        		if(yearreportdataManager == null || StringUtil.isEmpty(yearreportdataManager.getGeneralmanager())){
        			continue;
				}
				yearreportdataManager.setActive(true);
				yearreportdataManager.setCreateTime(new Date());
				yearreportdataManager.setUpdateTime(new Date());
				yearreportdataManager.setUserid(currentUser.getId());
				yearreportdataManager.setUpdateBy(currentUser.getUsername());
				yearreportdataManagerDAO.save(yearreportdataManager);
			}
		}
		if(yearreportdata.getViceGeneralList() != null && yearreportdata.getViceGeneralList().size()>0){
			for(YearreportdataManager yearreportdataManager:yearreportdata.getViceGeneralList()){
				if(yearreportdataManager == null || StringUtil.isEmpty(yearreportdataManager.getGeneralmanager())){
					continue;
				}
				yearreportdataManager.setActive(true);
				yearreportdataManager.setCreateTime(new Date());
				yearreportdataManager.setUpdateTime(new Date());
				yearreportdataManager.setUserid(currentUser.getId());
				yearreportdataManager.setUpdateBy(currentUser.getUsername());
				yearreportdataManagerDAO.save(yearreportdataManager);
			}
		}

    }


    /**
     * 保存保险信息
     *
     * @param yearreportdata
     */
    public void saveInsuranceCompany(Yearreportdata yearreportdata) {
        //获得保安公司保险信息
		String[] insurance_company = new String[0],insurance_product = new String[0],protection_date= new String[0],insured_num= new String[0],premium_person= new String[0],
		ywsg= new String[0],jtyw= new String[0],ywyl= new String[0],zdcj= new String[0],jyjt= new String[0],flfy= new String[0],end_date= new String[0],insurance_pic= new String[0],insurance_number= new String[0];
		if (!StringUtils.isEmpty(yearreportdata.getInsurance_company())) {
			 insurance_company = yearreportdata.getInsurance_company().split(",");
		}
		if (!StringUtils.isEmpty(yearreportdata.getInsurance_product())) {
			insurance_product = yearreportdata.getInsurance_product().split(",");
		}
		if (!StringUtils.isEmpty(yearreportdata.getProtection_date())) {
			protection_date = yearreportdata.getProtection_date().split(",");
		}
		if (!StringUtils.isEmpty(yearreportdata.getInsured_num())) {
			insured_num = yearreportdata.getInsured_num().split(",");
		}
		if (!StringUtils.isEmpty(yearreportdata.getPremium_person())) {
			premium_person = yearreportdata.getPremium_person().split(",");
		}

		if (!StringUtils.isEmpty(yearreportdata.getYwsg())) {
			 ywsg = yearreportdata.getYwsg().split(",");
		}
		if (!StringUtils.isEmpty(yearreportdata.getJtyw())) {
			jtyw = yearreportdata.getJtyw().split(",");
		}
		if (!StringUtils.isEmpty(yearreportdata.getYwyl())) {
			ywyl = yearreportdata.getYwyl().split(",");
		}
		if (!StringUtils.isEmpty(yearreportdata.getZdcj())) {
			zdcj = yearreportdata.getZdcj().split(",");
		}

		if (!StringUtils.isEmpty(yearreportdata.getJyjt())) {
			jyjt = yearreportdata.getJyjt().split(",");
		}

		if (!StringUtils.isEmpty(yearreportdata.getFlfy())) {
			flfy = yearreportdata.getFlfy().split(",");
		}

		if (!StringUtils.isEmpty(yearreportdata.getEnd_date())) {
			end_date = yearreportdata.getEnd_date().split(",");
		}

		if (!StringUtils.isEmpty(yearreportdata.getInsurance_pic())) {
			insurance_pic = yearreportdata.getInsurance_pic().split(",");
		}

		if (!StringUtils.isEmpty(yearreportdata.getInsurance_number())) {
			insurance_number = yearreportdata.getInsurance_number().split(",");
		}

            int[] a = {insurance_company.length,insurance_product.length,protection_date.length,insured_num.length,premium_person.length,ywsg.length,jtyw.length,ywyl.length,zdcj.length,jyjt.length,flfy.length,end_date.length,insurance_number.length};
            int count = StringUtil.getMax(a);
            //保存保安公司保险信息
            if (count > 0) {
                //1先删除原有的
                securityCompanyInsuranceDao.deleteBySid(arsUtil.getCurrentUser().getId());
                for (int i = 0; i < count; i++) {
                    SecurityCompanyInsurance securityCompanyInsurance = new SecurityCompanyInsurance();
                    securityCompanyInsurance.setActive(true);
                    securityCompanyInsurance.setCreateTime(new Date());
                    securityCompanyInsurance.setUpdateTime(new Date());
                    securityCompanyInsurance.setUpdateBy(arsUtil.getCurrentUser().getUsername());
                    securityCompanyInsurance.setCompany_id(arsUtil.getCurrentUser().getId());
                    //判断是否非空，非空则保存
                    if (!StringUtils.isEmpty(yearreportdata.getProtection_date())) {
                        if(protection_date.length>i && !protection_date[i].equals("")){
                            securityCompanyInsurance.setProtection_date(protection_date[i]);
                        }
                    }
                    if (!StringUtils.isEmpty(yearreportdata.getPremium_person())) {
                        if(premium_person.length>i){
                            if(!premium_person[i].equals("")){
                                securityCompanyInsurance.setPremium_person(premium_person[i]);
                            }
                        }

                    }
                    if (!StringUtils.isEmpty(yearreportdata.getInsured_num())) {
                        if(insured_num.length>i){
                            if(!insured_num[i].equals("")){
                                securityCompanyInsurance.setInsured_num(insured_num[i]);
                            }
                        }

                    }
                    if (!StringUtils.isEmpty(yearreportdata.getInsurance_product())) {
                        if(insurance_product.length>i){
                            securityCompanyInsurance.setInsurance_product(insurance_product[i]);
                        }

                    }
                    if (!StringUtils.isEmpty(yearreportdata.getInsurance_company())) {
                        if(insurance_company.length>i){
                            securityCompanyInsurance.setInsurance_company(insurance_company[i]);
                        }
                    }
                    if (!StringUtils.isEmpty(yearreportdata.getYwsg())) {
                        if(ywsg.length>i){
                            securityCompanyInsurance.setYwsg(ywsg[i]);
                        }
                    }

                    if (!StringUtils.isEmpty(yearreportdata.getJtyw())) {
                        if(jtyw.length>i){
                            securityCompanyInsurance.setJtyw(jtyw[i]);
                        }
                    }

                    if (!StringUtils.isEmpty(yearreportdata.getYwyl())) {
                        if(ywyl.length>i){
                            securityCompanyInsurance.setYwyl(ywyl[i]);
                        }
                    }

                    if (!StringUtils.isEmpty(yearreportdata.getZdcj())) {
                        if(zdcj.length>i){
                            securityCompanyInsurance.setZdcj(zdcj[i]);
                        }
                    }


                    if (!StringUtils.isEmpty(yearreportdata.getJyjt())) {
                        if(jyjt.length>i){
                            securityCompanyInsurance.setJyjt(jyjt[i]);
                        }
                    }

                    if (!StringUtils.isEmpty(yearreportdata.getFlfy())) {
                        if(flfy.length>i){
                            securityCompanyInsurance.setFlfy(flfy[i]);
                        }
                    }

                    if (!StringUtils.isEmpty(yearreportdata.getEnd_date())) {
                        if(end_date.length>i){
                            securityCompanyInsurance.setEnd_date(end_date[i]);
                        }
                    }


                    if (!StringUtils.isEmpty(yearreportdata.getInsurance_number())) {
                        if(insurance_number.length>i){
                            securityCompanyInsurance.setInsurance_number(insurance_number[i]);
                        }
                    }
                    if (!StringUtils.isEmpty(yearreportdata.getInsurance_pic())) {
                        if(insurance_pic.length>i){
                            securityCompanyInsurance.setInsurance_pic(insurance_pic[i]);
                        }
                    }
                    securityCompanyInsuranceDao.save(securityCompanyInsurance);
                }
        }
    }
    
	@Override
	public Yearreportdata findById(Long businessid) {
       Yearreportdata result =  yearreportdataDAO.findById(businessid);
        if(result!=null) {


            YearreportdataManager querydto = new YearreportdataManager();
            querydto.setUserid(result.getUserid());
            //查询总经理
            querydto.setManagertype("001");
            result.setManges(yearreportdataManagerDAO.findByUserId(querydto));
            //查询副总经理
            querydto.setManagertype("002");
            result.setFontmanges(yearreportdataManagerDAO.findByUserId(querydto));
            
            //保险信息
            result.setInsuranceList(yearReportInsuranceDao.findByYearReportId(result.getId()));
            
            //出资人信息
            result.setInvestorList(yearReportinvestorDao.findByYearReportId(result.getId()));

			Approval approval = approvalDao.findBybusinessidAndType(businessid,BusinessType.NDBG);
			result.setApproval(approval);

			//查询机构信息
			Police police = policeDao.findById(result.getOrgid());
			result.setPolice(police);
            
        }
        
        return result;

	}
	
	@Override
	public List<Yearreportdata> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
		return yearreportdataDAO.searchForDataSynchronization(searchDto);
	}
	
	@Override
	public void saveOrUpdateForDS(Yearreportdata yearreport) {
		if(yearreport.getActive() == null){
    		yearreport.setActive(true);
    	}
    	
		Yearreportdata dbYearreport = yearreportdataDAO.findById(yearreport.getId());
        if (dbYearreport != null) {
        	if(yearreport.getUpdateTime().getTime() > dbYearreport.getUpdateTime().getTime()){
        		yearreportdataDAO.update(yearreport);
			}
        } else {
        	yearreportdataDAO.save(yearreport);
        }
	}
    /**
     * 查询企业年报数据统计
     * @param searchDto
     * @return
     */
    @Override
    public PageResult queryYearReportList(YearReportsSearchDto searchDto) {
        //测试临时注释，避免过滤掉数据
        User currentUser = arsUtil.getCurrentUser();
		searchDto.setPath(currentUser.getPolice().getPath());
		searchDto.setUserid(currentUser.getId());
        String areacode =  searchDto.getAreaCode();
        if(StringUtil.isNotEmpty(areacode)) {
            if(areacode.endsWith("0000")){//省
                searchDto.setAreaCode(areacode.substring(0,2)+"____");
            }else if(areacode.endsWith("00")){//市
                searchDto.setAreaCode(areacode.substring(0,4)+"__");
            }else{//区
                searchDto.setAreaCode(areacode);
            }
        }
        List<YearReportDto> yearReports= yearreportdataDAO.yearReportSearch(searchDto);

        return new PageResult(yearreportdataDAO.yearReportSearchCount(searchDto).intValue(), yearReports);
    }

    @Override
    public void updateOperator(Yearreportdata yearreportdata) {
		User currentUser = arsUtil.getCurrentUser();
        Yearreportdata dbYearreportdata = yearreportdataDAO.findById(yearreportdata.getId());
        dbYearreportdata.setUpdateBy(currentUser.getUsername());
        dbYearreportdata.setUpdateTime(new Date());
        //经办人及联系方式

        dbYearreportdata.setOperatorname(yearreportdata.getOperatorname());
        dbYearreportdata.setOperatorphone(yearreportdata.getOperatorphone());
        dbYearreportdata.setApprovalstate(ApprovalState.DSH);
        //申请时间
        dbYearreportdata.setApplydate(new Date());
        yearreportdataDAO.updateOperator(dbYearreportdata);
		/***
		 * 根据不同的保安公司类型获取对应的key,默认为保安服务公司
		 */
		String  processKey =  Constants.ACTIVITI_PROCESS_YEARREPORT;
		SecurityCompany company = companyDao.findByUserid(dbYearreportdata.getUserid());
		if(company != null && StringUtil.isNotEmpty(company.getSponsorlicenseType())) {
			processKey =  BusinessType.getBusinessTypeName(BusinessType.NDBG, company.getSponsorlicenseType());
		}

        //保存审批信息
        approvalUtil.saveApproval(BusinessType.NDBG, dbYearreportdata.getId(), processKey);
    }
    
	@Override
	public void updateSealState(Long yearReportId, String sealState) {
		Yearreportdata dbYearreportdata = yearreportdataDAO.findById(yearReportId);
		dbYearreportdata.setFilingIsStamped(sealState);
		dbYearreportdata.setUpdateTime(new Date());
		yearreportdataDAO.updateSealState(dbYearreportdata);
	}
	
	@Override
	public YearReportsSearchDto search(YearReportsSearchDto searchDto) {
		User currentUser = arsUtil.getCurrentUser();
		searchDto.setPath(currentUser.getPolice().getPath());
		searchDto.setUserid(currentUser.getId());
		String areacode =  searchDto.getAreaCode();
        if(StringUtil.isNotEmpty(areacode)) {
            if(areacode.endsWith("0000")){//省
                searchDto.setAreaCode(areacode.substring(0,2)+"____");
            }else if(areacode.endsWith("00")){//市
                searchDto.setAreaCode(areacode.substring(0,4)+"__");
            }else{//区
                searchDto.setAreaCode(areacode);
            }
        }
        List<YearReportDto> yearReports= yearreportdataDAO.yearReportSearch(searchDto);
        searchDto.setTotalCount(yearreportdataDAO.yearReportSearchCount(searchDto));
        searchDto.setData(yearReports);
        return searchDto;
	}

    /**
     * 查询用户信息发短信
     *
     * @param businessid
     * @return
     */
    @Override
    @Deprecated
    public Yearreportdata findByIdForSendMessage(Long businessid) {
        Yearreportdata result = yearreportdataDAO.findById(businessid);

        return result;
    }
    
    /**
     * 发短信通知
     *
     * @param yearreportdata
     * @return
     */
    @Override
    public void sendMessage(Yearreportdata yearreportdata) {

    }
    
	@Override
	public void saveOrUpdateForApproval(Yearreportdata yearreport) {
		yearreport.setUpdateTime(new Date());
		yearreportdataDAO.update(yearreport);
	}
    /**
     *给为填写年报公司的法人发信息提示
     */
    @Override
    public void sendMessageForLegalPerson(String userId) {



    }
    
    @Override
	public Boolean checkOnLinePolicy() {
		Boolean result = false;
		User currentUser = arsUtil.getCurrentUser();
    	SecurityCompany dbcompany = null;

		if(currentUser.getPlatform() == 2){
			dbcompany = companyDao.findByUserid(currentUser.getId());
		}
		if(dbcompany != null){
			Long policyCount = personDao.findPolicyByCompanyId(dbcompany.getId());
			if(policyCount != null && policyCount > 0l){
				result = true;
			}
		}
		return result;
	}
	
	@Override
	public Boolean checkInvestorInput() {
		Boolean result = false;
		User currentUser = arsUtil.getCurrentUser();
    	SecurityCompany dbcompany = null;

		if(currentUser.getPlatform() == 2){
			dbcompany = companyDao.findByUserid(currentUser.getId());
		}
		if(dbcompany != null){
			InvestorSearchDto dto = new InvestorSearchDto();
			dto.setUserid(dbcompany.getUser().getId());
			Long investorCount = investorDao.searchCount(dto);
			if(investorCount != null && investorCount > 0l){
				result = true;
			}
		}
		return result;
	}

	@Override
	public void updatePoliceId(Yearreportdata yearreportdata) {
		Approval approval =  approvalDAO.getById(yearreportdata.getApprovalId());
		/***
		 * 更新
		 */
		approval.setPoliceid(yearreportdata.getPoliceid());
		approval.setRoleid(null);
		approval.setUpdateTime(new Date());
		approvalDAO.update(approval);
		yearreportdataDAO.updatePoliceId(yearreportdata);
	}
	
	@Override
	public PageResult queryTable(YearReportsSearchDto searchDto) {
		User currentUser = arsUtil.getCurrentUser();

		//机构信息
		Police police = currentUser.getPolice();
		if (police != null) {
			String areacode = police.getAreacode();
			if (areacode.endsWith("0000")) {//省
				searchDto.setDistrict(areacode.substring(0, 2) + "____");
			} else if (areacode.endsWith("00")) {//市
				searchDto.setDistrict(areacode.substring(0, 4) + "__");
			} else {//区
				searchDto.setDistrict(areacode);
			}

		}

        String areacode =  searchDto.getAreaCode();
        if(StringUtil.isNotEmpty(areacode)) {
            if(areacode.endsWith("0000")){//省
                searchDto.setAreaCode(areacode.substring(0,2)+"____");
            }else if(areacode.endsWith("00")){//市
                searchDto.setAreaCode(areacode.substring(0,4)+"__");
            }else{//区
                searchDto.setAreaCode(areacode);
            }
        }
		searchDto.setUserid(currentUser.getId());
		if (searchDto.getCheckType()!=null) {
			User user = arsUtil.getCurrentUser();

			if (user != null) {
					searchDto.setUserid(user.getId());
				if (user.getPlatform() == 2) {
					searchDto.setUserid(user.getId());
				}else{
					//角色列表
					List<PoliceRole> roles = user.getRoles();
					if(roles!=null&&roles.size()>0) {
						searchDto.setRoles(roles);
					}
				}
			}
		}
        searchDto.setPath(currentUser.getPolice().getPath());

        List<YearReportDataDto> yearReports= yearreportdataDAO.queryTable(searchDto);
        return new PageResult(yearreportdataDAO.queryTableCount(searchDto).intValue(),yearReports);
	}

	@Override
	public void saveOrUpdateForApprovalImport(Yearreportdata yearreport) {
		yearreportdataDAO.update(yearreport);
	}

	/**
	 * 公安角色修改保存
	 * 机构选择若有变更重启流程
	 * @param yearreportdata
	 */
	@Override
	public void edit(Yearreportdata yearreportdata) {
    	if(yearreportdata.getId() != null) {
			Yearreportdata dbYearreportdata = findById(yearreportdata.getId());
			boolean activity = false;
			if(StringUtil.isNotEmpty(dbYearreportdata.getApprovalstate()) && dbYearreportdata.getApprovalstate().equals(ApprovalState.DSH)){
				if(!dbYearreportdata.getOrgid().toString().equals(yearreportdata.getOrgid().toString())){
					activity = true;
				}
			}
			yearreportdata.setApprovalstate(ApprovalState.DSH);
			saveOrUpdate(yearreportdata);
			//保存审批信息
			if(activity) {
				/***
				 * 根据不同的保安公司类型获取对应的key,默认为保安服务公司
				 */
				String  processKey =  Constants.ACTIVITI_PROCESS_YEARREPORT;
				SecurityCompany company = companyDao.findById(dbYearreportdata.getCompanyid());
				if(company != null && StringUtil.isNotEmpty(company.getSponsorlicenseType())) {
					processKey =  BusinessType.getBusinessTypeName(BusinessType.NDBG, company.getSponsorlicenseType());
				}
				//保存审批信息
				approvalUtil.saveApproval(BusinessType.NDBG, dbYearreportdata.getId(), processKey);
			}
		}
	}

	@Override
	public void searchForPage(YearReportsSearchDto searchDto, AjaxPageResponse<YearReportDto> page) {
		arsUtil.setPoliceSearch(searchDto);
		yearreportdataDAO.searchForPage(searchDto,page);

	}
}