package com.bcxin.ars.service.sb.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.sb.YearreportdataManagerDAO;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.sb.YearreportdataManager;
import com.bcxin.ars.service.sb.YearreportdataManagerService;
import com.bcxin.ars.service.util.ArsUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

@Transactional
@Service("yearreportdataManagerService")
@DataSyncAnnotation(getClazz = YearreportdataManager.class)
public class YearreportdataManagerServiceImpl implements YearreportdataManagerService{

    @Autowired
    private YearreportdataManagerDAO yearreportdataManagerDAO;

    @Autowired
    private ArsUtil arsUtil;
    @Override
    public void save(YearreportdataManager yearreportdataManager) {
            yearreportdataManager.setActive(true);
            yearreportdataManager.setCreateTime(new Date());
            yearreportdataManager.setUpdateTime(new Date());
            yearreportdataManager.setUpdateBy(arsUtil.getCurrentUser().getUsername());
            yearreportdataManager.setUserid(arsUtil.getCurrentUser().getId());
            yearreportdataManagerDAO.save(yearreportdataManager);
    }
    @Override
    public void del(Long userid) {
        yearreportdataManagerDAO.del(userid);
    }
    @Override
    public List<YearreportdataManager> findByUserId(YearreportdataManager yearreportdataManager) {
        return yearreportdataManagerDAO.findByUserId(yearreportdataManager);
    }
	@Override
	public List<YearreportdataManager> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
		return yearreportdataManagerDAO.searchForDataSynchronization(searchDto);
	}
	@Override
	public void saveOrUpdateForDS(YearreportdataManager yearreportdataManager) {
		if(yearreportdataManager.getActive() == null){
			yearreportdataManager.setActive(true);
    	}
    	
		YearreportdataManager dbYearreportdataManager = yearreportdataManagerDAO.findById(yearreportdataManager.getId());
        if (dbYearreportdataManager != null) {
        	if(yearreportdataManager.getUpdateTime().getTime() > dbYearreportdataManager.getUpdateTime().getTime()){
        		yearreportdataManagerDAO.updateForDS(yearreportdataManager);
			}
        } else {
        	yearreportdataManagerDAO.saveForDS(yearreportdataManager);
        }
	}
}