package com.bcxin.ars.service.sb.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.sb.WorkexperienceDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.WorkexperienceSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Workexperience;
import com.bcxin.ars.service.sb.WorkexperienceService;
import com.bcxin.ars.service.util.ArsUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

@Service
@Transactional
@DataSyncAnnotation(getClazz = Workexperience.class)
public class WorkexperienceServiceImpl implements WorkexperienceService{

	@Autowired
	private WorkexperienceDao workexperienceDao;
	
	@Autowired
	private ArsUtil arsUtil;
	
	
	@Override
	public Workexperience findById(long id) {
		return workexperienceDao.findById(id);
	}

	@Override
	public void saveOrUpdate(Workexperience workexperience) {
		User currentUser = arsUtil.getCurrentUser();
		if(workexperience.getId() == null){
			workexperience.setActive(true);
			workexperience.setCreateTime(new Date());
			workexperience.setUpdateTime(new Date());
			workexperience.setUpdateBy(currentUser.getUsername());
			workexperienceDao.save(workexperience);
		}else{
			Workexperience dbWorkexperience = workexperienceDao.findById(workexperience.getId());
			dbWorkexperience.setUpdateTime(new Date());
			dbWorkexperience.setCompanyname(workexperience.getCompanyname());
			dbWorkexperience.setEnddate(workexperience.getEnddate());
			dbWorkexperience.setPost(workexperience.getPost());
			dbWorkexperience.setStartdate(workexperience.getStartdate());
			dbWorkexperience.setUpdateBy(currentUser.getUsername());
			dbWorkexperience.setUpdateTime(new Date());
			workexperienceDao.update(dbWorkexperience);
		}
	}

	@Override
	public void saveOrUpdateForDS(Workexperience workexperience) {
		
		if(workexperience.getActive() == null){
			workexperience.setActive(true);
		}
		
		Workexperience dbWorkexperience = workexperienceDao.findById(workexperience.getId());
		if (dbWorkexperience != null) {
			if(workexperience.getUpdateTime().getTime() > dbWorkexperience.getUpdateTime().getTime()){
				workexperienceDao.update(workexperience);
			}
		} else {
			workexperienceDao.saveForDS(workexperience);
		}
	}

	@Override
	public WorkexperienceSearchDto search(WorkexperienceSearchDto dto) {
		WorkexperienceSearchDto resultDto = new WorkexperienceSearchDto();
		List<Workexperience> list =  workexperienceDao.search(dto);
		resultDto.setData(list);
		resultDto.setTotalCount(workexperienceDao.searchCount(dto));
		return resultDto;
	}

	@Override
	public List<Workexperience> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
		return  workexperienceDao.searchForDataSynchronization(searchDto);
	}

}
