package com.bcxin.ars.service.sb.impl;



import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.PoliceDao;
import com.bcxin.ars.dao.sb.TrainrecordDao;
import com.bcxin.ars.dao.sys.ApprovalDAO;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.page.TrainrecordPageSearchDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Traincompanyapply;
import com.bcxin.ars.model.sb.Trainrecord;
import com.bcxin.ars.service.sb.TrainrecordService;
import com.bcxin.ars.service.util.ApprovalUtil;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.IdWorker;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.approval.ApprovalState;
import com.bcxin.ars.util.approval.BusinessType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;

import java.util.List;

/**
 * 保安培训单位备案Service业务层处理
 * 
 * @author lin
 * @date 2022-08-14
 */
@Service
@DataSyncAnnotation(getClazz = Trainrecord.class,getMethodName="importBatch",getImportType = ImportType.BATCH)
public class TrainrecordServiceImpl implements TrainrecordService {
    
    Logger logger = LoggerFactory.getLogger(TrainrecordServiceImpl.class);

    @Autowired
    private ApprovalUtil approvalUtil;

    @Autowired
    private TrainrecordDao trainrecordDao;

    @Autowired
    private PoliceDao policeDao;


    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private ApprovalDAO approvalDAO;

    @Autowired
    private ArsUtil arsUtil;

    @Autowired
    private IdWorker idWorker;

    @Override
    public int delete(Trainrecord trainrecord) {
        User currentUser = arsUtil.getCurrentUser();
        trainrecord.setUpdateTime(new Date());
        trainrecord.setUpdateBy(currentUser.getUsername());
        return trainrecordDao.delete(trainrecord);
    }

    @Override
    public void save(Trainrecord trainrecord) {
        User currentUser = arsUtil.getCurrentUser();
        /**
         * 最后一级机构id处理
         */
        if(trainrecord.getOrgid() == null){
            if(trainrecord.getDistrictOrgId() != null){
                trainrecord.setOrgid(Long.parseLong(trainrecord.getDistrictOrgId()));
            }else if(trainrecord.getCityOrgId() != null){
                trainrecord.setOrgid(Long.parseLong(trainrecord.getCityOrgId()));
            }else{
                Police police = policeDao.findByType(Constants.ORGTYPE_PROVINCE).get(0);
                trainrecord.setOrgid(police.getId());
            }
        }

        if(trainrecord.getId() == null){
            trainrecord.setId(idWorker.nextId());
            trainrecord.setCreateTime(new Date());
        }else{
            Trainrecord dbTrainrecord = trainrecordDao.findById(trainrecord.getId());
            BeanUtils.copyPropertiesIgnore(trainrecord,dbTrainrecord,true);
            BeanUtils.copyPropertiesIgnore(dbTrainrecord,trainrecord,false);
        }
        if(!trainrecord.getApprovalstate().equals(Constants.APPROVALSTATE_WTJ)){
            //开发任务 #10165
            Trainrecord checkTraincompanyapply = trainrecordDao.findApproveByCompanyName(trainrecord.getCompanyname());
            if(checkTraincompanyapply != null){
                throw new ArsException(trainrecord.getCompanyname() + "已备案，不能重复备案！");
            }
        }

        trainrecord.setActive(true);
        trainrecord.setUpdateBy(currentUser.getUsername());
        trainrecord.setUpdateTime(new Date());
        trainrecord.setUpdateflag(true);
        trainrecord.setUserid(currentUser.getId());
        trainrecordDao.save(trainrecord);

        if(trainrecord.getApprovalstate().equals(ApprovalState.DSH)) {
            approvalUtil.saveApproval(BusinessType.BAPXDWBA, trainrecord.getId(),Constants.ACTIVITI_PROCESS_TRAINCOMPANYAPPLY);
        }
    }

    @Override
    public Trainrecord findById(Long id) {
        Trainrecord result= trainrecordDao.findById(id);
        if (result != null) {
            //查询审批日志信息
            result.setApproval(approvalDAO.findBybusinessidAndType(result.getId(),BusinessType.BAPXDWBA));

            //查询机构信息
            Police police = policeDao.findById(result.getOrgid());
            result.setPolice(police);
        }
        return result;
    }

    @Override
    public void searchForPage(TrainrecordPageSearchDto dto, AjaxPageResponse page) {
        dto.setPoliceBusiness(false);
        arsUtil.setPoliceSearch(dto);
        if (Constants.CHECKTYPE_APPROVE.equals(dto.getCheckType())) {
            User user = arsUtil.getCurrentUser();
            if (user != null) {
                dto.setUserid(user.getId());
            }
        }
        trainrecordDao.searchForPage(dto,page);
    }

    @Override
    public void importBatch(List<Trainrecord> list) {
        List<Trainrecord> dbList = trainrecordDao.findByBatchId(list);
        //去掉重复的
        //通过重写 equals跟hashCode方法 实现根据id与updatetime判断是否需要更新。
        list.removeAll(dbList);
        if (list.size()>0){
            for (Trainrecord trainrecord : list) {
                trainrecord.setUpdateflag(false);
                try {
                    if(!configUtils.isIntranet()){
                        trainrecord.setUpdateTime(DateUtil.dateAdd(DateUtil.DATATYPE_SECOND, trainrecord.getUpdateTime(), 1));
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
            trainrecordDao.saveBatch(list);
        }
    }

    @Override
    public List<Trainrecord> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return trainrecordDao.searchForDataSynchronization(dto);
    }

    @Override
    public List<Trainrecord> findDSOutList(String startDate) {
        return trainrecordDao.findDSOutList(startDate);
    }

    @Override
    public List<Trainrecord> findByBatchId(List<Trainrecord> list) {
        return trainrecordDao.findByBatchId(list);
    }

    @Override
    public Trainrecord findByUser(Long userid) {
        return trainrecordDao.findByUser(userid);
    }

    @Override
    public void saveOrUpdateForApprovalImport(Trainrecord trainrecord) {
        trainrecordDao.updateSelective(trainrecord);
    }

    @Override
    public void updateSelective(Trainrecord trainrecord) {
        User currentUser = arsUtil.getCurrentUser();
        trainrecord.setUpdateTime(new Date());
        trainrecord.setUpdateBy(currentUser.getUsername());
        trainrecordDao.updateSelective(trainrecord);
    }



}
