package com.bcxin.ars.service.sb.impl;

import com.bcxin.ars.dao.sb.BackgroundApprovalDao;
import com.bcxin.ars.dto.sb.BackgroundApprovalDto;
import com.bcxin.ars.model.sb.BackgroundApproval;
import com.bcxin.ars.service.bean.factory.BackGroupCensorServiceBeanFactory;
import com.bcxin.ars.service.sb.BackgroundApprovalService;
import com.bcxin.ars.webservice.BackGroupCensorService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Service
@Transactional
public class BackgroundApprovalServiceImpl implements BackgroundApprovalService {

    @Autowired
    private BackgroundApprovalDao backgroundApprovalDao;

    private static BackGroupCensorService backGroupCensorService;


    /***
     * 先获取背景筛查实现类对
     */
    private void getBackGroupCensorService(){
        if(backGroupCensorService == null){
            backGroupCensorService = BackGroupCensorServiceBeanFactory.getBackGroupCensorServiceBean();
        }
    }

    @Override
    public void save(BackgroundApproval backgroundApproval) {
        backgroundApprovalDao.save(backgroundApproval);
    }

    @Override
    public List query(BackgroundApprovalDto backgroundApprovalDto) {
        return backgroundApprovalDao.query(backgroundApprovalDto);
    }
    @Override
    public void approval(Long businessid,String businesstype,String idNumber,String realName) {
        //法人信息
        BackgroundApprovalDto backgroundApprovalDto = new BackgroundApprovalDto();
        backgroundApprovalDto.setBusinessid(businessid);
        backgroundApprovalDto.setBusinesstype(businesstype);
        backgroundApprovalDto.setIdNumber(idNumber);
        backgroundApprovalDto.setRealName(realName);
        approval(backgroundApprovalDto);
    }
    @Override
    public void approval(BackgroundApprovalDto backgroundApproval) {
        getBackGroupCensorService();
        backGroupCensorService.censor(backgroundApproval);
        //clientUtil.queryAndBGInfo(backgroundApproval.getBusinessid(), backgroundApproval.getBusinesstype(), backgroundApproval.getIdNumber(), backgroundApproval.getRealName());
    }

    @Override
    public void update(BackgroundApprovalDto backgroundApprovalDto) {
        backgroundApprovalDao.update(backgroundApprovalDto);
    }

    @Override
    public String getCensorStatus(Long businessid, String businesstype, String idNumber, String realName) {
        getBackGroupCensorService();
        BackgroundApprovalDto backgroundApprovalDto = new BackgroundApprovalDto();
        backgroundApprovalDto.setBusinessid(businessid);
        backgroundApprovalDto.setBusinesstype(businesstype);
        backgroundApprovalDto.setIdNumber(idNumber);
        backgroundApprovalDto.setRealName(realName);
        return backGroupCensorService.getCensorStatus(backgroundApprovalDto);
    }

}
