package com.bcxin.ars.service.sb.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.sb.ArmtrainchargeDao;
import com.bcxin.ars.dao.sb.ArmtrainchargeDaoAop;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.ArmtrainchargeSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Armtraincharge;
import com.bcxin.ars.service.sb.ArmtrainchargeService;
import com.bcxin.ars.service.util.ArsUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

@Service
@Transactional
@DataSyncAnnotation(getClazz = Armtraincharge.class)
public class ArmtrainchargeServiceImpl implements ArmtrainchargeService{

	@Autowired
	private ArmtrainchargeDao armtrainchargeDao;

	@Autowired
	private ArmtrainchargeDaoAop armtrainchargeDaoAop;

	@Autowired
	private ArsUtil arsUtil;
	
	
	@Override
	public Armtraincharge findById(long id) {
		return armtrainchargeDao.findById(id);
	}

	@Override
	public void saveOrUpdate(Armtraincharge shareholder) {
		User currentUser = arsUtil.getCurrentUser();
		if(shareholder.getId() == null){
			shareholder.setActive(true);
			shareholder.setCreateTime(new Date());
			shareholder.setUpdateTime(new Date());
			shareholder.setUpdateBy(currentUser.getUsername());
			armtrainchargeDao.save(shareholder);
		}else{
			Armtraincharge dbArmtraincharge = armtrainchargeDao.findById(shareholder.getId());
			dbArmtraincharge.setUpdateTime(new Date());
			dbArmtraincharge.setUpdateBy(currentUser.getUsername());
			dbArmtraincharge.setPxidnum(shareholder.getPxidnum());
			dbArmtraincharge.setPxname(shareholder.getPxname());
			dbArmtraincharge.setPxphone(shareholder.getPxphone());
			armtrainchargeDao.update(dbArmtraincharge);
		}
	}

	@Override
	public void saveOrUpdateForDS(Armtraincharge shareholder) {
		if(shareholder.getActive() == null){
			shareholder.setActive(true);
		}
		
		Armtraincharge dbArmtraincharge = armtrainchargeDao.findById(shareholder.getId());
		if (dbArmtraincharge != null) {
			if(shareholder.getUpdateTime().getTime() > dbArmtraincharge.getUpdateTime().getTime()){
				shareholder.setCensorstatus(dbArmtraincharge.getCensorstatus());
				armtrainchargeDao.update(shareholder);
			}
		} else {
			armtrainchargeDao.saveForDS(shareholder);
		}
	}

	@Override
	public ArmtrainchargeSearchDto search(ArmtrainchargeSearchDto dto) {
		ArmtrainchargeSearchDto resultDto = new ArmtrainchargeSearchDto();
		List<Armtraincharge> list =  armtrainchargeDao.search(dto);
		resultDto.setData(list);
		resultDto.setTotalCount(armtrainchargeDao.searchCount(dto));
		return resultDto;
	}

	@Override
	public List<Armtraincharge> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
		return armtrainchargeDao.searchForDataSynchronization(searchDto);
	}

	@Override
	public void deleteBySid(String sponsorlicenseid){
		armtrainchargeDao.deleteBySid(sponsorlicenseid);
	}

	@Override
	public void updateCensorStatus(Armtraincharge armtraincharge) {
		armtraincharge.setUpdateTime(new Date());
		armtrainchargeDaoAop.updateCensorStatus(armtraincharge);
	}
}
