package com.bcxin.ars.service.sb.custompersoncertificate;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.sb.ActivityRepairDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.SecurityPersonSearchRerurnDTO;
import com.bcxin.ars.model.sb.Personcertificate;
import com.bcxin.ars.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/***
 * 陕西保安员资格打回校验实在类
 */
@Service
public class SnCustomPersoncertificateServiceImpl extends DefaultCustomPersoncertificateServiceImpl {

    @Autowired
    private ActivityRepairDao activityRepairDao;
    /**
     * 查询哪些数据不能打回
     * @param
     * @return
     */
    @Override
    public AjaxResult checkReturn(Long[] perIds) {
        AjaxResult result = new AjaxResult();
        List<Personcertificate>   mapList =  activityRepairDao.checkReturnForSn(perIds);
        result.setMsg("流程打回-人员信息查询-返回成功");
        result.setSuccessful(true);
        if (mapList.size() > 0) {
            String personsInfo = "";
            for (Personcertificate detail : mapList) {
                if (StringUtil.isNotEmpty(detail.getName())) {
                    personsInfo += detail.getName();
                }
                personsInfo += "|";
                if (StringUtil.isNotEmpty(detail.getCardnumber())) {
                    personsInfo += detail.getCardnumber();
                }
                personsInfo += " ,";
            }
            if (personsInfo.length()>0){
                personsInfo=   personsInfo.substring(0, personsInfo.length() - 1);
            }
            result.setData("下列人员已经获取指纹，避免公安网内外网数据冲突无法打回，其余人可以继续打回，无法打回具体名单如下："+personsInfo);
            int mapSize=mapList.size();
            int personIdSize=     perIds.length;
            if (personIdSize==mapSize){
                result.setMsg("流程打回失败，所选人员都不可打回");
                result.setSuccessful(false);
                result.setData("");
                return result;
            }
        } else {
            result.setData("");
        }
        return result;
    }

    @Override
    public List<Personcertificate> getNoReturnList(Long[] perIds) {
        return activityRepairDao.checkReturnForSn(perIds);
    }

    @Override
    public JSONArray checkReturnList(List<Personcertificate> list) {
        JSONArray failList = new JSONArray();
        if(list.size() > 0) {
            list.forEach(detail -> {
                JSONObject obj = new JSONObject();
                obj.put("id", detail.getId());
                obj.put("successful", false);
                obj.put("message", "已经获取指纹，避免公安网内外网数据冲突无法打回");
                failList.add(obj);
            });
        }

        return failList;
    }

    @Override
    public SecurityPersonSearchRerurnDTO findPersonByCompanyIdSearchReturnDTO(SecurityPersonSearchRerurnDTO securityPersonSearchRerurnDTO) {
        return null;
    }

    @Override
    public String getMsgTemp(String tempType, String testState) {
        //陕西不需要发消息
        return StringUtil.EMPTY;
    }

    @Override
    public String getMsgTemp_V1171(String tempType, String testState) {
        //陕西不需要发消息
        return StringUtil.EMPTY;
    }

    @Override
    public String getMsgTemp_V1172(String tempType, String testState) {
        //陕西不需要发消息
        return StringUtil.EMPTY;
    }
}
