package com.bcxin.ars.service.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.bcxin.ars.dao.StarLevelDao;
import com.bcxin.ars.model.StarLevel;
import com.bcxin.ars.service.StarLevelService;

@Service
@Transactional
public class StarLevelServiceImpl implements StarLevelService {

	@Autowired
	private StarLevelDao lvlDao;
	
	@Override
	public List<StarLevel> findAll() {
		return lvlDao.findAll();
	}

	@Override
	public StarLevel findById(Long id) {
		return lvlDao.findById(id);
	}
	
	@Override
	public Map<Long, StarLevel> findMap() {
		List<StarLevel> lvlList = lvlDao.findAll();
		Map<Long, StarLevel> result = new HashMap<Long, StarLevel>();
		for(StarLevel lvl : lvlList) {
			result.put(lvl.getId(), lvl);
		}
		return result;
	}

}
