package com.bcxin.ars.service.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.bcxin.ars.dao.SecurityProfessionLevelDao;
import com.bcxin.ars.model.SecurityProfessionLevel;
import com.bcxin.ars.service.SecurityProfessionLevelService;

@Service
@Transactional
public class SecurityProfessionLevelServiceImpl implements SecurityProfessionLevelService {

	@Autowired
	private SecurityProfessionLevelDao lvlDao;
	
	@Override
	public List<SecurityProfessionLevel> findAll() {
		return lvlDao.findAll();
	}

	@Override
	public SecurityProfessionLevel findById(Long id) {
		return lvlDao.findById(id);
	}

	@Override
	public Map<Long, SecurityProfessionLevel> findMap() {
		List<SecurityProfessionLevel> lvlList = lvlDao.findAll();
		Map<Long, SecurityProfessionLevel> result = new HashMap<Long, SecurityProfessionLevel>();
		for(SecurityProfessionLevel lvl : lvlList) {
			result.put(lvl.getId(), lvl);
		}
		return result;
	}

}
