package com.bcxin.ars.service.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.bcxin.ars.dao.SecurityGuardDao;
import com.bcxin.ars.dao.SecurityGuardDaoAop;
import com.bcxin.ars.dao.sb.SbSponsorlicenseManagerDao;
import com.bcxin.ars.dao.sb.SbSponsorlicenseVmanagerDao;
import com.bcxin.ars.dao.sb.SponsorlicenseDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.SecurityGuardSearchDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.model.BusinessCommon;
import com.bcxin.ars.model.SecurityGuard;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.SbSponsorlicenseManager;
import com.bcxin.ars.model.sb.SbSponsorlicenseVmanager;
import com.bcxin.ars.model.sb.Sponsorlicense;
import com.bcxin.ars.model.sb.Traincompanyapply;
import com.bcxin.ars.service.SecurityGuardService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.IdWorker;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import com.xiaoleilu.hutool.date.DateField;
import com.xiaoleilu.hutool.date.DateUtil;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author 罗鹏
 */
@Service
@Transactional
@DataSyncAnnotation(getClazz = SecurityGuard.class,getMethodName = "updateFlagForOutToIn",getImportType = ImportType.BATCH)
@DataSyncOutAnnotation(getClazz = SecurityGuard.class)
public class SecurityGuardServiceImpl  implements SecurityGuardService {

    @Resource
    private SecurityGuardDao securityGuardDao;

    @Resource
    private SecurityGuardDaoAop securityGuardDaoAop;

    @Resource
    private ArsUtil arsUtil;

    @Resource
    private SponsorlicenseDao sponsorlicenseDao;

    @Resource
    private SbSponsorlicenseManagerDao sbSponsorlicenseManagerDao;

    @Resource
    private SbSponsorlicenseVmanagerDao sbSponsorlicenseVmanagerDao;

    @Override
    public SecurityGuard findById(long id) {
        return securityGuardDao.findById(id);
    }

    @Override
    public SecurityGuard findByIdNumber(String idNumber) {
        return securityGuardDao.findByIdNum(idNumber);
    }

    @Override
    public AjaxResult saveOrUpdate(SecurityGuard securityGuard) {
        AjaxResult result = new AjaxResult();
        SecurityGuard dbSecurityGuard = new SecurityGuard();
        String userName = arsUtil.getCurrentUser().getUsername();
        if (securityGuard.getId() != null) {
            //表示修改
            dbSecurityGuard = securityGuardDao.findById(securityGuard.getId());
            if (!dbSecurityGuard.getIdNumber().equals(securityGuard.getIdNumber())) {
                dbSecurityGuard = securityGuardDao.findByIdNum(securityGuard.getIdNumber());
                if (dbSecurityGuard != null) {
                    result.setSuccessful(false);
                    result.setMsg("身份证号已存在！");
                    return result;
                }
            }
            securityGuard.setUpdateBy(userName);
            securityGuard.setUpdateTime(new Date());
            securityGuard.setUpdateflag(true);
            securityGuardDaoAop.update(securityGuard);
        } else {
            //表示新增
            dbSecurityGuard = securityGuardDao.findByIdNum(securityGuard.getIdNumber());
            if (dbSecurityGuard != null) {
                result.setSuccessful(false);
                result.setMsg("身份证号已存在！");
                return result;
            }
            securityGuard.setActive(true);
            securityGuard.setCreateTime(new Date());
            securityGuard.setUpdateBy(userName);
            securityGuard.setUpdateTime(new Date());
            securityGuard.setUpdateflag(true);
            securityGuardDao.save(securityGuard);
        }
        result.setSuccessful(true);
        return result;
    }

    @Override
    public List<Map<String, String>> saveSecurityGuard(List<Map<String, String>> dataList, User loginUser) {
        Long importBatchId = new IdWorker().nextId();

        /***** 批量插入导入保安师临时表 ****/

        /**** 数据量太大导致java内存溢出 ,这里分批插入 ****/
        int insertLength = dataList.size();
        int i = 0;
        while (insertLength > 2000) {
            securityGuardDao.insertTempBatchGuardImport(dataList.subList(i, i + 2000), importBatchId);
            i = i + 2000;
            insertLength = insertLength - 2000;
        }
        if (insertLength > 0) {
            securityGuardDao.insertTempBatchGuardImport(dataList.subList(i, i + insertLength), importBatchId);
        }

        /***** 导入逻辑 start ***/
            /******验证导入的Excel是否有重复身份证数据**************/
            securityGuardDao.checkIdNumNoRepeat(importBatchId);
            /******验证需要导入的数据身份证是否已存在保安师库**************/
            securityGuardDao.checkInOtherCom(importBatchId);
            /***** 插入数据 ***/
            securityGuardDao.insertSecurityGuardInfo(importBatchId);
        /***** 导入逻辑 end ***/

        /***** 查询本次校验失败的导入保安师信息 ****/
        List<Map<String, String>> tempInputPerList = securityGuardDao.getTempImportGuardList(importBatchId);

        /***** 删除本次导入的保安师信息 ****/
        securityGuardDao.deleteTempBatchGuardImport(importBatchId);
        return tempInputPerList;
    }

    /**
     * 验证保安师
     * @param businessCommon
     * @return
     */
    @Override
    public String validateSecurityGuard(BusinessCommon businessCommon){

        StringBuffer result = new StringBuffer("");
        //保安服务公司
        if(businessCommon.getClass().equals(Sponsorlicense.class)) {
            Sponsorlicense sponsor = (Sponsorlicense) businessCommon;
        /* 获得法人，总经理，副总经理 */
            String legalPersonNo = sponsor.getLegalPersonNo();
            String managerNo = sponsor.getSbSponsorlicenseManager().getIdnum();
            String vManagerNo = sponsor.getSbSponsorlicenseVmanager().getVidnum();

            if (StringUtil.isNotEmpty(legalPersonNo)) {
            /* 校验法人 */
                result.append(validateGuard("legal", legalPersonNo));
            }

            if (StringUtil.isNotEmpty(managerNo)) {
                /* 校验总经理 */
                for(String manage:managerNo.split(Constants.COMMA)) {
                    result.append(validateGuard("manage", manage));
                }
            }
            if (StringUtil.isNotEmpty(vManagerNo)) {
                /* 校验副总经理 */
                for(String manage:vManagerNo.split(Constants.COMMA)) {
                    result.append(validateGuard("vmanage", manage));
                }
            }
        }else if(businessCommon.getClass().equals(Traincompanyapply.class)){
            //培训单位
            Traincompanyapply traincompany = (Traincompanyapply)businessCommon;
            if (StringUtil.isNotEmpty(traincompany.getTraincreditcode())) {
                /* 校验拟定法人 */
                result.append(validateGuard("legal", traincompany.getLegalcode()));
            }
            if (StringUtil.isNotEmpty(traincompany.getLegalcode())) {
                /* 校验法人 */
                result.append(validateGuard("ndlegal", traincompany.getTraincreditcode()));
            }
        }
        return result.toString();
    }

    /**
     * 北京：验证保安师的规则
     * 规则一：必须存在保安师库
     * 规则二：同一区间只允许一个保安师
     * @param legalPersonNo
     * @return
     */
    private String validateGuard(String type,String legalPersonNo) {
        SecurityGuard guard = securityGuardDao.findByIdNum(legalPersonNo);
        if (guard == null) {
            /* 0代表 不存在保安师*/
            return type + ":0:"+legalPersonNo+";";
        }
        /* 存在服务单位 */
        if (StringUtil.isNotEmpty(guard.getSecurityCompany())) {
            /* 需要校验保安师的服务时间 */
            if(StringUtil.isNotEmpty(guard.getServiceStartTime())) {
                if(StringUtil.isNotEmpty(guard.getServiceEndTime())) {
                    /* 在区间内，保安师重复服务 */
                    if (DateUtil.isIn(DateUtil.date(), DateUtil.parseDate(guard.getServiceStartTime()), DateUtil.parseDate(guard.getServiceEndTime()))) {
                    /* -1代表 保安师重复服务*/
                        return type + ":-1:" + legalPersonNo + ";";
                    }
                }else{
                    //throw new ArsException("保安师("+guard.getName()+")服务结束时间维护错误！");
                }

            }
        }
        return "";
    }

    public static void main(String[] args) {
        System.out.println(DateUtil.date());
        System.out.println(DateUtil.isIn(DateUtil.date(), DateUtil.parseDate("2019-08-01"), DateUtil.parseDate("2019-09-12")));
        System.out.println(DateUtil.isIn(DateUtil.date(), DateUtil.parseDate("2019-08-01"), DateUtil.parseDate("2019-10-01")));
    }
    /**
     * 批量导入
     * @param list
     */
    @Override
    public void importBatch(List<SecurityGuard> list){
        List<SecurityGuard> dbList = securityGuardDao.findByBatchId(list);
        //去掉重复的
        //通过重写 equals跟hashCode方法 实现根据id与updatetime判断是否需要更新。
        list.removeAll(dbList);

        if (list.size()>0){
            for(SecurityGuard detail:list){
                detail.setUpdateflag(false);
                try {
                    detail.setUpdateTime(com.bcxin.ars.util.DateUtil.dateAdd(com.bcxin.ars.util.DateUtil.DATATYPE_SECOND, detail.getUpdateTime(), 1));
                }catch (Exception e){

                }
            }
            //批量保存
            securityGuardDaoAop.saveBatch(list);
        }
    }

    /**
     * 搜索同步到内网的数据
     * @param dto
     * @return
     */
    @Override
    public List<SecurityGuard> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return securityGuardDao.searchForDataSynchronization(dto);
    }

    /**
     * @Decription:外到内更新修改标志
     * @param list
     * @return
     */
    @Override
    public void updateFlagForOutToIn(List<SecurityGuard> list) {
        securityGuardDaoAop.updateFlagForOutToIn(list);
    }

    @Override
    public List<SecurityGuard> findDSOutList(String startDate) {
        return securityGuardDao.searchForExport(startDate);
    }

    /**
     * 分页查询
     * @param dto
     * @param page
     */
    @Override
    public void search(SecurityGuardSearchDto dto, AjaxPageResponse<SecurityGuard> page) {
        securityGuardDao.search(dto,page);
    }

    /**
     * 许可通过后请将服务保安公司信息，与服务时间（申请时间）同步至保安师库相关字段
     * @param businessCommon
     */
    @Override
    public void updateSecurityCompany(BusinessCommon businessCommon) {
        User currentUser = arsUtil.getCurrentUser();
        List<String> idNums = new ArrayList<>();

        if(businessCommon.getClass().equals(Sponsorlicense.class)) {
            Sponsorlicense sponsor = (Sponsorlicense) businessCommon;
            /* 获得法人，总经理，副总经理 */
            String legalPersonNo = sponsor.getLegalPersonNo();
            List<SbSponsorlicenseManager>  managers = sbSponsorlicenseManagerDao.findBySponsorId(sponsor.getId());
            List<SbSponsorlicenseVmanager>  vmanagers = sbSponsorlicenseVmanagerDao.findBySponsorId(sponsor.getId());

            if (StringUtil.isNotEmpty(legalPersonNo)) {
                /* 法人 */
                idNums.add(legalPersonNo);
            }
            if (managers != null && managers.size() > 0) {
                /* 总经理 */
                for (SbSponsorlicenseManager manager:managers){
                    idNums.add(manager.getIdnum());
                }
            }
            if (vmanagers != null && vmanagers.size() > 0) {
                /* 副总经理 */
                for (SbSponsorlicenseVmanager manager:vmanagers){
                    idNums.add(manager.getVidnum());
                }
            }
        }else if(businessCommon.getClass().equals(Traincompanyapply.class)){
            Traincompanyapply traincompany = (Traincompanyapply)businessCommon;
            if (StringUtil.isNotEmpty(traincompany.getTraincreditcode())) {
                /* 校验拟定法人 */
                idNums.add(traincompany.getTraincreditcode());
            }
            if (StringUtil.isNotEmpty(traincompany.getLegalcode())) {
                /* 校验法人 */
                idNums.add(traincompany.getLegalcode());
            }
        }

        if(idNums.size()>0) {
            SecurityGuard securityGuard = new SecurityGuard();
            securityGuard.setUpdateTime(new Date());
            securityGuard.setUpdateflag(true);
            securityGuard.setSecurityCompany(businessCommon.getCompanyname());
            securityGuard.setUpdateBy(currentUser.getUsername());
            securityGuard.setServiceStartTime(com.bcxin.ars.util.DateUtil.convertDateToString(businessCommon.getCreateTime(), com.bcxin.ars.util.DateUtil.FORMAT2));

            try {
                /* 默认服务三年 */
                Date endServiceTime = DateUtil.offset(DateUtil.parseDate(securityGuard.getServiceStartTime()), DateField.YEAR, 3);
                securityGuard.setServiceEndTime(com.bcxin.ars.util.DateUtil.convertDateToString(endServiceTime, com.bcxin.ars.util.DateUtil.FORMAT2));
            } catch (Exception e) {
                e.printStackTrace();
            }
            securityGuardDaoAop.batchUpdateByIdNums(idNums,securityGuard);
        }
    }
}