package com.bcxin.ars.service.impl;

import com.bcxin.ars.dao.PoliceDao;
import com.bcxin.ars.dao.SecurityConfesscompanyDao;
import com.bcxin.ars.dto.sb.SecurityConfesscompanySearchDto;
import com.bcxin.ars.model.PageResult;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.SecurityConfesscompany;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.SecurityConfesscompanyService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.webservice.ClientUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.util.Date;
import java.util.List;
import java.util.Map;

@Service
@Transactional
public class SecurityConfesscompanyServiceImpl implements SecurityConfesscompanyService {

	@Autowired
	private SecurityConfesscompanyDao securityConfesscompanyDao;


	@Autowired
	private ArsUtil arsUtil;

	@Autowired
	private PoliceDao policeDao;

	@Autowired
	private ClientUtil clientUtil;
	/**
	 * 保存或更新
	 * @param securityConfesscompany
	 */
	@Override
	public void saveOrUpdate(SecurityConfesscompany securityConfesscompany) {
        User user = arsUtil.getCurrentUser();
		//判断是否存在，如果存在则为更新否则为保存
		SecurityConfesscompany dbSecurityConfesscompany = securityConfesscompanyDao.findById(securityConfesscompany.getId());
		if(dbSecurityConfesscompany != null) {
			//设置修改时间
			dbSecurityConfesscompany.setUpdateTime(new Date());
			//设置修改者
			dbSecurityConfesscompany.setUpdateBy(user.getRealname());
			//如果不为空，则更新相应字段的值
			if(!StringUtils.isEmpty(securityConfesscompany.getBz1())) {
				dbSecurityConfesscompany.setBz1(securityConfesscompany.getBz1());
			}
			if(!StringUtils.isEmpty(securityConfesscompany.getBz2())) {
				dbSecurityConfesscompany.setBz2(securityConfesscompany.getBz2());
			}
			if(!StringUtils.isEmpty(securityConfesscompany.getBz3())) {
				dbSecurityConfesscompany.setBz3(securityConfesscompany.getBz3());
			}
			if(!StringUtils.isEmpty(securityConfesscompany.getFajgmc())) {
				dbSecurityConfesscompany.setFajgmc(securityConfesscompany.getFajgmc());
			}
			if(!StringUtils.isEmpty(securityConfesscompany.getFzjgbm())) {
				dbSecurityConfesscompany.setFzjgbm(securityConfesscompany.getFzjgbm());
			}
			if(!StringUtils.isEmpty(securityConfesscompany.getLxdh())) {
				dbSecurityConfesscompany.setLxdh(securityConfesscompany.getLxdh());
			}
			if(!StringUtils.isEmpty(securityConfesscompany.getLxrxm())) {
				dbSecurityConfesscompany.setLxrxm(securityConfesscompany.getLxrxm());
			}
			if(!StringUtils.isEmpty(securityConfesscompany.getPxdwbm())) {
				dbSecurityConfesscompany.setPxdwbm(securityConfesscompany.getPxdwbm());
			}
			if(!StringUtils.isEmpty(securityConfesscompany.getPxdwlb())) {
				dbSecurityConfesscompany.setPxdwlb(securityConfesscompany.getPxdwlb());
			}
			if(!StringUtils.isEmpty(securityConfesscompany.getPxxkz())) {
				dbSecurityConfesscompany.setPxxkz(securityConfesscompany.getPxxkz());
			}




			if(!StringUtils.isEmpty(securityConfesscompany.getZcdz())) {
				dbSecurityConfesscompany.setZcdz(securityConfesscompany.getZcdz());
			}
			if(!StringUtils.isEmpty(securityConfesscompany.getZcssx())) {
				dbSecurityConfesscompany.setZcssx(securityConfesscompany.getZcssx());
			}
			if(!StringUtils.isEmpty(securityConfesscompany.getZczj())) {
				dbSecurityConfesscompany.setZczj(securityConfesscompany.getZczj());
			}
			if(!StringUtils.isEmpty(securityConfesscompany.getPxdwmc())) {
				dbSecurityConfesscompany.setPxdwmc(securityConfesscompany.getPxdwmc());
			}
			if(!StringUtils.isEmpty(securityConfesscompany.getXkzbfrq())) {
				dbSecurityConfesscompany.setXkzbfrq(securityConfesscompany.getXkzbfrq());
			}
			if(!StringUtils.isEmpty(securityConfesscompany.getXkzdxjg())) {
				dbSecurityConfesscompany.setXkzdxjg(securityConfesscompany.getXkzdxjg());
			}
			if(!StringUtils.isEmpty(securityConfesscompany.getXkzdxrq())) {
				dbSecurityConfesscompany.setXkzdxrq(securityConfesscompany.getXkzdxrq());
			}
			if(!StringUtils.isEmpty(securityConfesscompany.getXkzdxyy())) {
				dbSecurityConfesscompany.setXkzdxyy(securityConfesscompany.getXkzdxyy());
			}
			if(!StringUtils.isEmpty(securityConfesscompany.getXzdh())) {
				dbSecurityConfesscompany.setXzdh(securityConfesscompany.getXzdh());
			}
			if(!StringUtils.isEmpty(securityConfesscompany.getXzsfzh())) {
				dbSecurityConfesscompany.setXzsfzh(securityConfesscompany.getXzsfzh());
			}
			if(!StringUtils.isEmpty(securityConfesscompany.getXzxm())) {
				dbSecurityConfesscompany.setXzxm(securityConfesscompany.getXzxm());
			}
			if(!StringUtils.isEmpty(securityConfesscompany.getProvince())) {
				dbSecurityConfesscompany.setProvince(securityConfesscompany.getProvince());
			}
			if(!StringUtils.isEmpty(securityConfesscompany.getDistrict())) {
				dbSecurityConfesscompany.setDistrict(securityConfesscompany.getDistrict());
			}
			if(!StringUtils.isEmpty(securityConfesscompany.getCity())) {
				dbSecurityConfesscompany.setCity(securityConfesscompany.getCity());
			}


			securityConfesscompanyDao.update(dbSecurityConfesscompany);

		}else{
			securityConfesscompany.setUserid(user.getId());
			//修改时间，创建时间在保存的时候一样
			securityConfesscompany.setCreateTime(new Date());
			securityConfesscompany.setUpdateTime(securityConfesscompany.getCreateTime());
			//默认可用
			securityConfesscompany.setActive(true);
			securityConfesscompany.setUpdateBy(user.getUsername());
			securityConfesscompanyDao.save(securityConfesscompany);

			//部级接口对接  ---保安培训机构信息上报
            /*new Thread(()->{ //异步处理
				try {
					//确定对接的属性对应关系
					//源实体类的列，目标实体类的列
					String[] srccol = {"pxdwbm","pxdwmc","zcdz","lxrxm","lxdh","xzsfzh","xzxm","xzdh","zczj","pxxkz","fzjgbm"
							,"fajgmc","xkzbfrq","xkzdxjg","xkzdxrq","xkzdxyy","pxdwlx","bz1","bz2","bz3"};
					String[] desccol = {"pxdwbm","pxdwmc","zcdz","lxrxm","lxdh","xzsfzh","xzxm","xzdh","zczj","pxxkz","fzjgbm"
							,"fajgmc","xkzbfrq","xkzdxjg","xkzdxrq","xkzdxyy","pxdwlx","bz1","bz2","bz3"};
					//key中存放的是特殊情况下的列，1源实体类没有，而目标实体类必填的2源实体类跟目标实体类值类型不匹配的，比如性别等，value存放特殊列的值。如果没有，则放空
					String[] key = {};
					String[] value = {};
					//生成实体
					Object desc = BuildWebServiceEntity.buildWebServiceEntity(srccol,desccol,securityConfesscompany,new Bapxdwxx(),key,value);
					Bapxdwxx bapxdwxx =(Bapxdwxx)desc;
					//调用send方法完成对接
					clientUtil.send(Constants.XXBA_BAPXDWXX,bapxdwxx);

				} catch(Exception e) {
					e.printStackTrace();
				}
			}).start();*/
		}
		}

	/**
	 * 删除
	 * @param securityConfesscompany
	 */

	@Override
	public void delete(SecurityConfesscompany securityConfesscompany) {
		securityConfesscompany.setUpdateTime(new Date());
		securityConfesscompanyDao.delete(securityConfesscompany);
	}

	/**
	 *根据ID查询
	 * @param id
	 */
	@Override
	public SecurityConfesscompany findById(long id){
		return securityConfesscompanyDao.findById(id);
	}

	/**
	 * 查询
	 * @param dto
	 * @return
	 */
	@Override
	public SecurityConfesscompanySearchDto search(SecurityConfesscompanySearchDto dto) {
		SecurityConfesscompanySearchDto resultDto = new SecurityConfesscompanySearchDto();

		User currentUser = arsUtil.getCurrentUser();
		//机构信息
		Police police = policeDao.findById(currentUser.getOrgid());
		String areacode =  police.getAreacode();
		if(areacode.endsWith("0000")){//省
			dto.setDistrict(areacode.substring(0,2)+"____");
		}else if(areacode.endsWith("00")){//市
			dto.setDistrict(areacode.substring(0,4)+"__");
		}else{//区
			dto.setDistrict(areacode);
		}


		List<SecurityConfesscompany> list =  securityConfesscompanyDao.search(dto);
		resultDto.setData(list);
		resultDto.setTotalCount(securityConfesscompanyDao.count(dto));
		return resultDto;
	}

    /**
	 * 查询保安培训机构信息 wjb 2018年9月27日13:20:53
	 * @param p 
	 * @return
	 */
	@Override
	public PageResult searchSecurityConfesscompanyList_table(Map<Object, Object> p) {
		return new PageResult(securityConfesscompanyDao.countSecurityConfesscompanyList(p), securityConfesscompanyDao.searchSecurityConfesscompanyList(p));
	}

}


