package com.bcxin.ars.service.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.SbSubsidiaryManagerDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.SbSubsidiaryManagerSearchDto;
import com.bcxin.ars.model.SbSubsidiaryManager;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.SbSubsidiaryManagerService;
import com.bcxin.ars.service.util.ArsUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.util.Date;
import java.util.List;

@Service
@Transactional
@DataSyncAnnotation(getClazz = SbSubsidiaryManager.class)
public class SbSubsidiaryManagerServiceImpl implements SbSubsidiaryManagerService {

	@Autowired
	private SbSubsidiaryManagerDao sbSubsidiaryManagerDao;


	@Autowired
	private ArsUtil arsUtil;

	/**
	 * 保存或更新
	 * @param sbSubsidiaryManager
	 */
	@Override
	public void saveOrUpdate(SbSubsidiaryManager sbSubsidiaryManager) {
        User user = arsUtil.getCurrentUser();
		//判断是否存在，如果存在则为更新否则为保存
		SbSubsidiaryManager dbSbSubsidiaryManager = sbSubsidiaryManagerDao.findById(sbSubsidiaryManager.getId());
		if(dbSbSubsidiaryManager != null) {
			//设置修改时间
			dbSbSubsidiaryManager.setUpdateTime(new Date());
			//设置修改者
			dbSbSubsidiaryManager.setUpdateBy(user.getRealname());
			//如果不为空，则更新相应字段的值
			if(!StringUtils.isEmpty(sbSubsidiaryManager.getEducation())) {
				dbSbSubsidiaryManager.setEducation(sbSubsidiaryManager.getEducation());
			}
			if(!StringUtils.isEmpty(sbSubsidiaryManager.getJobLevel())) {
				dbSbSubsidiaryManager.setJobLevel(sbSubsidiaryManager.getJobLevel());
			}
			if(!StringUtils.isEmpty(sbSubsidiaryManager.getJobName())) {
				dbSbSubsidiaryManager.setJobName(sbSubsidiaryManager.getJobName());
			}
			if(!StringUtils.isEmpty(sbSubsidiaryManager.getJobType())) {
				dbSbSubsidiaryManager.setJobType(sbSubsidiaryManager.getJobType());
			}
			if(!StringUtils.isEmpty(sbSubsidiaryManager.getManagerId())) {
				dbSbSubsidiaryManager.setManagerId(sbSubsidiaryManager.getManagerId());
			}
			if(!StringUtils.isEmpty(sbSubsidiaryManager.getManagerLicenseType())) {
				dbSbSubsidiaryManager.setManagerLicenseType(sbSubsidiaryManager.getManagerLicenseType());
			}
			if(!StringUtils.isEmpty(sbSubsidiaryManager.getPhone())) {
				dbSbSubsidiaryManager.setPhone(sbSubsidiaryManager.getPhone());
			}


			sbSubsidiaryManagerDao.update(dbSbSubsidiaryManager);
		}else{
			sbSubsidiaryManager.setUserid(user.getId());
			//修改时间，创建时间在保存的时候一样
			sbSubsidiaryManager.setCreateTime(new Date());
			sbSubsidiaryManager.setUpdateTime(sbSubsidiaryManager.getCreateTime());
			//默认可用
			sbSubsidiaryManager.setActive(true);
			sbSubsidiaryManager.setUpdateBy(user.getUsername());
			sbSubsidiaryManagerDao.save(sbSubsidiaryManager);
		}
		}

	/**
	 * 删除
	 * @param sbsidiaryManager
	 */
	@Override
	public void delete(SbSubsidiaryManager sbsidiaryManager) {
		sbsidiaryManager.setUpdateTime(new Date());
		sbSubsidiaryManagerDao.delete(sbsidiaryManager);
	}

	/**
	 * 根据ID查询
	 * @param id
	 * @return
	 */
	@Override
	public SbSubsidiaryManager findById(long id){
		return sbSubsidiaryManagerDao.findById(id);
	}


	/**
	 * 查询
	 * @param dto
	 * @return
	 */
	@Override
	public SbSubsidiaryManagerSearchDto search(SbSubsidiaryManagerSearchDto dto) {
		SbSubsidiaryManagerSearchDto resultDto = new SbSubsidiaryManagerSearchDto();
		List<SbSubsidiaryManager> list =  sbSubsidiaryManagerDao.search(dto);
		resultDto.setData(list);
		resultDto.setTotalCount(sbSubsidiaryManagerDao.count(dto));
		return resultDto;
	}

	@Override
	public List<SbSubsidiaryManager> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
		return sbSubsidiaryManagerDao.searchForDataSynchronization(searchDto);
	}

	@Override
	public void saveOrUpdateForDS(SbSubsidiaryManager sbSubsidiaryManager) {

		if(sbSubsidiaryManager.getActive() == null){
			sbSubsidiaryManager.setActive(true);
		}
		
		if(!sbSubsidiaryManager.getActive()){
			sbSubsidiaryManagerDao.delete(sbSubsidiaryManager);
		}else{
			SbSubsidiaryManager dbSbSubsidiaryManager = sbSubsidiaryManagerDao.findById(sbSubsidiaryManager.getId());
			if(dbSbSubsidiaryManager == null){
				sbSubsidiaryManagerDao.saveForDS(sbSubsidiaryManager);
			}else{
				if(sbSubsidiaryManager.getUpdateTime().getTime() > dbSbSubsidiaryManager.getUpdateTime().getTime()){
					sbSubsidiaryManagerDao.update(sbSubsidiaryManager);
				}
			}
		}
	}
}


