package com.bcxin.ars.service.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.alibaba.fastjson.JSONArray;
import com.bcxin.ars.dao.*;
import com.bcxin.ars.dto.*;
import com.bcxin.ars.dto.sb.PoliceSearchDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.*;
import com.bcxin.ars.service.PoliceRoleService;
import com.bcxin.ars.service.PoliceService;
import com.bcxin.ars.service.SecurityCompanyService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.*;
import com.bcxin.ars.util.approval.BusinessType;
import com.bcxin.ars.webservice.ClientUtil;
import com.bcxin.ars.webservice.Policesecsuporg;
import com.google.common.io.Files;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service
@Transactional
@DataSyncAnnotation(getClazz = Police.class)
@DataSyncOutAnnotation(getClazz = Police.class)
public class PoliceServiceImpl implements PoliceService {


	/***
	 * 日志
	 */
	private static final Logger logger = LoggerFactory.getLogger(PoliceServiceImpl.class);
	@Autowired
	private PoliceDao policeDao;
	
	@Autowired
	private PoliceRoleDao policeRoleDao;
	
	@Autowired
	private UserDao userDao;
	
	@Autowired
	private PermissionDao permissionDao;
	
	@Autowired
	private DataAuthDao dataAuthDao;
	
	@Autowired
	private UserRoleDao userRoleDao;


	@Autowired
	private ProblemPersonDao problemPersonDao;

	@Autowired
	private ProblemPersonDaoAop problemPersonDaoAop;



	@Autowired
	private ArsUtil arsUtil;

	@Autowired
	private ClientUtil clientUtil;

	@Autowired
	private PoliceRoleService policeRoleService;

	@Autowired
	private SecurityCompanyService securityCompanyService;

	@Value("${personcertificate-download-folder}")
	private String tempftpFolder;
	/**
	 * //判断名称是否重复
	 */
	public void isRepet(PoliceSearchDto policeSearchDto,Police police){
		policeSearchDto.setAddOrgname(police.getOrgname());
		if(policeDao.count(policeSearchDto)>0){
			throw new ArsException("机构名称不能重复!");
		}
	}

	@Override
	public void updatenum(Police police){
		User user = arsUtil.getCurrentUser();
		Police dbPolice = policeDao.findById(police.getId());

		//设置修改时间
		dbPolice.setUpdateTime(new Date());
		//设置修改者
		dbPolice.setUpdateBy(user.getRealname());

		dbPolice.setUpdateflag(true);
		policeDao.update(dbPolice);

	}
	/**
	 * 保存或更新
	 * @param police
	 */
	@Override
	public void saveOrUpdate(Police police) {
		User user = arsUtil.getCurrentUser();
		PoliceSearchDto policeSearchDto = new PoliceSearchDto();

		if(police.getId() != null) {

			//同一个区域不能创建超过两个机构（派出所除外）
			isOnlyoneByareacode(police);

			//判断是否存在，如果存在则为更新否则为保存
			Police dbPolice = policeDao.findById(police.getId());
			if("1".equals(police.getOptype())){
				//升
				if(null!=dbPolice.getOrderno()&&!"".equals(dbPolice.getOrderno())){
					dbPolice.setOrderno(dbPolice.getOrderno()-1);
				}
			}else if("2".equals(police.getOptype())){
				//降
				if(null!=dbPolice.getOrderno()&&!"".equals(dbPolice.getOrderno())) {
					dbPolice.setOrderno(dbPolice.getOrderno() + 1);
				}
			}else if("3".equals(police.getOptype())){
				//复制
				//查询全部条数，赋值给orderno
				PoliceSearchDto dto = new PoliceSearchDto();
				dto.setSearchCondition(police.getParentorg()==null?"":police.getParentorg().toString());
				police.setOrderno((int)policeDao.count(dto)+1);
				police.setUserid(user.getId());
				//修改时间，创建时间在保存的时候一样
				police.setCreateTime(new Date());
				police.setUpdateTime(police.getCreateTime());
				//默认可用
				police.setActive(true);
				police.setUpdateBy(user.getUsername());
				police.setNativeCode(arsUtil.getCurrentNatvie());

				//判断名称是否重复
				isRepet(policeSearchDto,police);
				police.setUpdateflag(true);
				policeDao.save(police);

				//部级接口对接
				//异步处理
	            new Thread(()->{
					try {
						//确定对接的属性对应关系
						//源实体类的列，目标实体类的列
						String[] srccol = {"code","orgname","address","contact","tel","phone"};
						String[] desccol = {"jgjgbm","jgjgmc","bgdz","fzrmc","zbdh","czdh"};
						//key中存放的是特殊情况下的列，1源实体类没有，而目标实体类必填的2源实体类跟目标实体类值类型不匹配的，比如性别等，value存放特殊列的值。如果没有，则放空
						String[] key = {};
						String[] value = {};
						//生成实体
						Object desc = BuildWebServiceEntity.buildWebServiceEntity(srccol,desccol,police,new Policesecsuporg(),key,value);
						Policesecsuporg policesecsuporg =(Policesecsuporg)desc;
						//调用send方法完成对接
						clientUtil.send(Constants.XXBA_POLICESECSUPORG,policesecsuporg);

					} catch(Exception e) {
						logger.error(e.getMessage(),e);
					}
				}).start();

				//保存树的路径
				Police newPolice = policeDao.findById(police.getId());
				Police parentPolice = policeDao.findById(Long.valueOf(police.getParentorg()));
				//复制之后的ID替代复制之前的ID
				newPolice.setPath(parentPolice.getPath()+newPolice.getId().toString()+"/");
				newPolice.setUpdateflag(true);
				policeDao.update(newPolice);
			}
			else{
				//更新
				//判断名称是否重复,若修改为本身，则不判断
				Police policeByorgname = policeDao.findByOrgname(police.getOrgname());
				if(null!=policeByorgname){
					if(!policeByorgname.getId().equals(police.getId())){
						isRepet(policeSearchDto,police);
					}

				}
				//设置修改时间
				dbPolice.setUpdateTime(new Date());
				//设置修改者
				dbPolice.setUpdateBy(user.getRealname());
				dbPolice.setUpdateflag(true);
				//如果不为空，则更新相应字段的值
				if(!StringUtils.isEmpty(police.getAddress())) {
					dbPolice.setAddress(police.getAddress());
				}
				if(!StringUtils.isEmpty(police.getArea())) {
					dbPolice.setArea(police.getArea());
				}
				if(!StringUtils.isEmpty(police.getContact())) {
					dbPolice.setContact(police.getContact());
				}
				if(!StringUtils.isEmpty(police.getOrderno())) {
					dbPolice.setOrderno(police.getOrderno());
				}
				if(!StringUtils.isEmpty(police.getRemarks())) {
					dbPolice.setRemarks(police.getRemarks());
				}
				if(!StringUtils.isEmpty(police.getOrgname())) {
					dbPolice.setOrgname(police.getOrgname());
				}
				if(!StringUtils.isEmpty(police.getParentorg())) {
					dbPolice.setParentorg(police.getParentorg());
				}
				if(!StringUtils.isEmpty(police.getPhone())) {
					dbPolice.setPhone(police.getPhone());
				}
				if(!StringUtils.isEmpty(police.getShortname())) {
					dbPolice.setShortname(police.getShortname());
				}
				if(!StringUtils.isEmpty(police.getTel())) {
					dbPolice.setTel(police.getTel());
				}
				if(!StringUtils.isEmpty(police.getCode())) {
					dbPolice.setCode(police.getCode());
				}
				if(!StringUtils.isEmpty(police.getAreacode())) {
					dbPolice.setAreacode(police.getAreacode());
				}
				if(!StringUtils.isEmpty(police.getOrgtype())) {
					dbPolice.setOrgtype(police.getOrgtype());
				}
			}
			policeDao.update(dbPolice);


			//更新问题人员机构名称
			ProblemPerson problemPerson = new ProblemPerson();
			problemPerson.setOrgId(dbPolice.getId());
			problemPerson.setOrgName(dbPolice.getOrgname());
			problemPerson.setUpdateTime(new Date());
			problemPersonDaoAop.updateOrgInfo(problemPerson);

		}else{
			//查询全部条数，赋值给orderno
			PoliceSearchDto dto = new PoliceSearchDto();
			dto.setSearchCondition(police.getParentorg()==null?"":police.getParentorg().toString());
			police.setOrderno((int)policeDao.count(dto)+1);

			police.setUserid(user.getId());
			//修改时间，创建时间在保存的时候一样
			police.setCreateTime(new Date());
			police.setUpdateTime(police.getCreateTime());
			//默认可用
			police.setActive(true);
			police.setUpdateBy(user.getUsername());
			police.setNativeCode(arsUtil.getCurrentNatvie());

			//判断名称是否重复
			isRepet(policeSearchDto,police);

			//同一个区域不能多次创建机构，只能一次
			isOnlyoneByareacode(police);

			police.setUpdateflag(true);
			policeDao.save(police);

			//部级接口对接
			//异步处理
            new Thread(()->{
				try {
					//确定对接的属性对应关系
					//源实体类的列，目标实体类的列
					String[] srccol = {"code","orgname","address","contact","tel","phone"};
					String[] desccol = {"jgjgbm","jgjgmc","bgdz","fzrmc","zbdh","czdh"};
					//key中存放的是特殊情况下的列，1源实体类没有，而目标实体类必填的2源实体类跟目标实体类值类型不匹配的，比如性别等，value存放特殊列的值。如果没有，则放空
					String[] key = {};
					String[] value = {};
					//生成实体
					Object desc = BuildWebServiceEntity.buildWebServiceEntity(srccol,desccol,police,new Policesecsuporg(),key,value);
					Policesecsuporg policesecsuporg =(Policesecsuporg)desc;
					//调用send方法完成对接
					clientUtil.send(Constants.XXBA_POLICESECSUPORG,policesecsuporg);

				} catch(Exception e) {
					e.printStackTrace();
				}
			}).start();

			//保存树的路径
			Police newPolice = policeDao.findById(police.getId());
			Police parentPolice = policeDao.findById(Long.valueOf(police.getParentorg()));



			//复制之后的ID替代复制之前的ID
			newPolice.setPath(parentPolice.getPath()+newPolice.getId().toString()+"/");

			newPolice.setUpdateflag(true);
			policeDao.update(newPolice);
		}
	}

	/**
	 * 同一个区域不能创建超过两个机构（派出所除外）
	 * @param police
	 */
	private void isOnlyoneByareacode(Police police) {
		//判断是否派出所
		if(!Constants.POLICE_ORGTYPE_PCS.equals(police.getOrgtype())){
			//因为需要根据机构类型过滤，所以此处将其置为派出所
			Police searchPolice = new Police();
			searchPolice.setAreacode(police.getAreacode());
			searchPolice.setId(police.getId());
			searchPolice.setOrgtype(Constants.POLICE_ORGTYPE_PCS);
			List<Police> policeList = policeDao.findPoliceByAreacodeApprove(searchPolice);
			if(policeList.size()>0){
				throw new ArsException("同一个区域不能创建超过两个机构（派出所除外）!");
			}
		}
	}

	/**
	 * 删除
	 * @param police
	 */

	@Override
	public void delete(Police police) {

		/***  删除公安机构的角色 by 2018-08-28 ***/
		policeRoleService.deleteRoleByOrgId(police.getId());

		police.setUpdateTime(new Date());
		police.setUpdateflag(true);
		policeDao.delete(police);
	}

	/**
	 *根据orgname查询
	 * @param orgname
	 */
	@Override
	public Police findByOrgname(String orgname){
		return policeDao.findByOrgname(orgname);
	}

	/**
	 *根据ID查询
	 * @param id
	 */
	@Override
	public Police findById(long id){
		return policeDao.findById(id);
	}

	/**
	 * 查询
	 * @param dto
	 * @return
	 */
	@Override
	public PoliceSearchDto search(PoliceSearchDto dto) {
		PoliceSearchDto resultDto = new PoliceSearchDto();
		List<Police> list =  policeDao.search(dto);
		resultDto.setData(list);
		resultDto.setTotalCount(policeDao.count(dto));
		return resultDto;
	}

	/**
	 * 查询
	 * @param dto
	 * @return
	 */
	@Override
	public PoliceSearchDto searchAll(PoliceSearchDto dto) {
		PoliceSearchDto resultDto = new PoliceSearchDto();
		List<Police> list =  policeDao.searchAll(dto);
		resultDto.setData(list);
		return resultDto;
	}

	@Override
	public List<Tree> searchForTree(PoliceSearchDto dto) {
		User currentUser = arsUtil.getCurrentUser();
		dto.setPoliceBusiness(true);
		arsUtil.setPoliceSearch(dto);
		if(dto.getParentorg() ==null){
			//easyui传过来的是id转成parentorg
			if(dto.getId() !=null) {
				dto.setParentorg(dto.getId());
			}
		}

		List<Tree> list = policeDao.searchForTree(dto);

		List<Tree> resultList = new ArrayList<>();
		if(list != null && list.size() > 0) {

			Map<String, List<Tree>> treeMap = list.stream().collect(Collectors.groupingBy(Tree::getId));
			Map<String, List<Tree>> groupMap = list.stream().filter(((menu) -> menu.getParentId() != null)).collect(Collectors.groupingBy(Tree::getParentId));

			for (Tree tree : list) {
				if (groupMap.get(tree.getId()) != null) {
					tree.setChildren(groupMap.get(tree.getId()));
				}else{
					tree.setExpanded(true);
					tree.setState("open");
				}

				if (tree.getParentId() == null || treeMap.get(tree.getParentId()) == null) {
					resultList.add(tree);
				}
			}
		}

		return resultList;
	}

	@Override
	public List<LayTree> searchForLayTree(PoliceSearchDto dto) {
		User currentUser = arsUtil.getCurrentUser();
		dto.setPoliceBusiness(true);
		arsUtil.setPoliceSearch(dto);
		if(dto.getParentorg() ==null){
			//easyui传过来的是id转成parentorg
			if(dto.getId() !=null) {
				dto.setParentorg(dto.getId());
			}
		}

		List<LayTree> list = policeDao.searchForLayTree(dto);

		List<LayTree> resultList = new ArrayList<>();
		if(list != null && list.size() > 0) {

			Map<String, List<LayTree>> treeMap = list.stream().collect(Collectors.groupingBy(LayTree::getId));
			Map<String, List<LayTree>> groupMap = list.stream().filter(((menu) -> menu.getParentId() != null)).collect(Collectors.groupingBy(LayTree::getParentId));

			for (LayTree tree : list) {
				if (groupMap.get(tree.getId()) != null) {
					tree.setChildren(groupMap.get(tree.getId()));
				}else{
					tree.setOpen(true);
				}

				if (tree.getParentId() == null || treeMap.get(tree.getParentId()) == null) {
					resultList.add(tree);
				}
			}
		}

		return resultList;
	}

	@Override
	public List<MenuTree> searchForMenuTree(PoliceSearchDto dto){
		User currentUser = arsUtil.getCurrentUser();
		dto.setPoliceBusiness(true);
		arsUtil.setPoliceSearch(dto);
		if(dto.getParentorg() ==null){
			//easyui传过来的是id转成parentorg
			if(dto.getId() !=null) {
				dto.setParentorg(dto.getId());
			}
		}

		List<MenuTree> list = policeDao.searchForMenuTree(dto);

		List<MenuTree> resultList = new ArrayList<>();
		if(list != null && list.size() > 0) {
			boolean disabled = false;
			if(dto.getRoleId() != null) {
				List<PoliceRole> roleList = currentUser.getRoles();
				if (roleList != null && roleList.size() > 0) {
					for (PoliceRole role : roleList) {
						if (role.getId().longValue() == dto.getRoleId().longValue()) {
							disabled = true;
						}
					}
				}
			}

			Map<String, List<MenuTree>> treeMap = list.stream().collect(Collectors.groupingBy(MenuTree::getId));
			Map<String, List<MenuTree>> groupMap = list.stream().filter(((menu) -> menu.getParentId() != null)).collect(Collectors.groupingBy(MenuTree::getParentId));

			for (MenuTree menuTree : list) {
				menuTree.setDisabled(disabled);
				if (groupMap.get(menuTree.getId()) != null) {
					menuTree.setChildren(groupMap.get(menuTree.getId()));
					menuTree.setChecked(false);
				}

				if (menuTree.getParentId() == null || treeMap.get(menuTree.getParentId()) == null) {
					menuTree.setSpread(true);
					resultList.add(menuTree);
				}
			}
		}

		return resultList;
	}

	/**
	 * 查询区域
	 * @param dto
	 * @return
	 */
	@Override
	public PoliceSearchDto searchArea(PoliceSearchDto dto) {
		PoliceSearchDto resultDto = new PoliceSearchDto();
		List<Police> list =  policeDao.searchArea(dto);
		resultDto.setData(list);
		return resultDto;
	}

	/**
	 * 查询
	 * @param parentorg
	 * @return
	 */
	@Override
	public 	List<Police> findByParentOrg(Long parentorg) {
		List<Police> list =  policeDao.findByParentOrg(parentorg);
		return list;
	}

	/**
	 * 查询
	 *
	 * @return
	 */
	@Override
	public 	List<Police> searchParentorg(Police police) {
		List<Police> list =  policeDao.searchParentorg(police);
		return list;
	}

	@Override
	public List<TreeView> searchForTreeView(PoliceSearchDto dto) {
		User currentUser = arsUtil.getCurrentUser();
		dto.setPoliceBusiness(true);
		arsUtil.setPoliceSearch(dto);
		if(dto.getParentorg() ==null){
			//easyui传过来的是id转成parentorg
			if(dto.getId() !=null) {
				dto.setParentorg(dto.getId());
			}
		}

		List<TreeView> list = policeDao.searchPoliceForTreeViewByprint(dto);

		List<TreeView> resultList = new ArrayList<>();
		if(list != null && list.size() > 0) {
			Map<String, List<TreeView>> treeMap = list.stream().collect(Collectors.groupingBy(TreeView::getNodeid));
			Map<String, List<TreeView>> groupMap = list.stream().filter(((menu) -> menu.getParentid() != null)).collect(Collectors.groupingBy(TreeView::getParentid));

			for (TreeView menuTree : list) {
				if (groupMap.get(menuTree.getNodeid()) != null) {
					menuTree.setNodes(groupMap.get(menuTree.getNodeid()));
				}

				if (menuTree.getParentid() == null || treeMap.get(menuTree.getParentid()) == null) {
					menuTree.setShowExpanded(true);
					resultList.add(menuTree);
				}
			}
		}

		return resultList;
	}
	@Override
	public List<TreeView> findAllForTreeViewPower(PoliceSearchDto dto) {
		User currentUser = arsUtil.getCurrentUser();
		dto.setPoliceBusiness(true);
		arsUtil.setPoliceSearch(dto);
		if(dto.getParentorg() ==null){
			//easyui传过来的是id转成parentorg
			if(dto.getId() !=null) {
				dto.setParentorg(dto.getId());
			}
		}

		List<TreeView> list = policeDao.searchPoliceForTreeViewByprint(dto);

		List<TreeView> resultList = new ArrayList<>();
		if(list != null && list.size() > 0) {
			Map<String, List<TreeView>> treeMap = list.stream().collect(Collectors.groupingBy(TreeView::getNodeid));
			Map<String, List<TreeView>> groupMap = list.stream().filter(((menu) -> menu.getParentid() != null)).collect(Collectors.groupingBy(TreeView::getParentid));

			for (TreeView menuTree : list) {
				if (groupMap.get(menuTree.getNodeid()) != null) {
					menuTree.setNodes(groupMap.get(menuTree.getNodeid()));
				}

				if (menuTree.getParentid() == null || treeMap.get(menuTree.getParentid()) == null) {
					menuTree.setShowExpanded(true);
					resultList.add(menuTree);
				}
			}
		}

		return resultList;
	}

    @Override
    public List<Police> findByType(String type) {
        return policeDao.findByType(type);
    }

    @Override
	public List<TreeView> searchForTreeViewByprint(PoliceSearchDto dto) {
		User currentUser = arsUtil.getCurrentUser();
		dto.setPoliceBusiness(true);
		arsUtil.setPoliceSearch(dto);
		if(dto.getParentorg() ==null){
			//easyui传过来的是id转成parentorg
			if(dto.getId() !=null) {
				dto.setParentorg(dto.getId());
			}
		}

		List<TreeView> list = policeDao.searchPoliceForTreeViewByprint(dto);

		List<TreeView> resultList = new ArrayList<>();
		if(list != null && list.size() > 0) {
			Map<String, List<TreeView>> treeMap = list.stream().collect(Collectors.groupingBy(TreeView::getNodeid));
			Map<String, List<TreeView>> groupMap = list.stream().filter(((menu) -> menu.getParentid() != null)).collect(Collectors.groupingBy(TreeView::getParentid));

			for (TreeView menuTree : list) {
				if (groupMap.get(menuTree.getNodeid()) != null) {
					menuTree.setNodes(groupMap.get(menuTree.getNodeid()));
				}

				if (menuTree.getParentid() == null || treeMap.get(menuTree.getParentid()) == null) {
					menuTree.setShowExpanded(true);
					resultList.add(menuTree);
				}
			}
		}

		return resultList;
	}
	@Override
	public List<TreeView> searchPoliceForTreeViewByprint(PoliceSearchDto dto) {
		User currentUser = arsUtil.getCurrentUser();
		dto.setPoliceBusiness(true);
		arsUtil.setPoliceSearch(dto);
		if(dto.getParentorg() ==null){
			//easyui传过来的是id转成parentorg
			if(dto.getId() !=null) {
				dto.setParentorg(dto.getId());
			}
		}

		List<TreeView> list = policeDao.searchPoliceForTreeViewByprint(dto);

		List<TreeView> resultList = new ArrayList<>();
		if(list != null && list.size() > 0) {
			Map<String, List<TreeView>> treeMap = list.stream().collect(Collectors.groupingBy(TreeView::getNodeid));
			Map<String, List<TreeView>> groupMap = list.stream().filter(((menu) -> menu.getParentid() != null)).collect(Collectors.groupingBy(TreeView::getParentid));

			for (TreeView menuTree : list) {
				if (groupMap.get(menuTree.getNodeid()) != null) {
					menuTree.setNodes(groupMap.get(menuTree.getNodeid()));
				}

				if (menuTree.getParentid() == null || treeMap.get(menuTree.getParentid()) == null) {
					menuTree.setShowExpanded(true);
					resultList.add(menuTree);
				}
			}
		}

		return resultList;
	}
	@Override
	public List<Police> findByAreaUserId(User user) {

		Police police = policeDao.findById(user.getOrgid());

		police.setUserid(user.getId());
		return policeDao.findByAreaUserId(police);
	}

	@Override
	public List<Police> findAll() {
		return policeDao.findAll();
	}
	
	/**
	 * 外网导内网专用 （修改内网导外网完成标记）
	 */
	@Override
	public void saveOrUpdateForDS(Police police) {
		Police dbPolice = policeDao.findById(police.getId());
		if(dbPolice == null){
//			policeDao.saveForDS(police);//公安机构只在内网创建，所以外网导内网不新增。
		}else{
			if(police.getUpdateTime().getTime() > dbPolice.getUpdateTime().getTime()){
				if(!police.getActive()){
					policeDao.delete(police);
				}else{
					policeDao.update(police);
				}
			}
		}
	}

	/**
	 * 同步内/外网数据
	 */
//	@Override
//	public void syncMergePolice(List<Police> policeList) {
//
//	}

	/**
	 * 根据区域编码查询police
	 * @param police
	 * @return
	 */
	@Override
	public List<Police>  findPoliceByAreacode(Police police){
		return  policeDao.findPoliceByAreacode(police);
	}

	private void writeTxtFile(String readStr, String type) {
		try {
			//路径
			String basePath = tempftpFolder;
			//保存路径
			String filePath = basePath + com.bcxin.ars.util.DateUtil.getCurrentDate() + File.separator;

			String fileName = type;
			String fileType = ".data";
			File file = new File(filePath);
			if (!file.exists()) {
				file.mkdirs();
				System.out.println("文件夹已创建");
			}
			String fullFilePath = filePath + fileName + "_"+ com.bcxin.ars.util.DateUtil.getCurrentDateTime(com.bcxin.ars.util.DateUtil.FORMAT8) + fileType;

			//文件处理：写入文件
			File newFile = new File(fullFilePath);
			Files.write(readStr.getBytes(), newFile);
		} catch (Exception e) {
			System.out.println("导出失败！");
		}
	}

	@Override
	public void autoExportPolice() {

		//默认导最近两天的数据
		List<Police> policeList = policeDao.searchForExport(DateUtil.getYesterday());

		if (policeList != null && policeList.size() > 0) {
			try {
				for (Police p:policeList) {
					p.setUpdateflag(false);
					String policeStr = JSONArray.toJSONString(p);
					System.out.println(policeStr);
					String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(policeStr.getBytes(), Constants.APPROVAL_KEY));
					writeTxtFile(content, "police");

					policeDao.updateFlag(p);


				}

			} catch (Exception e) {
				System.out.println("导出失败！");
			}
		}

	}

	@Override
	public OrgUserDto findOrgUserForDS(String startDate) {
		OrgUserDto orgUserDto = new OrgUserDto();
		List<Police> policelist = policeDao.searchForExport(startDate);
		List<PoliceRole> policeRolelist = policeRoleDao.searchFromInToOutForExport(startDate);
		List<User> userlist = userDao.searchFromInToOutForExport(startDate);

		orgUserDto.setPolicelist(policelist);
		orgUserDto.setPoliceRolelist(policeRolelist);
		orgUserDto.setUserlist(userlist);
		
		return orgUserDto;
	}

	@Override
	@Deprecated
	public void saveOrUpdateForImport(Police police) {
		police.setUpdateflag(false);
		police.setUpdateTime(new Date());
		Police dbPolice = policeDao.findById(police.getId());
		if(dbPolice == null){
			policeDao.saveForDS(police);
		}else{
			if(police.getUpdateTime().getTime() > dbPolice.getUpdateTime().getTime()){
				policeDao.updateForDS(police);
			}
		}
	}

	@Override
	public List<Police> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
		return policeDao.searchForDataSynchronization(searchDto);
	}

	/**
	 * 更新 是否导出isexport标志位
	 * @param policeSearchDto
	 */
	@Override
	public void updateExport(PoliceSearchDto policeSearchDto) {
		policeDao.updateExport(policeSearchDto);
	}

	@Override
	public List<PoliceDto> searchForSaas(PoliceSearchDto policeSearchDto) {
		return policeDao.searchForSaas(policeSearchDto);
	}

	@Override
	public List<Police> findDSOutList(String startDate) {
		return policeDao.searchForExport(startDate);
	}

	/**
	 * 批量导入
	 * @param list
	 */
	@Override
	public void importBatch(List<Police> list){
		List<Police> dbList = policeDao.findByBatchId(list);
		//去掉重复的
		//通过重写 equals跟hashCode方法 实现根据id与updatetime判断是否需要更新。
		list.removeAll(dbList);

		if (list.size()>0){
			for(Police detail:list){
				detail.setUpdateflag(false);
				try {
					detail.setUpdateTime(DateUtil.dateAdd(DateUtil.DATATYPE_SECOND, detail.getUpdateTime(), 1));
				}catch (Exception e){

				}
			}
			//批量保存
			policeDao.saveBatch(list);
		}
	}
    @Override
	public List<Police> findDataPoliceForUserID(Long userId) {
		return policeDao.findDataPoliceForUserID(userId);
	}

    @Override
    public Police getApprovalMinOrgTypePolice(String areaCode,String businessTypeCode,String sponsorlicenseType) {
		StringBuffer tempCode =  new StringBuffer();
		if(BusinessType.NDBG.equals(businessTypeCode) && StringUtil.isEmpty(sponsorlicenseType)){
			SecurityCompany company =securityCompanyService.getCurrentUserCompany();
			if (company != null) {
				sponsorlicenseType = StringUtil.isEmpty(company.getSponsorlicenseType())? "01":company.getSponsorlicenseType();
			}
		}
		if(Constants.GUANGXICODE.equals(areaCode)) {
			tempCode.append(BusinessType.getBusinessTypeName(businessTypeCode, sponsorlicenseType));
		}else{
			tempCode.append(BusinessType.getBusinessTypeName(businessTypeCode, sponsorlicenseType)).append("-").append(areaCode);
		}
        return policeDao.getApprovalMinOrgTypePolice(tempCode.toString());
    }
}

