package com.bcxin.ars.service.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.OrderPersonDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.OrderPersonSearchDto;
import com.bcxin.ars.model.OrderPerson;
import com.bcxin.ars.service.OrderPersonService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

/**
 * 订单与保安人员关系服务类
 * @author Ethan
 */

@Service
@Transactional
//@DataSyncAnnotation(getClazz = OrderPerson.class)
public class OrderPersonServiceImpl implements OrderPersonService{

	@Autowired
	private OrderPersonDao orderPersonDao;
	
	@Override
	public void save(OrderPerson orderPerson) {
		orderPersonDao.save(orderPerson);
	}

	@Override
	public OrderPerson findById(Long id) {
		return orderPersonDao.findById(id);
	}

	@Override
	public List<OrderPerson> findListByOrderId(Long orderId) {
		OrderPersonSearchDto dto = new OrderPersonSearchDto();
		dto.setOrderid(orderId);
		return orderPersonDao.findListByOrderId(dto);
	}

	@Override
	public OrderPersonSearchDto findByOrderid(OrderPersonSearchDto dto) {
		OrderPersonSearchDto resultDto = new OrderPersonSearchDto();
		List<OrderPerson> list =  orderPersonDao.findListByOrderId(dto);
		resultDto.setData(list);
		resultDto.setTotalCount(orderPersonDao.countByOrderId(dto));
		return resultDto;
	}
	@Override
	public List<OrderPerson> findAll(){
		return  orderPersonDao.findAll();
	}
	@Override
	public void updateTrainInfo(OrderPerson orderPerson){
		orderPerson.setUpdateTime(new Date());
		orderPersonDao.updateTrainInfo(orderPerson);
	}

	@Override
	public List<OrderPerson> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
		return orderPersonDao.searchForDataSynchronization(searchDto);
	}

	@Override
	public void saveOrUpdateForDS(OrderPerson orderPerson) {

		if(orderPerson.getActive() == null){
			orderPerson.setActive(true);
		}
		
		if(!orderPerson.getActive()){
			orderPersonDao.delete(orderPerson);
		}else{
			OrderPerson dbOrderPerson = orderPersonDao.findById(orderPerson.getId());
			if(dbOrderPerson == null){
				orderPersonDao.saveForDS(orderPerson);
			}else{
				if(orderPerson.getUpdateTime().getTime() > dbOrderPerson.getUpdateTime().getTime()){
					orderPersonDao.update(orderPerson);
				}
			}
		}
		
	}

	
}