package com.bcxin.ars.service.impl;

import com.bcxin.ars.dao.LoginLogDao;
import com.bcxin.ars.dto.LoginLogSearchDto;
import com.bcxin.ars.dto.page.LoginLogPageSearchDto;
import com.bcxin.ars.model.LoginLog;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.LoginLogService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.util.Date;
import java.util.List;

@Service
public class LoginLogServiceImpl implements LoginLogService {

	private static final Logger logger = LoggerFactory.getLogger(LoginLogServiceImpl.class);

	@Autowired
	private LoginLogDao loginLogDao;

	@Autowired
	private ArsUtil arsUtil;
	
	@Override
	public void save(LoginLog loginLog){
		loginLog.setUpdateTime(new Date());
		loginLogDao.save(loginLog);
	}

	@Override
	public void save(User user,String type){
		LoginLog loginLog = new LoginLog();
		loginLog.setType(type);
		loginLog.setUsername(user.getUsername());
		loginLog .setUpdateTime(new Date());
		loginLogDao.save(loginLog);
	}
	
	@Override
	public void logIn(HttpServletRequest request){
		//获取登录设备
		try {
			String userAgent = request.getHeader("User-Agent");
			User user = arsUtil.getCurrentUser();
			if(user == null) {
//				logger.error("==========> LoginLogService.logIn，异常：用户状态不存在！");
				throw new Exception("==========> LoginLogService.logIn，异常：用户状态不存在！") ;
			}
			LoginLog loginLog = new LoginLog();
			loginLog.setType("1");
			loginLog.setIpAddress(getRemoteAddrIp(request));
			loginLog.setUsername(user.getUsername());
			loginLog .setUpdateTime(new Date());
			loginLog.setUserAgent(userAgent);
			loginLogDao.save(loginLog);
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
		}
	}
	
	@Override
	public void logOut(HttpServletRequest request){
		try {
			User user = arsUtil.getCurrentUser();
			if(user == null) {
//				logger.error("==========> LoginLogServiceImpl.logOut，异常：用户状态不存在！");
				throw new Exception("==========> LoginLogService.logOut，异常：用户状态不存在！") ;
			}
			LoginLog loginLog = new LoginLog();
			loginLog.setType("2");
			loginLog.setIpAddress(getRemoteAddrIp(request));
			loginLog.setUsername(user.getUsername());
			loginLog .setUpdateTime(new Date());
			loginLogDao.save(loginLog);
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
		}
	}
	
	@Override
	public LoginLogSearchDto search(LoginLogSearchDto dto) {
		User user = arsUtil.getCurrentUser();
		if(user == null) {
			return null;
		}
		List<LoginLog> data = loginLogDao.search(dto);
		Long count = loginLogDao.searchCount(dto);
		dto.setData(data);
		dto.setTotalCount(count);
		return dto;
	}

	@Override
	public void searchForPage(LoginLogPageSearchDto dto, AjaxPageResponse page) {
		arsUtil.setPoliceSearch(dto);
		loginLogDao.searchForPage(dto,page);
	}

	public String getRemoteAddrIp(HttpServletRequest request) {
		String ipFromNginx = getHeader(request, "X-Real-IP");
		System.out.println("ipFromNginx:" + ipFromNginx);
		System.out.println("getRemoteAddr:" + request.getRemoteAddr());
		return StringUtil.isEmpty(ipFromNginx) ? request.getRemoteAddr() : ipFromNginx;
	}


	private String getHeader(HttpServletRequest request, String headName) {
		String value = request.getHeader(headName);
		return !StringUtil.isBlank(value) && !"unknown".equalsIgnoreCase(value) ? value : "";
	}
}
