package com.bcxin.ars.service.impl;

import com.bcxin.ars.dao.FilerecordOutDao;
import com.bcxin.ars.model.FilerecordOut;
import com.bcxin.ars.service.FilerecordOutService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Service
@Transactional
public class FilerecordOutServiceImpl implements FilerecordOutService {

	@Autowired
	private FilerecordOutDao filerecordOutDao;

	/**
	 * 保存或更新
	 * @param filerecordOut
	 */
	@Override
	public void saveOrUpdate(FilerecordOut filerecordOut) {
		filerecordOutDao.save(filerecordOut);
		}


	/**
	 *根据ID查询
	 * @param id
	 */
	@Override
	public FilerecordOut findById(long id){
		return filerecordOutDao.findById(id);
	}

	/**
	 *根据filepath查询
	 * @param filepath
	 */
	@Override
	public FilerecordOut findByFilepath(String filepath){
		return filerecordOutDao.findByFilepath(filepath);
	}


	@Override
	public void save(FilerecordOut filerecordOut) {
		filerecordOutDao.save(filerecordOut);
	}

	@Override
	public List<FilerecordOut> findFilerecordOutByTime(String startDate,String endDate) {
		return filerecordOutDao.findFilerecordOutByTime( startDate, endDate);
	}

}


