package com.bcxin.ars.service.impl;

import com.bcxin.ars.dao.DatasyncDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.DatasyncSearchDto;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.Datasync;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.DatasyncService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.DataSyncUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.HttpClientUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.io.File;
import java.util.Date;
import java.util.List;

@Service
@Transactional
public class DatasyncServiceImpl implements DatasyncService {

	private Logger logger = LoggerFactory.getLogger(DatasyncServiceImpl.class);

	@Autowired
	private DatasyncDao datasyncDao;


	@Autowired
	private ArsUtil arsUtil;

	@Autowired
	private ConfigUtils configUtils;

	@Autowired
	private DataSyncUtil dataSyncUtil;

	/**
	 * 保存或更新
	 * @param datasync
	 */
	@Override
	public void saveOrUpdate(Datasync datasync) {
        User user = arsUtil.getCurrentUser();
		//判断是否存在，如果存在则为更新否则为保存
		Datasync dbDatasync = datasyncDao.findById(datasync.getId());
		if(dbDatasync != null) {
			//设置修改时间
			dbDatasync.setUpdateTime(new Date());
			//设置修改者
			dbDatasync.setUpdateBy(user.getRealname());
			//如果不为空，则更新相应字段的值
			if(!StringUtils.isEmpty(datasync.getOpdate())) {
				dbDatasync.setOpdate(datasync.getOpdate());
			}
			if(!StringUtils.isEmpty(datasync.getOpfun())) {
				dbDatasync.setOpfun(datasync.getOpfun());
			}
			if(!StringUtils.isEmpty(datasync.getState())) {
				dbDatasync.setState(datasync.getState());
			}
			datasyncDao.update(dbDatasync);
		}else{
			//修改时间，创建时间在保存的时候一样
			datasync.setCreateTime(new Date());
			datasync.setUpdateTime(datasync.getCreateTime());
			//默认可用
			datasync.setActive(true);
			datasync.setUpdateBy(user.getUsername());
			datasyncDao.save(datasync);
		}
		}

	/**
	 * 删除
	 * @param datasync
	 */

	@Override
	public void delete(Datasync datasync) {
		datasync.setUpdateTime(new Date());
		datasyncDao.delete(datasync);
	}

	/**
	 *根据ID查询
	 * @param id
	 */
	@Override
	public Datasync findById(long id){
		return datasyncDao.findById(id);
	}

	/**
	 *根据ID查询
	 * @param bid
	 */
	@Override
	public Datasync findByBid(long bid){
		return datasyncDao.findByBid(bid);
	}

	/**
	 * 查询
	 * @param dto
	 * @return
	 */
	@Override
	public DatasyncSearchDto search(DatasyncSearchDto dto) {
		DatasyncSearchDto resultDto = new DatasyncSearchDto();
		List<Datasync> list =  datasyncDao.search(dto);
		resultDto.setData(list);
		resultDto.setTotalCount(datasyncDao.count(dto));
		return resultDto;
	}

	@Override
	public List<Datasync> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
		return datasyncDao.searchForDataSynchronization(searchDto);
	}

	@Override
	public void saveOrUpdateForDS(Datasync datasync) {
		Datasync dbDatasync = datasyncDao.findById(datasync.getId());
		if(dbDatasync == null) {
			datasyncDao.saveForDS(datasync);
		} else {
			if(datasync.getUpdateTime().getTime() > dbDatasync.getUpdateTime().getTime()){
				datasyncDao.update(datasync);
			}
			
		}
	}



	/**
	 * 内网生成数据同步文件 非北京使用
	 */
	@Override
	public void createToOutDataFile(String startDate) {
		//内到外生成
		/***
		 * 最后同步日期
		 */
		boolean updateKey = false;
		if(StringUtils.isEmpty(startDate)){
			updateKey =  true;
			startDate = DateUtil.getYesterday();
			Config lastDateConfig = configUtils.getConfigByKey(Constants.DATASYNC_LASTDATE);
			//配置为空或者等于当天日期
			if (lastDateConfig == null || DateUtil.convertDateToString(new Date(), DateUtil.FORMAT2).equals(lastDateConfig.getValue())) {
			} else {
				startDate = lastDateConfig.getValue();
			}
		}
		String dirDate = DateUtil.getCurrentDate();
		String filePath = configUtils.intToOutFolder + dirDate + File.separatorChar;
		dataSyncUtil.createDSFile(startDate, filePath);

		/**
		 * 更新"内到外最后同步日期" start
		 */
		if(updateKey) {
			Config updateConfig = new Config();
			updateConfig.setKey(Constants.DATASYNC_LASTDATE);
			updateConfig.setValue(DateUtil.getCurrentDate());
			configUtils.updateForKey(updateConfig);
		}
	}



	/**
	 * 内网生成数据同步文件 北京使用
	 */
	@Override
	public void createToOutDataFileByHttp(String startDate){
		//内到外生成
		/***
		 * 最后同步日期
		 */

		boolean updateKey = false;
		if(StringUtils.isEmpty(startDate)) {
			updateKey = true;
			startDate = DateUtil.getYesterday();
			Config lastDateConfig = configUtils.getConfigByKey(Constants.DATASYNC_LASTDATE);
			//配置为空或者等于当天日期
			if (lastDateConfig == null || DateUtil.convertDateToString(new Date(), DateUtil.FORMAT2).equals(lastDateConfig.getValue())) {
			} else {
				startDate = lastDateConfig.getValue();
			}
		}
		String dirDate = DateUtil.getCurrentDate();
		String filePath = configUtils.uploadInToOutFolder + dirDate + File.separatorChar;
		String resultPath =  dataSyncUtil.createDSFile(startDate,filePath);
		//发送给广西
		try {
			AjaxResult ajaxResult = HttpClientUtils.FilePost(configUtils.GX_IN_URL, new File(resultPath));
			if(ajaxResult.isSuccessful() && updateKey){
				/**
				 * 更新"内到外最后同步日期" start
				 */
				Config updateConfig = new Config();
				updateConfig.setKey(Constants.DATASYNC_LASTDATE);
				updateConfig.setValue(DateUtil.getCurrentDate());
				configUtils.updateForKey(updateConfig);
				/**
				 * 更新"内到外最后同步日期" end
				 */
			}
		}catch (Exception e ){
			logger.error(e.getMessage(),e);
		}

	}

 }


