package com.bcxin.ars.service.impl;

import java.util.Date;
import java.util.List;

import com.bcxin.ars.dao.PoliceRoleDao;
import com.bcxin.ars.model.PoliceRole;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.bcxin.ars.dao.DataAuthDao;
import com.bcxin.ars.dto.DataAuthSearchDto;
import com.bcxin.ars.model.DataAuth;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.DataAuthService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.StringUtil;

@Service
@Transactional
public class DataAuthServiceImpl implements DataAuthService{

	@Autowired
	private DataAuthDao dataAuthDao;

	@Autowired
	private PoliceRoleDao policeRoleDao;
	
	@Autowired
	private ArsUtil arsUtil;
	
	
	@Override
	public DataAuth findById(long id) {
		return dataAuthDao.findById(id);
	}

	@Override
	public void saveOrUpdate(DataAuth dataAuth) {
		User currentUser = arsUtil.getCurrentUser();
		
		if(dataAuth.getId() == null){
			dataAuth.setActive(true);
			dataAuth.setCreateTime(new Date());
			dataAuth.setUpdateTime(new Date());
			dataAuth.setUpdateBy(currentUser.getUsername());
			dataAuthDao.save(dataAuth);
		}else{
			DataAuth dbDataAuth = dataAuthDao.findById(dataAuth.getId());
			dbDataAuth.setUpdateBy(currentUser.getUsername());
			dbDataAuth.setUpdateTime(new Date());
			dbDataAuth.setRoleid(dataAuth.getRoleid());
			dbDataAuth.setOrgid(dataAuth.getOrgid());
			dataAuthDao.update(dbDataAuth);
		}
		
	}

	@Override
	public DataAuthSearchDto search(DataAuthSearchDto dto) {
		User user = arsUtil.getCurrentUser();
		if(user == null || user.getPlatform().intValue() != 1) {
			return null;
		}
		List<DataAuth> list =  dataAuthDao.search(dto);
		Long count = dataAuthDao.searchCount(dto);
		dto.setData(list);
		dto.setTotalCount(count);
		return dto;
	}

	@Override
	public void delete(DataAuth dataAuth) {
		User currentUser = arsUtil.getCurrentUser();
		dataAuth.setUpdateBy(currentUser.getUsername());
		dataAuth.setUpdateTime(new Date());
		dataAuthDao.delete(dataAuth);
	}

	@Override
	public List<DataAuth> findByOrgId(Long orgid) {
		return dataAuthDao.findByOrgId(orgid);
	}

	@Override
	public List<DataAuth> findByRoleId(Long roleid) {
		return dataAuthDao.findByRoleId(roleid);
	}

	@Override
	public void saveOrUpdate(Long roleid, String orgIds) {
		//删除已有的数据权限
		dataAuthDao.deleteByRole(roleid);
		/***
		 * 新增数据权限
		 */
		//前端传过来的参数以，为分割符
		for (String orgid : orgIds.split(",")) {
			if(StringUtil.isNotEmpty(orgid)){
				//定义临时数据权限对象
				DataAuth auth = new DataAuth();
				//角色ID
				auth.setRoleid(roleid);
				//机构
				auth.setOrgid(Long.parseLong(orgid));
				//保存
				saveOrUpdate(auth);
			}
		}
		//已授权
		PoliceRole policeRole = policeRoleDao.findById(roleid);
		policeRole.setDatarole("1");
		policeRole.setUpdateTime(new Date());
        policeRoleDao.update(policeRole);
	}

	@Override
	public List<DataAuth> findAll() {
		return dataAuthDao.findAll();
	}

	@Override
	public void saveOrUpdateForDS(DataAuth dataAuth) {
		DataAuth dbDataAuth = dataAuthDao.findByRoleIdAndOrgId(dataAuth.getRoleid(),dataAuth.getOrgid());
		if(dbDataAuth == null){
			dataAuthDao.save(dataAuth);
		}
	}

}
