package com.bcxin.ars.service.impl;

import com.bcxin.ars.dao.CommonComplaintDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.page.CommonComplaintPageSearchDto;
import com.bcxin.ars.model.CommonComplaint;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.CommonComplaintService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.DateUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;
/**
 * 市民意见建议Service实现类
 *
 * @author linqinglin
 * @Date 2020-08-07 10:39:15
 */
@Service
@Transactional
public class CommonComplaintServiceImpl implements CommonComplaintService {

	Logger logger = LoggerFactory.getLogger(CommonComplaintServiceImpl.class);

	@Autowired
	private CommonComplaintDao commonComplaintDao;

	@Autowired
	private ConfigUtils configUtils;

	@Autowired
	private ArsUtil arsUtil;

	@Override
	public int delete(CommonComplaint commonComplaint) {
		User currentUser = arsUtil.getCurrentUser();
		commonComplaint.setUpdateTime(new Date());
		commonComplaint.setUpdateBy(currentUser.getUsername());
		return commonComplaintDao.delete(commonComplaint);
	}

	@Override
	public int save(CommonComplaint commonComplaint) {
		User currentUser = arsUtil.getCurrentUser();
		if(commonComplaint.getId() == null){
			commonComplaint.setCreateTime(new Date());
		}else{
			CommonComplaint dbCommonComplaint = commonComplaintDao.findById(commonComplaint.getId());
			BeanUtils.copyPropertiesIgnore(commonComplaint,dbCommonComplaint,true);
			BeanUtils.copyPropertiesIgnore(dbCommonComplaint,commonComplaint,false);
		}

		commonComplaint.setActive(true);
		commonComplaint.setUpdateBy(currentUser.getUsername());
		commonComplaint.setUpdateTime(new Date());
		commonComplaint.setUpdateflag(true);
		commonComplaint.setUserId(currentUser.getId());
		commonComplaint.setAreaCode(currentUser.getPolice().getAreacode());
		return commonComplaintDao.save(commonComplaint);
	}

	@Override
	public CommonComplaint findById(Long id) {
		return commonComplaintDao.findById(id);
	}

	@Override
	public void searchForPage(CommonComplaintPageSearchDto dto, AjaxPageResponse page) {
		arsUtil.setPoliceSearch(dto);
		commonComplaintDao.searchForPage(dto,page);
	}

	@Override
	public void importBatch(List<CommonComplaint> list) {
		List<CommonComplaint> dbList = commonComplaintDao.findByBatchId(list);
		//去掉重复的
		//通过重写 equals跟hashCode方法 实现根据id与updatetime判断是否需要更新。
		list.removeAll(dbList);
		if (list.size()>0){
			for (CommonComplaint commonComplaint : list) {
				commonComplaint.setUpdateflag(false);
				try {
					if(!configUtils.isIntranet()){
						commonComplaint.setUpdateTime(DateUtil.dateAdd(DateUtil.DATATYPE_SECOND, commonComplaint.getUpdateTime(), 1));
					}
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
			commonComplaintDao.saveBatch(list);
		}
	}

	@Override
	public List<CommonComplaint> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
		return commonComplaintDao.searchForDataSynchronization(dto);
	}

	@Override
	public List<CommonComplaint> findDSOutList(String startDate) {
		return commonComplaintDao.findDSOutList(startDate);
	}

	@Override
	public List<CommonComplaint> findByBatchId(List<CommonComplaint> list) {
		return commonComplaintDao.findByBatchId(list);
	}

	@Override
	public void updateSelective(CommonComplaint commonComplaint) {
		User currentUser = arsUtil.getCurrentUser();
		commonComplaint.setUpdateTime(new Date());
		commonComplaint.setUpdateBy(currentUser.getUsername());
		commonComplaintDao.updateSelective(commonComplaint);
	}
}
