package com.bcxin.ars.service.impl;


import com.bcxin.ars.dao.ComStateChangeLogDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.page.ComStateChangeLogPageSearchDto;
import com.bcxin.ars.model.ComStateChangeLog;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.ComStateChangeLogService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.DateUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * 自招单位状态变更日志Service业务层处理
 * 
 * @author lin
 * @date 2020-11-04
 */
@Service
public class ComStateChangeLogServiceImpl implements ComStateChangeLogService {
    
    Logger logger = LoggerFactory.getLogger(ComStateChangeLogServiceImpl.class);
    
    @Autowired
    private ComStateChangeLogDao comStateChangeLogDao;


    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private ArsUtil arsUtil;

    @Override
    public int delete(ComStateChangeLog comStateChangeLog) {
        User currentUser = arsUtil.getCurrentUser();
        comStateChangeLog.setUpdateTime(new Date());
        comStateChangeLog.setUpdateBy(currentUser.getUsername());
        return comStateChangeLogDao.delete(comStateChangeLog);
    }

    @Override
    public int save(ComStateChangeLog comStateChangeLog) {
        User currentUser = arsUtil.getCurrentUser();
        if(comStateChangeLog.getId() == null){
            comStateChangeLog.setCreateTime(new Date());
        }else{
            ComStateChangeLog dbComStateChangeLog = comStateChangeLogDao.findById(comStateChangeLog.getId());
            BeanUtils.copyPropertiesIgnore(comStateChangeLog,dbComStateChangeLog,true);
            BeanUtils.copyPropertiesIgnore(dbComStateChangeLog,comStateChangeLog,false);
        }

        comStateChangeLog.setActive(true);
        comStateChangeLog.setUpdateBy(currentUser.getUsername());
        comStateChangeLog.setUpdateTime(new Date());
        comStateChangeLog.setUpdateflag(true);
        comStateChangeLog.setUserId(currentUser.getId());
        comStateChangeLog.setAreaCode(currentUser.getPolice().getAreacode());
        return comStateChangeLogDao.save(comStateChangeLog);
    }

    @Override
    public ComStateChangeLog findById(Long id) {
        return comStateChangeLogDao.findById(id);
    }

    @Override
    public void searchForPage(ComStateChangeLogPageSearchDto dto, AjaxPageResponse page) {
        arsUtil.setPoliceSearch(dto);
        comStateChangeLogDao.searchForPage(dto,page);
    }

    @Override
    public void importBatch(List<ComStateChangeLog> list) {
        List<ComStateChangeLog> dbList = comStateChangeLogDao.findByBatchId(list);
        //去掉重复的
        //通过重写 equals跟hashCode方法 实现根据id与updatetime判断是否需要更新。
        list.removeAll(dbList);
        if (list.size()>0){
            for (ComStateChangeLog comStateChangeLog : list) {
                comStateChangeLog.setUpdateflag(false);
                try {
                    if(!configUtils.isIntranet()){
                        comStateChangeLog.setUpdateTime(DateUtil.dateAdd(DateUtil.DATATYPE_SECOND, comStateChangeLog.getUpdateTime(), 1));
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
            comStateChangeLogDao.saveBatch(list);
        }
    }

    @Override
    public List<ComStateChangeLog> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return comStateChangeLogDao.searchForDataSynchronization(dto);
    }

    @Override
    public List<ComStateChangeLog> findDSOutList(String startDate) {
        return comStateChangeLogDao.findDSOutList(startDate);
    }

    @Override
    public List<ComStateChangeLog> findByBatchId(List<ComStateChangeLog> list) {
        return comStateChangeLogDao.findByBatchId(list);
    }

    @Override
    public void updateSelective(ComStateChangeLog comStateChangeLog) {
        User currentUser = arsUtil.getCurrentUser();
        comStateChangeLog.setUpdateTime(new Date());
        comStateChangeLog.setUpdateBy(currentUser.getUsername());
        comStateChangeLogDao.updateSelective(comStateChangeLog);
    }
}
