package com.bcxin.ars.service.conference.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.UserDao;
import com.bcxin.ars.dao.conference.CloudConferenceDao;
import com.bcxin.ars.dao.conference.ConferenceAccountDao;
import com.bcxin.ars.dao.conference.ConferenceMemberDao;
import com.bcxin.ars.dao.sys.MessageLogDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.conference.*;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.conference.CloudConference;
import com.bcxin.ars.model.conference.ConferenceAccount;
import com.bcxin.ars.model.conference.ConferenceMember;
import com.bcxin.ars.service.conference.CloudConferenceService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.HuaweiMeetUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.MessageUtil;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.huawei.HuaweiMeetConst;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.commons.collections.map.HashedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/***
 * 会议信息服务实现层
 * @author subh
 */
@Service
@Transactional
public class CloudConferenceServiceImpl implements CloudConferenceService {
    /****
     * 日志
     */
    public final static Logger logger = LoggerFactory.getLogger(CloudConferenceServiceImpl.class);

    @Autowired
    private UserDao userDao;

    @Autowired
    private CloudConferenceDao cloudConferenceDao;

    @Autowired
    private ConferenceAccountDao conferenceAccountDao;


    @Autowired
    private ConferenceMemberDao conferenceMemberDao;

    @Autowired
    private MessageLogDao messageLogDao;

    @Autowired
    private HuaweiMeetUtil huaweiMeetUtil;

    @Autowired
    private ArsUtil arsUtil;

    @Override
    public void searchForPage(ConferenceSearchDto searchDto, AjaxPageResponse page) {
        User currentUser = arsUtil.getCurrentUser();
        arsUtil.setPoliceSearch(searchDto);
        searchDto.setUserId(currentUser.getId());
        cloudConferenceDao.searchForPage(searchDto,page);
    }

    @Override
    public void queryRecordList(RecordDto recordDto,AjaxPageResponse page) throws Exception {
        //参数
        Map<String,String> paramMap = new HashedMap();

        User user = arsUtil.getCurrentUser();
        ConferenceAccount conferenceAccount = conferenceAccountDao.selectByUserId(user.getId());

        if(conferenceAccount == null){
            return;
        }
        //查询条件
        paramMap.put("userUUID", conferenceAccount.getHuaweiUserId());
        paramMap.put("searchKey",recordDto.getSearchKey());
        //第几页
        paramMap.put("offset",String.valueOf((page.getPageNumber()-1)*page.getPageSize()));
        //每页的记录数。
        paramMap.put("limit",String.valueOf(page.getPageSize()));
        //查询全部
        paramMap.put("queryAll","true");
        //当前时间减一个月
        try {
            //开始时间如果为空，设置一个月前的时候
            if(recordDto.getStartDate() == null){
                recordDto.setStartDate(DateUtil.dateAdd(DateUtil.DATATYPE_MONTH, new Date(), -1));
            }
            //结束时间如果为空，设置当前时间
            if(recordDto.getEndDate() == null){
                recordDto.setEndDate(new Date());
            }
        } catch (Exception e) {
            logger.error("进入录播文件列表开始日期和结束日期转换成时间戳错误");
            throw new ArsException("预约开始时间必须大于当前时间！");
        }
          //开始时间2020-02-14格式装换为2020-02-14 00:00:00格式和结束时间为同一天时
          //结束时间2020-02-14格式装换为2020-02-14 23:23:59格式
        recordDto.setEndDate(DateUtil.convertStringToDate(DateUtil.convertDateToString(recordDto.getEndDate(),DateUtil.FORMAT2) + " 23:59:59"));
        //设置当前时间
        //开始日期和结束日期转换成时间戳，如：2020-02-02 1578931200000
        paramMap.put("startDate",String.valueOf(recordDto.getStartDate().getTime()));
        paramMap.put("endDate",String.valueOf(recordDto.getEndDate().getTime()));
        //排序
        paramMap.put("sortType",HuaweiMeetConst.SORTTYPE_DSC_StartTIME);
        //调用华为云获取录播列表
        //AjaxResult ajaxResult = huaweiMeetUtil.callInterfaceV1Record(Constants.METHOD_GET,HuaweiMeetConst.RECORD_V1,paramMap);
        AjaxResult ajaxResult = huaweiMeetUtil.callInterfaceV2Record(Constants.METHOD_GET,HuaweiMeetConst.RECORD_V1,paramMap,conferenceAccount);
        if (ajaxResult.isSuccessful()){
            PageRecordFile  pageRecordFile = (PageRecordFile) ajaxResult.getData();
            //录播数据列表
            page.setData(pageRecordFile.getData());
            //总条数
            page.setTotal(pageRecordFile.getCount());
            for (RecordFileInfo recordFileInfo:
                    pageRecordFile.getData()) {
                //时间戳转换成日期格式字符串
                if(recordFileInfo.getDecodeEndTime()!=null) {
                    recordFileInfo.setDecodeEndTimeFinish(new Date(recordFileInfo.getDecodeEndTime()));
                }
                //将会议开始时间由utc转换为本地时间
                if(recordFileInfo.getStartTime() != null){
                    recordFileInfo.setStartTime(DateUtil.utcToLocal(recordFileInfo.getStartTime()+ ":00",DateUtil.FORMAT15));
                }
            }
        }else {
            throw new ArsException("录播列表查询失败");
        }
    }

    @Override
    public AjaxResult batchDeleteRecord(String[] confUUIDs) {
        //将数组转换为华为云可以接收的参数
        String confUUIDSString = Arrays.toString(confUUIDs);
        confUUIDSString = confUUIDSString.substring(1,confUUIDSString.length()-1);
        Map<String,String> paramMap = new HashedMap();
        //设置华为云参数
        paramMap.put("confUUIDs",confUUIDSString);
        AjaxResult result = huaweiMeetUtil.callInterfaceV1ReDe(Constants.METHOD_DELETE,HuaweiMeetConst.RECORD_V1,paramMap);
        return result;
    }

    @Override
    public CloudConference save(CloudConference conference) {

        if(conference.getSubscribe()){
            if(System.currentTimeMillis()> DateUtil.parseDate(conference.getStartTime()+":00")){
                throw new ArsException("预约开始时间必须大于当前时间！");
            }
            if(conference.getDuration()<14 || conference.getDuration()>1440){
                throw new ArsException("会议时长必须在15分钟到1440分钟之间！");
            }
        }

        User currentUser = arsUtil.getCurrentUser();
        conference.setCreateTime(new Date());
        conference.setUpdateBy(currentUser.getUsername());
        conference.setUserid(currentUser.getId());
        conference.setActive(true);
        conference.setUpdateTime(new Date());
        conference.setUserid(currentUser.getId());
        setConferenceMembers(conference);
        AjaxResult result =saveHuaweiConference(conference);
        if(result.isSuccessful()) {
            ConferenceInfo conferenceInfo =  (ConferenceInfo)result.getData();

            //会议ID
            conference.setMeetId(conferenceInfo.getConferenceID());
            //会议的UUID
            conference.setConfUUID(conferenceInfo.getConfUUID());
            //会议接入码。
            conference.setAccessNumber(conferenceInfo.getAccessNumber());
            //会议状态
            if (Constants.CONFERENCESTATE_SCHEDULE.equals(conferenceInfo.getConferenceState())) {
                conference.setState(Constants.CONFERENCESTATE_SCHEDULE_CODE);
            } else {
                conference.setState(Constants.CONFERENCESTATE_CREATED_CODE);
            }
            //时间加8个小时
            conference.setStartTime(DateUtil.utcToLocal(conferenceInfo.getStartTime() + ":00",DateUtil.FORMAT15));
            conference.setEndTime(DateUtil.utcToLocal(conferenceInfo.getEndTime() + ":00",DateUtil.FORMAT15));
            //密码
            List<PasswordEntry> passwords = conferenceInfo.getPasswordEntry();
            if (passwords != null && passwords.size() > 0) {
                for (PasswordEntry password : passwords) {
                    if (password.getConferenceRole().equals(Constants.CONFERENCEROLE_CHAIR)) {
                        conference.setChairPwd(password.getPassword());
                    }
                    if (password.getConferenceRole().equals(Constants.CONFERENCEROLE_GENERAL)) {
                        conference.setGeneralPwd(password.getPassword());
                    }
                }
            }


           /* List<HuaWeiConference> resultDatas = JSONArray.parseArray(JSON.toJSONString(result.getData()), HuaWeiConference.class);
            if (resultDatas != null && resultDatas.size() > 0) {
                HuaWeiConference huaWeiConference = resultDatas.get(0);
                conference.setMeetId(huaWeiConference.getConferenceID());
                conference.setAccessNumber(huaWeiConference.getAccessNumber());
                if (conference.getSubscribe()) {
                    if (Constants.CONFERENCESTATE_SCHEDULE.equals(huaWeiConference.getConferenceState())) {
                        conference.setState(Constants.CONFERENCESTATE_SCHEDULE_CODE);
                    } else {
                        conference.setState(Constants.CONFERENCESTATE_CREATED_CODE);
                    }
                } else {
                    conference.setState(Constants.CONFERENCESTATE_CREATED_CODE);
                }
                //时间加8个小时
                try {
                    conference.setStartTime(DateUtil.convertDateToString(DateUtil.dateAdd(DateUtil.DATATYPE_HOUR, DateUtil.convertStringToDate(huaWeiConference.getStartTime() + ":00"), 8), "yyyy-MM-dd HH:mm"));
                    conference.setEndTime(DateUtil.convertDateToString(DateUtil.dateAdd(DateUtil.DATATYPE_HOUR, DateUtil.convertStringToDate(huaWeiConference.getEndTime() + ":00"), 8), "yyyy-MM-dd HH:mm"));
                }catch (Exception e){
                    logger.error(e.getMessage(),e);
                }
                List<PasswordEntry> passwords = huaWeiConference.getPasswordEntry();
                if (passwords != null && passwords.size() > 0) {
                    for (PasswordEntry password : passwords) {
                        if (password.getConferenceRole().equals(Constants.CONFERENCEROLE_CHAIR)) {
                            conference.setChairPwd(password.getPassword());
                        }
                        if (password.getConferenceRole().equals(Constants.CONFERENCEROLE_GENERAL)) {
                            conference.setGeneralPwd(password.getPassword());
                        }
                    }
                }
            }*/


            //默认有主席
            conference.setChairman(Constants.CHAIRMAN_YES);
            cloudConferenceDao.insert(conference);
            savePoliceMembers(conference);
            //成功后发送短信 TODO
            noticeUser(conference);
        }else {
            throw new ArsException("会议创建失败");
        }
        return  conference;
    }
    @Override
    public CloudConference findById(Long id) {
        return cloudConferenceDao.findById(id);
    }


    /***
     * 从华为云获取记录并结束会议
     * @param conference
     */
    @Override
    public void endConference(CloudConference conference){
        if(StringUtil.isNotEmpty(conference.getConfUUID())) {
            //从华为云会议历史查询记录
            AjaxResult result = huaweiMeetUtil.callInterface(Constants.METHOD_GET, HuaweiMeetConst.HISTORY_CONFERENCES.replace("{confuuid}",conference.getConfUUID()), null, new HashedMap(), true);
            //获取到会议记录
            ConferenceDetail detail = JSON.parseObject(JSON.toJSONString(result.getData()), ConferenceDetail.class);
            if (detail != null) {
                try {
                    conference.setEndTime(DateUtil.utcToLocal(detail.getConferenceData().getEndTime()  + ":00",DateUtil.FORMAT15));
                    //会议状态设置成已结束
                    conference.setState(Constants.CONFERENCESTATE_END_CODE);
                    //更新时间
                    conference.setUpdateTime(new Date());
                    //更新记录
                    cloudConferenceDao.updateState(conference);
                } catch (Exception e) {
                    logger.error(e.getMessage(), e);
                }
            }
        }else{
            RecordDto recordDto =  new RecordDto();
            try {
                //当前时间减一个月
                recordDto.setStartDate(DateUtil.dateAdd(DateUtil.DATATYPE_MONTH, new Date(), -1));
                //设置当前时间
                recordDto.setEndDate(new Date());
                recordDto.setEndDate(DateUtil.convertStringToDate(DateUtil.convertDateToString(recordDto.getEndDate(),DateUtil.FORMAT2) + " 23:59:59"));
                //参数
                Map<String,String> paramMap = new HashedMap();
                //开始时间
                paramMap.put("startDate",String.valueOf(recordDto.getStartDate().getTime()));
                paramMap.put("endDate",String.valueOf(recordDto.getEndDate().getTime()));
                //结束时间
                paramMap.put("searchKey",conference.getMeetId());
                paramMap.put("queryAll","true");
                AjaxResult result =huaweiMeetUtil.callInterfaceV1History(Constants.METHOD_GET,HuaweiMeetConst.HISTORY_CONFERENCESV1,paramMap);
                if(result.getData()!=null){
                    List<ConferenceInfo> list = (List<ConferenceInfo>)result.getData();
                    if(list!=null && list.size()>0) {
                        //循环
                        list.forEach(conferenceInfo->{
                            //华为云会议查询后比较，如果会议id一致再更新状态
                            if(conferenceInfo.getConferenceID().equals(conference.getMeetId())) {
                                try {
                                    conference.setEndTime(DateUtil.utcToLocal(conferenceInfo.getEndTime() + ":00", DateUtil.FORMAT15));
                                    //会议状态设置成已结束
                                    conference.setState(Constants.CONFERENCESTATE_END_CODE);
                                    //更新时间
                                    conference.setUpdateTime(new Date());
                                    //更新记录
                                    cloudConferenceDao.updateState(conference);
                                } catch (Exception e) {
                                    logger.error(e.getMessage(), e);
                                }
                            }
                        });

                    }
                }

            }catch (Exception e){

            }



        }
    }

    @Override
    public void end(String meetId) {
        //根据会议ID获取会议信息
        CloudConference conference = cloudConferenceDao.findByMeetId(meetId);
        if(conference!=null) {
            //休眠2秒再去华为云获取会议信息再判断是否结束
            try
            {
                Thread.sleep(2000);
            }
            catch(InterruptedException e)
            {
                logger.error(e.getMessage(), e);
                Thread.currentThread().interrupt();
            }
            //结束会议
            endConference(conference);
        }
    }

    @Override
    public void getConfUUID(String meetId) {
        //休眠2秒再去华为云获取会议信息
        try
        {
            Thread.sleep(2000);
        }
        catch(InterruptedException e)
        {
            logger.error(e.getMessage(), e);
            Thread.currentThread().interrupt();
        }
        //根据会议ID获取会议信息
        CloudConference conference = cloudConferenceDao.findByMeetId(meetId);
        if(conference!=null && StringUtil.isEmpty(conference.getConfUUID())) {
            Map<String, HuaWeiConference> conferenceMap = new HashedMap();
            Map<String, Object> paramMap = new HashedMap();
            AjaxResult result = huaweiMeetUtil.callInterface(Constants.METHOD_GET, HuaweiMeetConst.ADD_CONFERENCES,null, paramMap, true);

            if(result.isSuccessful()) {
                PageConferenceInfo detail = JSONObject.parseObject(JSON.toJSONString(result.getData()), PageConferenceInfo.class);
                List<HuaWeiConference> huaWeiConferenceList = detail.getData();
                if (huaWeiConferenceList != null && huaWeiConferenceList.size() > 0) {
                    huaWeiConferenceList.stream();
                    conferenceMap = huaWeiConferenceList.stream().collect(Collectors.toMap(HuaWeiConference::getConferenceID, Function.identity()));
                }
            }
            HuaWeiConference huaWeiConference = conferenceMap.get(conference.getMeetId());
            if (huaWeiConference != null) {
                conference.setEndTime(huaWeiConference.getEndTime());
                if(StringUtil.isEmpty(conference.getConfUUID())){
                    conference.setConfUUID(huaWeiConference.getConfUUID());
                }
                if (Constants.CONFERENCESTATE_SCHEDULE.equals(huaWeiConference.getConferenceState())) {
                    conference.setState(Constants.CONFERENCESTATE_SCHEDULE_CODE);
                } else if (Constants.CONFERENCESTATE_CREATED.equals(huaWeiConference.getConferenceState())) {
                    conference.setState(Constants.CONFERENCESTATE_CREATED_CODE);
                } else {
                    conference.setState(Constants.CONFERENCESTATE_END_CODE);
                }
                //更新时间
                conference.setUpdateTime(new Date());
                //执行数据库更新
                cloudConferenceDao.updateState(conference);
            }
        }
    }


    @Override
    public void saveAccountMembers(CloudConference conference) {
        CloudConference dbConference = cloudConferenceDao.findById(conference.getId());
        dbConference.setPoliceMembers(conference.getPoliceMembers());
        dbConference.setComMembers(conference.getComMembers());

        setConferenceMembers(dbConference);
        AjaxResult result = addHuaweiAttendees(dbConference);
        if(result.isSuccessful()) {
            savePoliceMembers(dbConference);
            //发送短信 TODO
            new Thread(() -> {
                noticeUser(dbConference);
            }).start();
        }else {
            throw new ArsException("邀请与会者失败:"+result.getMsg());
        }
    }

    /**
     * 设置会议与会者
     * @param conference
     */
    private void setConferenceMembers(CloudConference conference){
        List<ConferenceMemberDto> list = new ArrayList<>();
        List<ConferenceMember> policeMemberList = new ArrayList<>();
        ConferenceMemberDto member = null;
        ConferenceMember policeMember = null;

        if(StringUtil.isNotEmpty(conference.getPoliceMembers())){
            String[] policeMembers = conference.getPoliceMembers().split(",");
            for (String userId : policeMembers) {
                if(userId.equals(conference.getUserid().toString())) {
                    continue;
                }
                ConferenceAccount conferenceAccount = conferenceAccountDao.selectByUserId(Long.parseLong(userId));
                User user = userDao.findById(Long.parseLong(userId));

                member = new ConferenceMemberDto();
                member.setAccountId(conferenceAccount.getAccount());
                member.setName(user.getRealname());
                member.setPhone(conferenceAccount.getHuaweiSipName());
                member.setRole(Constants.CONFERENCEROLE_GENERAL_CODE);//来宾
                member.setSms(user.getPhone());
                member.setUserUUID(conferenceAccount.getHuaweiUserId());

                policeMember = new ConferenceMember();
                policeMember.setConferenceId(conference.getId());
                policeMember.setAccountId(conferenceAccount.getId());
                policeMember.setConferenceRole(Constants.CONFERENCEROLE_GENERAL_CODE);
                policeMember.setName(user.getRealname());
                policeMember.setMute(false);
                policeMember.setActive(true);
                policeMember.setCreateTime(new Date());
                policeMember.setUpdateTime(new Date());
                policeMember.setUserid(user.getId());

                list.add(member);
                policeMemberList.add(policeMember);
            }
        }
        if(StringUtil.isNotEmpty(conference.getComMembers())){
            List<ComAccountZTree> trees = JSONArray.parseArray(conference.getComMembers(),ComAccountZTree.class);
            for (ComAccountZTree accountZTree : trees) {
                member = new ConferenceMemberDto();
                member.setName(accountZTree.getLabel());
                member.setPhone(accountZTree.getHuaweiSipName());
                member.setRole(Constants.CONFERENCEROLE_GENERAL_CODE);//来宾
                member.setSms(accountZTree.getMobilePhone());
                list.add(member);
            }
        }
        conference.setAttendees(list);
        conference.setPoliceAccounts(policeMemberList);
    }

    /**
     * 通知与会者
     * @param conference
     */
    private void noticeUser(CloudConference conference){
        //发送短信 TODO
        /*
        B79
        会议通知：您的${TXT_10}将在${TXT_20}开始，请您准时参加。
        会议ID：${TXT_10}，
        来宾密码：${TXT_10}。
        硬终端接入请拨打：${TXT_10}，
        请使用App或者PC的会议功能填入相关会议ID与密码参加会议。
        B78
        会议通知：您的${}将在${}开始，请您准时参加。会议ID：${}，来宾密码：${}，主持人密码：${}。硬终端接入请拨打：${}，请使用App或者PC的会议功能填入相关会议ID与密码参加会议。
        */
        String[] generalParams = new String[]{
                conference.getTheme(),
                conference.getStartTime(),
                conference.getMeetId(),
                conference.getGeneralPwd(),
                conference.getMeetId()
        };
        String[] chairParams = new String[]{
                conference.getTheme(),
                conference.getStartTime(),
                conference.getMeetId(),
                conference.getGeneralPwd(),
                conference.getChairPwd(),
                conference.getMeetId()
        };
        for(ConferenceMemberDto member : conference.getAttendees()) {
            if (Constants.CONFERENCEROLE_GENERAL_CODE.equals(member.getRole())) {
                MessageUtil.sendMessageHuaWei(
                    member.getSms(),
                    Constants.CLOUDCONFERENCE_NOTICE_GENERAL_SMSCODE,
                    messageLogDao,
                    generalParams,
                    Constants.CLOUDCONFERENCE_NOTICE_GENERAL_SMSCODE
                );
            }else if(Constants.CONFERENCEROLE_CHAIR_CODE.equals(member.getRole())){
                MessageUtil.sendMessageHuaWei(
                    member.getSms(),
                    Constants.CLOUDCONFERENCE_NOTICE_CHAIR_SMSCODE,
                    messageLogDao,
                    chairParams,
                    Constants.CLOUDCONFERENCE_NOTICE_CHAIR_SMSCODE
                );
            }
        }
    }

    /**
     * 保存公安成员
     * @param conference
     */
    private void savePoliceMembers(CloudConference conference){
        if(conference.getPoliceAccounts() != null && conference.getPoliceAccounts().size() > 0){
            for(ConferenceMember member: conference.getPoliceAccounts()){
                member.setConferenceId(conference.getId());
                conferenceMemberDao.insert(member);
            }
        }
    }


    /**
     * 创建华为云会议
     * @param conference
     * @return
     */
    private AjaxResult saveHuaweiConference(CloudConference conference){

        List<ConferenceMemberDto> attendees = conference.getAttendees();
        if(attendees == null){
            attendees = new ArrayList<>();
        }
        List<ConferenceMember> policeAccounts = conference.getPoliceAccounts();
        if(policeAccounts == null){
            policeAccounts = new ArrayList<>();
        }
        User currentUser = arsUtil.getCurrentUser();
        ConferenceAccount account = arsUtil.getConferenceAccount();
        Map<String,Object> paramMap = new HashedMap();
        /**
         *   0 : 普通会议
             1：周期会议
             默认 0
         */
        //paramMap.put("conferenceType","0");
        paramMap.put("subject",conference.getTheme());


        //会议是否自动启动录制，在录播类型为：录播、录播+直播时才生效。
        paramMap.put("isAutoRecord",conference.getAutoRecord());
        paramMap.put("recordAuthType",HuaweiMeetConst.RECORDTYPE_JY);
        //paramMap.put("recordType",HuaweiMeetConst.RECORDTYPE_JY);

        if(HuaweiMeetConst.AUTORECORD_YES.equals(conference.getAutoRecord())){
            paramMap.put("recordType",HuaweiMeetConst.RECORDTYPE_LB);
        }

        if(HuaweiMeetConst.CONFERENCEMODEL_CLOUD.equals(conference.getConferenceModel())){
            //是否使用VMR召开预约会议
            paramMap.put("vmrFlag",HuaweiMeetConst.VMRFLAG_YES);
            //用于识别用户开会时绑定的VMR会议室
            paramMap.put("vmrID",conference.getVmrID());
        }else{
            paramMap.put("vmrFlag",HuaweiMeetConst.VMRFLAG_NO);
            conference.setVmrID(null);
        }

        //时区 56 北京
        paramMap.put("timeZoneID","56");

        JSONObject confConfigInfo = new JSONObject();
        confConfigInfo.put("isSendNotify","False");
        confConfigInfo.put("isSendSms","False");

        paramMap.put("confConfigInfo",confConfigInfo);

        if(!conference.getSubscribe()){
            paramMap.put("startTime","");
        }else{
            //时间转换,北京时间转etc
            paramMap.put("startTime", DateUtil.localToUTC(conference.getStartTime() + ":00",DateUtil.FORMAT15));
        }

        if(conference.getSubscribe()){
            paramMap.put("length", conference.getDuration());
        }
        String mediaType = Constants.MEDIATYPE_VIDEO;
        if(conference.getType().equals(Constants.MEDIATYPE_VOICE_CODE)){
            mediaType = Constants.MEDIATYPE_VOICE;
        }else if(conference.getType().equals(Constants.MEDIATYPE_VIDEO_CODE) && conference.getHd()){
            mediaType = Constants.MEDIATYPE_HDVIDEO;
        }
        paramMap.put("mediaTypes",mediaType);
        paramMap.put("encryptMode",0);
        paramMap.put("recordAuxStream",0);

        ConferenceMemberDto member = new ConferenceMemberDto();
        member.setPhone(account.getHuaweiSipName());
        member.setSms(currentUser.getPhone());
        member.setName(currentUser.getRealname());
        member.setAccountId(account.getAccount());
        member.setUserUUID(account.getHuaweiUserId());
        member.setRole(Constants.CONFERENCEROLE_CHAIR_CODE);
        attendees.add(member);

        ConferenceMember policeMember = new ConferenceMember();
        policeMember.setConferenceId(conference.getId());
        policeMember.setAccountId(account.getId());
        policeMember.setConferenceRole(Constants.CONFERENCEROLE_CHAIR_CODE);
        policeMember.setName(currentUser.getRealname());
        policeMember.setMute(false);
        policeMember.setActive(true);
        policeMember.setCreateTime(new Date());
        policeMember.setUpdateTime(new Date());
        policeMember.setUserid(currentUser.getId());
        policeAccounts.add(policeMember);

        paramMap.put("attendees", JSONArray.toJSON(attendees));
        if(HuaweiMeetConst.CONFERENCEMODEL_CLOUD.equals(conference.getConferenceModel())) {
            return huaweiMeetUtil.callInterfaceCloudV1(Constants.METHOD_POST, HuaweiMeetConst.ADD_CONFERENCES_V1, null, paramMap);
        }else{
            return huaweiMeetUtil.callInterfaceV1(Constants.METHOD_POST, HuaweiMeetConst.ADD_CONFERENCES_V1, null, paramMap, false);
        }

    }

    /**
     * 华为云会议添加与会者
     * @param conference
     * @return
     */
    private AjaxResult addHuaweiAttendees(CloudConference conference){
        String ctrlTokenUrl = HuaweiMeetConst.ADD_CONFERENCES_CTRL_TOKEN.replace("{conferenceid}",conference.getMeetId());
        Map<String, String> headMap = new HashMap<>();
        headMap.put("password",conference.getChairPwd());
        /*
        loginType区分请求类型。
        0：终端请求
        1：CloudPortal请求
        */
        headMap.put("loginType","1");
        AjaxResult result = huaweiMeetUtil.callInterface(Constants.METHOD_GET,ctrlTokenUrl,headMap,new HashMap<>(),true);

        if(result.isSuccessful()) {
            JSONObject json = JSON.parseObject(JSON.toJSONString(result.getData()));
            String token = json.get("token").toString();
            String authorization = Base64.getEncoder().encodeToString((token).getBytes());
            headMap = new HashMap<>();
            headMap.put("Conference-Authorization", "Basic " + authorization);
            String url = HuaweiMeetConst.ADD_CONFERENCES_ATTENDEES.replace("{conferenceid}", conference.getMeetId());
            Map<String, Object> paramMap = new HashedMap();
            paramMap.put("attendees", JSONArray.toJSON(conference.getAttendees()));
            return huaweiMeetUtil.callInterface(Constants.METHOD_POST, url, headMap, paramMap, true);
        }
        return result;
    }

    @Override
    public CloudConference saveCloudecReleaseChairman(CloudConference conference) {

        /***
         * 判断是否已经被申请过
         */
        CloudConference dbconference  =  cloudConferenceDao.findById(conference.getId());
        if(Constants.CHAIRMAN_YES.equals(conference.getChairman()) && Constants.CHAIRMAN_YES.equals(dbconference.getChairman())){
            throw  new ArsException("主席已经被申请，不能再进行申请！");
        }
        //设置没有主席
        conference.setChairman(conference.getChairman());
        conference.setUpdateTime(new Date());
        cloudConferenceDao.updateChairmanState(conference);
        User currentUser = arsUtil.getCurrentUser();
        /***
         * 更新主席状态
         */
        ConferenceMember conferenceMember = new ConferenceMember();
        conferenceMember.setUpdateTime(new Date());
        conferenceMember.setUserid(currentUser.getId());
        conferenceMember.setConferenceId(conference.getId());
        conferenceMember.setConferenceRole(conference.getChairman());
        conferenceMemberDao.updateChairmanState(conferenceMember);
        return  conference;
    }
}
