package com.bcxin.ars.service.certificate.impl;

import com.bcxin.ars.dao.certificate.ReplaceCompanyCertificateDao;
import com.bcxin.ars.dto.certificate.ReplaceCompanyCertificateSearchDTO;
import com.bcxin.ars.model.certificate.GradeCertificate;
import com.bcxin.ars.model.certificate.ReplaceCompanyCertificate;
import com.bcxin.ars.service.certificate.ReplaceCompanyCertificateService;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/***
 * 换证管理服务层实现层
 */
@Service
@Transactional
public class ReplaceCompanyCertificateServiceImpl implements ReplaceCompanyCertificateService {
    /***
     * 换证管理数据库持久
     */
    @Autowired
    private ReplaceCompanyCertificateDao replaceCompanyCertificateDao;

    @Override
    public List<ReplaceCompanyCertificate> query(ReplaceCompanyCertificateSearchDTO dto, AjaxPageResponse<ReplaceCompanyCertificate> page) {
        return replaceCompanyCertificateDao.query(dto,page);
    }

    @Override
    public ReplaceCompanyCertificate findById(long id) {
        return replaceCompanyCertificateDao.findById(id);
    }

    @Override
    public void update(ReplaceCompanyCertificate replaceCompanyCertificate) {
        replaceCompanyCertificateDao.update(replaceCompanyCertificate);
    }

    @Override
    public Long save(ReplaceCompanyCertificate replaceCompanyCertificate) {
        return replaceCompanyCertificateDao.save(replaceCompanyCertificate);
    }
}
