package com.bcxin.ars.service.bean.factory;

import com.bcxin.ars.model.appeal.Appeal;
import com.bcxin.ars.service.appeal.AppealHandle;
import com.bcxin.ars.service.util.SpringContextUtil;
import org.springframework.context.annotation.Configuration;

import java.util.HashMap;
import java.util.Map;

/***
 * 申诉返回对应
 */
@Configuration
public class AppealHandleBeanFactory {
    /***
     * 实现类
     */
    public  static Map<String,String> classNameMap = new HashMap<>();
    static {
        classNameMap.put("001","com.bcxin.ars.service.appeal.impl.AuthAppealHandle");
        classNameMap.put("002","com.bcxin.ars.service.appeal.impl.PersoncertificateAppealHandle");
        classNameMap.put("003","com.bcxin.ars.service.appeal.impl.GradeAppealHandle");
        classNameMap.put("004","com.bcxin.ars.service.appeal.impl.AdaptAppealHandle");
    }
    /***
     * 根据申诉类型获取实现类
     * @param appeal
     * @return
     */
    public static AppealHandle getAppealHandleBean(Appeal appeal){
        AppealHandle result = null;
        //获背景筛查spring容器的AppealHandle接口实现类列表
        Map<String, AppealHandle> list =  SpringContextUtil.getBeansOfType(AppealHandle.class);
        //循环判断是否和当前环境实现类
        for(Map.Entry<String, AppealHandle> entry : list.entrySet()){
            AppealHandle appealHandle = entry.getValue();
            //匹配，找到各个环境的实在
            if(appealHandle.getClass().getName().equals(classNameMap.get(appeal.getBusinesstype()))){
                result =  appealHandle;
                break;
            }
        }
        return result;

    }
    /***
     * 根据申诉类型获取实现类
     * @param businessType
     * @return
     */
    public static AppealHandle getAppealHandleBean(String businessType){
        AppealHandle result = null;
        //获背景筛查spring容器的AppealHandle接口实现类列表
        Map<String, AppealHandle> list =  SpringContextUtil.getBeansOfType(AppealHandle.class);
        //循环判断是否和当前环境实现类
        for(Map.Entry<String, AppealHandle> entry : list.entrySet()){
            AppealHandle appealHandle = entry.getValue();
            //匹配，找到各个环境的实在
            if(appealHandle.getClass().getName().equals(classNameMap.get(businessType))){
                result =  appealHandle;
                break;
            }
        }
        return result;

    }
}
