package com.bcxin.ars.service.task;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.task.ComShiftRule;
import com.bcxin.ars.dto.page.task.ComShiftRulePageSearchDto;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 企业班次规则Service接口
 *
 * @author linqinglin
 * @Date 2020-03-26 09:39:07
 */
public interface ComShiftRuleService {

   /****
     * 删除
     * @param comShiftRule
     * @return
     */
    int delete(ComShiftRule comShiftRule);

    /****
     * 保存
     * @param comShiftRule
     * @return
     */
    int save(ComShiftRule comShiftRule);

    /****
     * 选择性修改
     * @param comShiftRule
     * @return
     */
   void   updateSelective(ComShiftRule comShiftRule);

    /****
     * 主键查询
     * @param id
     * @return
     */
    ComShiftRule findById(Long id);

    /**
     * 分页查询
     * @param searchDto
     * @param page
     * @return
     */
    void searchForPage(ComShiftRulePageSearchDto searchDto, AjaxPageResponse<ComShiftRule> page);

    /**
     * 外导内查询
     * @param searchDto
     * @return
     */
    List<ComShiftRule> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    /**
     * 内导外查询
     * @param startDate
     * @return
     */
    List<ComShiftRule> findDSOutList(String startDate);

    /**
     * 批量保存
     * @param list
     */
    void importBatch(List<ComShiftRule> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<ComShiftRule> findByBatchId(List<ComShiftRule> list);
}
