package com.bcxin.ars.service.subsidy;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.subsidy.SubsidyOfflinePageSearchDto;
import com.bcxin.ars.model.subsidy.SubsidyOffline;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

import java.util.List;


/**
 * 线下补贴审批单Service接口
 * 
 * @author lin
 * @date 2020-11-12
 */
public interface SubsidyOfflineService{
    /****
     * 删除
     * @param subsidyOffline
     * @return
     */
    int delete(SubsidyOffline subsidyOffline);

    /****
     * 保存
     * @param subsidyOffline
     * @return
     */
    int save(SubsidyOffline subsidyOffline);

    /****
     * 选择性修改
     * @param subsidyOffline
     * @return
     */
    void updateSelective(SubsidyOffline subsidyOffline);

    /****
     * 主键查询
     * @param id
     * @return
     */
    SubsidyOffline findById(Long id);

    /**
     * 分页查询
     * @param searchDto
     * @param page
     * @return
     */
    void searchForPage(SubsidyOfflinePageSearchDto searchDto, AjaxPageResponse<SubsidyOffline> page);

    /**
     * 外导内查询
     * @param searchDto
     * @return
     */
    List<SubsidyOffline> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    /**
     * 内导外查询
     * @param startDate
     * @return
     */
    List<SubsidyOffline> findDSOutList(String startDate);

    /**
     * 批量保存
     * @param list
     */
    void importBatch(List<SubsidyOffline> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<SubsidyOffline> findByBatchId(List<SubsidyOffline> list);


    void create(Long[] batchIds);

    /**
     * 撤销
     * @param subsidyOffline
     * @return
     */
    void revoke(SubsidyOffline subsidyOffline);

    /**
     * 更新审批状态
     * @param subsidyOffline
     * @return
     */
    void approve(SubsidyOffline subsidyOffline);
}
