package com.bcxin.ars.service.sb;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.GradePracticeSearchDto;
import com.bcxin.ars.model.sb.GradePractice;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

import java.util.List;

/****
 * 等级证实习记录
 * @author  subh
 */
public interface GradePracticeService {
    /***
     * 等级证实习记录查询
     * @param dto 查询条件参数
     * @param ajaxPageResponse 返回数据对象
     * @return 查询列表
     */
    List<GradePractice> query(GradePracticeSearchDto dto, AjaxPageResponse<GradePractice> ajaxPageResponse);



    /**
     * 更新内网数据 --保存或者更新（更新到内网数据库）
     * @param gradePractice
     */
    void saveOrUpdateForDS(GradePractice gradePractice);
    /**
     * 查询需要生成同步文件的等级证实习记录
     * @param dto
     * @return
     */
    List<GradePractice> searchForDataSynchronization(DataSynchronizationSearchDto dto);

    /**
     * 更新内网数据 --保存或者更新（更新到内网数据库）
     * @param dto
     */
    void saveOrUpdate(GradePractice dto);

    /***
     * 删除
     * @param record
     * @return
     */
    void del(GradePractice record);

    /**
     * 根据personid以及等级搜索实习记录
     * @param personId
     * @param gradeLevel
     * @return
     */
    List<GradePractice> findByPersonIdAndGradeLevel(Long personId, String gradeLevel);
}
