package com.bcxin.ars.service.sb;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.CrosscompanySearchDto;
import com.bcxin.ars.model.PageResult;
import com.bcxin.ars.model.sb.Crosscompany;
import com.bcxin.ars.model.sys.Approval;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

import java.util.List;
import java.util.Map;

public interface CrosscompanyService {

    Crosscompany findById(long id);
    /**
     *
     * @Decription:批量查询
     * @author：zhongjianhui
     * @method  findByBatchId
     * @date：2018/8/17 9:15
     * @params： * @param approvalList
     * @return java.util.List<com.bcxin.ars.model.sb.Crosscompany>
     */
    List<Crosscompany> findByBatchId(List<Approval> approvalList);
    /**
     *
     * @Decription:批量更新
     * @author：zhongjianhui
     * @method  updateBatch
     * @date：2018/8/17 9:24
     * @params： * @param list
     * @return void
     */
   void updateBatch(List<Crosscompany> list);

    void saveOrUpdate(Crosscompany crosscompany);

    void saveOrUpdateForDS(Crosscompany crossCompany);

    Crosscompany findByUser(Long userid);

    CrosscompanySearchDto search(CrosscompanySearchDto dto);

    List<Crosscompany> searchForDataSynchronization(DataSynchronizationSearchDto dto);

	List<Crosscompany> findAll();

	void temporarySave(Crosscompany crosscompany);

    PageResult searchCrosscompanyList_table(Map<Object, Object> p);

    void saveOrUpdateForApproval(Crosscompany crosscompany);

    /**
     * 根据单据id查询申请人信息
     * @param id
     * @return
     */
    Map<String,Object> selectApplyUserInfoWithId(Long id);

    void updateCensorStatus(Crosscompany crosscompany);

    void saveOrUpdateForApprovalImport(Crosscompany crosscompany);

    void searchForPage(CrosscompanySearchDto dto, AjaxPageResponse<Crosscompany> page);
}
