package com.bcxin.ars.service.epidemic;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.epidemic.EpidemicSearchDto;
import com.bcxin.ars.model.appeal.Appeal;
import com.bcxin.ars.model.epidemic.Epidemic;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

import java.util.List;

public interface EpidemicService {
    /****
     * 保存
     * @param record
     * @return
     */
    int insert(Epidemic record);

    Epidemic findById(Long id);

    int update(Epidemic record) throws Exception;

    /***
     * 查询未补充街道个数
     * @param epidemic
     * @return
     */
    long findByStreetCount(Epidemic epidemic);
    /**
     * 分页查询
     *
     * @param searchDto
     * @param page
     * @return
     */
    List<Epidemic> searchForPage(EpidemicSearchDto searchDto, AjaxPageResponse<Epidemic> page);

    /**
     * 外导内查询
     *
     * @param searchDto
     * @return
     */
    List<Epidemic> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    /**
     * 删除
     * @param record
     * @return
     */
    int del(Epidemic record);


    /***
     *
     * @return
     */
    Epidemic findNew(Long userId);
    /***
     * 保存复制信息
     */
    void saveCopyYesterdayData();

    /***
     * 外到内同步
     * @param epidemic
     */
    void saveOrUpdateForDS(Epidemic epidemic);

}
