package com.bcxin.ars.service.certificate;

import com.bcxin.ars.dto.certificate.TrainCertificateSearchDto;
import com.bcxin.ars.model.certificate.TrainCertificate;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

import java.util.List;

/**
 * 保安培训公司证书信息
 * @author Ethan
 */
public interface TrainCertificateService {


	/**
	 * 新增或更新保安培训公司证书信息
	 * @param trainCertificate
	 */
	void saveOrUpdate(TrainCertificate trainCertificate);

	/**
	 * 创建或更新保安培训公司证书信息
	 * @param trainCertificate
	 */
	void saveOrUpdateForLegalchange(TrainCertificate trainCertificate);

	/**
	 * 根据ID获取保安培训公司证书信息
	 * @param id 主键
	 * @return
	 */
	TrainCertificate findById(long id);
	/**
	 * 根据ID获取保安培训公司证书信息
	 * @param id 主键
	 * @param type 正副本类型
	 * @return
	 */
	TrainCertificate findById(long id,String type);
	TrainCertificate findByIdV2(long id,String type);
	/**
	 * 根据companyId获取保安培训公司证书信息
	 * @param companyId
	 * @return
	 */
	TrainCertificate findByCompanyId(long companyId);

	/**
	 * 删除保安培训公司证书信息
	 * @param trainCertificate
	 * @return
	 */
	void delete(TrainCertificate trainCertificate);

	/**
	 * 查询保安培训公司证书信息
	 * @param dto
	 * @return
	 */
	void search(TrainCertificateSearchDto dto, AjaxPageResponse page);

	/**
	 * 查询保安培训公司证书信息
	 * @param dto
	 * @return
	 */
	TrainCertificateSearchDto search(TrainCertificateSearchDto dto);

    void updatePrintedByid(Long id);

    void createPdfBatch();

    void updateAndCreatePDF(TrainCertificate trainCertificate);

	/**
	 * 保存
	 * @param trainCertificate
	 */
	int save(TrainCertificate trainCertificate);

	List<String> selectCompanyName();

    void searchForPage(TrainCertificateSearchDto trainCertificateSearchDto, AjaxPageResponse<TrainCertificate> page);
}
