package com.bcxin.ars.service.certificate;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.certificate.GradeCertificateSearchDto;
import com.bcxin.ars.model.certificate.GradeCertificate;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/***
 * 等级证信息服务层
 * @author subh
 */
public interface GradeCertificateService {
    /***
     * 培训机构保安员证书查询
     * @param dto 查询条件参数
     * @param ajaxPageResponse 返回数据对象
     * @return 查询列表
     */
    List<GradeCertificate> query(GradeCertificateSearchDto dto, AjaxPageResponse<GradeCertificate> ajaxPageResponse);

    /***
     * 根据ID查询
     * @param id 主键
     * @return
     */
    GradeCertificate findById(Long id);

    /***
     * 更新
     * @param gradeCertificate
     */
    void update(GradeCertificate gradeCertificate);
    /**
     * 查询需要生成同步文件的保安员资格证记录
     * @param dto
     * @return
     */
    List<GradeCertificate> searchForDataSynchronization(DataSynchronizationSearchDto dto);

    /**
     * 外网同步到内网方法
     * @param gradeCertificate
     */
    void saveOrUpdateForDS(GradeCertificate gradeCertificate);

    /***
     * 批量插入插入
     * @param list 列表
     */
    List<Map<String, String>> insertBatchForImport(List<Map<String, String>> list);

    /**
     * 查询未推送给SAAS的数据
     * @return
     */
    List<GradeCertificate> findUnPushToSAAS();

    /**
     * 批量更新推送状态
     * @param certificates
     */
    void batchUpdatePushState(List<GradeCertificate> certificates);
    /**
     * 批量更新人员等级证信息
     * @param certificates
     */
    void batchUpdatePersonGradeCertificate(@Param("list") List<GradeCertificate> certificates);

    List<GradeCertificate> findByIdNums(String[] idNumArr);
}
