package com.bcxin.ars.service.approve;

import java.util.List;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.approve.ApproveAreaProcessDataDto;
import com.bcxin.ars.dto.approve.ApproveAreaProcessDto;
import com.bcxin.ars.dto.approve.ApproveOrgDto;
import com.bcxin.ars.dto.approve.ApproveTempOrgDto;
import com.bcxin.ars.model.approve.ApproveAreaProcess;
import com.bcxin.ars.model.approve.ApproveTemp;

/**
 * @author：wangcy @date：2018/01/22 0022 13:33
 * @description：区域审批流程Service
 */
public interface ApproveAreaProcessService {

	/**
	 * @Author: wangcy
	 * @Description:根据条件查询
	 * @Date: 2018/01/19 0019 15:31
	 */
	List<ApproveAreaProcessDto> search(ApproveAreaProcessDto approveAreaProcessDto);

	/**
	 * @Author: wangcy
	 * @Description:修改或者查询
	 * @Date: 2018/01/19 0019 15:31
	 */
	String saveOrUpdate(ApproveAreaProcessDto approveAreaProcessDto) throws Exception;

	List<ApproveOrgDto> findApproveOrgList(ApproveAreaProcessDto approveAreaProcess);

	List<ApproveOrgDto> findApproveOrgListBypoliceId(ApproveAreaProcessDto approveAreaProcess);

	Long getCountByTempCodeAndPoliceId(ApproveTempOrgDto approveTempOrgDto);
	/**
	 * @Author: wangcy
	 * @Description:根据条件查询
	 * @Date: 2018/01/19 0019 15:31
	 */
	List<ApproveAreaProcessDto> searchProcess();
	/**
	 * 数据整合
	 * 
	 * @param
	 * @return
	 */
	ApproveAreaProcessDataDto findDataDtoForDS();

	void insertBatchTemp(List<ApproveAreaProcess> approveAreaProcessList);

	String saveMainProcess(ApproveTemp approveTemp) throws Exception;

	void startAllProcess() throws Exception;

	List<ApproveAreaProcess> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

	void updateFlagForOutToIn(List<ApproveAreaProcess> areaProcessList);
}
