package com.bcxin.ars.service;

import com.bcxin.ars.dto.*;
import com.bcxin.ars.dto.page.PersonDto;
import com.bcxin.ars.dto.page.PersonPageSearchDto;
import com.bcxin.ars.dto.report.PersonReportData;
import com.bcxin.ars.dto.report.ReportDataSearchDto;
import com.bcxin.ars.model.Native;
import com.bcxin.ars.model.PageResult;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.SecurityPerson;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

import java.io.File;
import java.util.List;
import java.util.Map;

/**
 * 保安员服务类
 * @author Ethan
 */
public interface SecurityPersonService {
    /**
     * 保全人员分页查询
     */

    PageResult querySercurityPersonList(Map<Object, Object> p);
    /*
     * 查询总数
     * */
    int getAllCount(Map<Object, Object> p);
    /*
     * 查询标签数据
     * */
    Map getInitCount(Map<Object, Object> p);
    /*
     * 查询未初始化
     * */
    int getNotInitCount(Map<Object, Object> p);
    /*
     * 查询已审核通过
     * */
    int queryIidentityCnt(Map<Object, Object> p) ;
    /*
     * 查询未审核通过
     * */
    int queryNotIidentityCnt(Map<Object, Object> p) ;
    /*
     * 问题人员
     * */
    int queryLevelCnt(Map<Object, Object> p) ;
    /*
     * 今年新增
     * */
    int getNewAddCount(Map<Object, Object> p) ;

    List<SecurityPerson> searchForDataSynchronization(DataSynchronizationSearchDto dto);

    /**
     * 根据名称模糊查找保安员列表
     * @param dto
     * @return
     */
    PersonSearchDto search(PersonSearchDto dto);
    /**
     * 根据名称模糊查找保安员列表
     * @param dto
     * @return
     */
    PersonSearchDto searchForPersonInsuredState(PersonSearchDto dto);
    /**
     * 根据名称模糊查找紧急人员列表
     * @param dto
     * @return
     */
    PersonSearchDto searchUrgentPerson(PersonSearchDto dto);
    /**
     *
     * @Decription:根据公司id查找人员
     * @author：zhongjianhui
     * @method  findPersonByCompanyId
     * @date：2018/6/19 9:45
     * @params： * @param companyId
     * @return java.util.List<com.bcxin.ars.dto.SecurityPersonDTO>
     */
    SecurityPersonSearchRerurnDTO findPersonByCompanyIdSearchReturnDTO(SecurityPersonSearchRerurnDTO securityPersonSearchRerurnDTO);
    /**
     * 根据ID获取保安员
     * @param id
     * @return
     */
    SecurityPerson findById(Long id);



    List<SecurityPerson> findALl(int start,int numPerPage);

    /**
     * 获取指定公司的保安员
     * @param companyId
     * @return
     */
    List<SecurityPerson> findByCompanyId(Long companyId);

    /**
     * 获取指定公司的保安员
     * @param companyId
     * @return
     */
    List<SecurityPerson> findByCompanyIdForInsurance(Long companyId);

    /**
     * 获取指定公司的保安员且身份证号码正确
     * @param personSearchDto
     * @return
     */
    List<SecurityPerson> findByCompanyIdForInsuranceAndCheckId(PersonSearchDto personSearchDto);

    /**
     * 新增或更新保安员
     * @param person
     * @return
     */
    void saveOrUpdate(SecurityPerson person);

    /***
     * 更新人员参保信息
     * @param person
     */
    void updateBX(SecurityPerson person);

    /**
     * 更新保安员位置
     * @param person
     */
    void updateLocation(SecurityPerson person);

    /**
     * 更新在岗状态
     * @param person
     */
    void updateGuardStatus(SecurityPerson person);

    /**
     * 删除保安员
     * @param person
     * @return
     */
    void delete(SecurityPerson person);

    /**
     * 人员等级画像
     */
    List<ReportData> findLevelReport();

    /**
     * 人员年龄画像
     */
    Map<String, String[]> findAgeReport();

    /**
     * 人员性别画像
     * @return
     */
    List<ReportData> findGenderReport();

    /**
     * 人员祖籍画像
     * @return
     */
    Map<String, String[]> findNativeReport();

    /**
     * 人员能力画像
     * @param id
     * @return
     */
    Map<String, String[]> findAbilityReport(Long id);

    /**
     * 任务类型画像
     * @param id
     * @return
     */
    List<ReportData> findTaskTypeReport(Long id);

    /**
     * 任务种类画像
     * @param id
     * @return
     */
    Map<String, String[]> findTaskCatalogReport(Long id);

    /**
     * 任务级别画像
     * @param id
     * @return
     */
    List<ReportData> findTaskLevelReport(Long id);

    Long searchAllCount(PersonSearchDto dto);


    /***
     * 根据公司ID查询应急小队成员
     * @return
     */
    List<UrgentPerson> queryUrgentPersonByCompnyId();
    /***
     * 调用公安一所身份认证
     * @param id 保安人员ID
     */
    void publicAuth(Long id,String photo);

    /**
     *
     * 批量离职
     *
     * @param personIds
     * @return
     * @author LinQingLin
     * @date 2017年4月10日 下午4:07:52
     * @注意事项 </b>
     * <b>
     */
    AjaxResult batchDelete(Long[] personIds);
    /**
     *
     * @Decription:保安员更新证书信息
     * @author：zhongjianhui
     * @method  updateCertificate
     * @date：2019/1/16 14:51
     * @params： * @param personIds
     * @return com.bcxin.ars.dto.AjaxResult
     */
    AjaxResult updateCertificate(SecurityPerson person);

    /***
     * 更新人员投保状态
     * @param dto
     * @return
     */
    AjaxResult updatePersonInsuredState(SecurityPersonDTO dto);

    /**
     *
     * 保全批量减员
     *
     * @param personIds
     * @return
     * @author LinQingLin
     * @date 2017年4月10日 下午4:10:32
     * @注意事项 </b>
     * <b>
     */
    AjaxResult batchAttrition(Long[] personIds);
    /**
     * 获取所有员工的课程学习统计时间
     * @author liumd
     * @createTime 2017年4月11日
     */
    List<Long> getAllPersonStudy();
    /**
     * 批量导出保安人员-生成excel
     * @param data
     * @param file
     * @author LinQingLin
     * @date 2017年4月14日 下午3:06:04
     * @注意事项 </b>
     * <b>
     */
    void exportPersons(List<SecurityPerson> data, File file, Map<Long, Native> nativeData);

    /***
     * 应急人员
     * @return
     */
    List<SecurityPerson>  findUrgentPersons(String latitude, String longitude, Integer scope);
    /***
     * 在线人员
     * @return
     */
    List<SecurityPerson>  findOnlinePersons(String latitude, String longitude, Integer scope);

    AjaxResult checkUserPolicy(Long personId);

    AjaxResult checkUserPolicy(Long[] personIds);

    /**
     * 保险增员
     * <b>Function </b>
     *
     * @param personIds
     * @return
     * @author LinQingLin
     * @date 2017年5月9日 下午3:55:07
     * @注意事项 </b>
     * <b>
     */
    AjaxResult policy_increased(Long[] personIds);

    /**
     * 解除合同
     * <b>Function </b>
     *
     * @param personId
     * @return
     * @author LinQingLin
     * @date 2017年5月19日 下午7:56:49
     * @注意事项 </b>
     * <b>
     */
    AjaxResult relieveHt(Long personId);

    List<PersonStudyDTO> getStudyListDesc(PersonStudySearchDTO dto);

    PersonStudyDTO findPersonStudyReport(PersonStudySearchDTO dto);

    void saveOrUpdateForDS(SecurityPerson securityPerson);

    Long findUnPolicyByCompanyId(Long id);

    List<SecurityPerson> searchForTrain(PersonSearchDto dto);

    List<SecurityPerson> findPersonByCompanyIdAndStatus(Long companyId, String work_status);

    AjaxResult checkPersonStatus(String checkValue);

    SecurityPerson findByIdCard(String idNumber);

    PersonSearchDto searchForManage(PersonSearchDto dto);

    /**
     * V1.0.9APP版本
     * APP通讯录：获取指定公司的保安员
     * @param companyId
     * @return
     */
    List<SecurityPersonAppDto> findAppByCompanyId(Long companyId);

    PersonReportData dataStatisticsReport(ReportDataSearchDto searchDto);

    Long[] findUnPolicyPersonIdByCompanyId(Long companyId);

    SecurityPerson findActiveByIdCard(String idNum);

    SecurityPerson findActiveByPhone(String phone);

    PersonSearchDto searchForMap(PersonSearchDto dto);

    SecurityPerson findByIdCardAndCompanyId(String idNumber, Long id);

    SecurityPerson findByPhoneAndCompanyId(String phone, Long id);

    SecurityPerson findByPhone(String phone);

    AjaxResult searchBatch(Long[] personIds);

    List<SecurityPerson> searchForExport(PersonPageSearchDto dto);
    /***
     * 根据参数获取对象
     * @param person 人员信息参数
     * @return 人员信息
     */
    SecurityPerson find(SecurityPerson person);

    void sendNewUserMessage(SecurityPerson person);

    /**
     * author wjb
     * @time 2018年8月9日14:14:16
     * @param listSecurityPerson
     * 批量更新相关保险信息
     */
    void updateBXBatch(List<SecurityPerson> listSecurityPerson);

    /****
     * 查询未背景筛查人员
     * @return 人员列表
     */
    List<SecurityPerson> findUnCensor();
    /****
     * 查询背景筛查不通过人员，重新背景筛查
     * @return 人员列表
     */
    List<SecurityPerson> findNoPassCensorStatus();
    /****
     * 查询未背景筛查人员
     * @return 人员列表
     */
    List<SecurityPerson> findUnCensorForTest();
    /**
     *
     * @Decription:修改手机号码
     * @author：zhongjianhui
     * @method  saveOrUpdateForSaas
     * @date：2018/9/27 17:22
     * @params： * @param person
     * @return void
     */
    void changePersonPhone(SecurityPersonDTO person);
    /**
     *
     * @Decription:
     * @author：zhongjianhui
     * @method  saveOrUpdateForSaas
     * @date：2018/9/27 17:22
     * @params： * @param person
     * @return void
     */
    void saveOrUpdateForSaas(SecurityPersonDTO person,SecurityCompany company);

    /**
     *
     * @Decription:批量修改人员（SAAS使用）
     * @author：zhongjianhui
     * @method  saveOrUpdateForSaas
     * @date：2018/9/27 17:22
     * @params： * @param List<SecurityPersonDTO>
     * @return void
     */
    AjaxResult batchSaveOrUpdateForSaas(List<SecurityPersonDTO> personDTOList);

    /**
     *
     * @Decription:批量调整人员部门（SAAS使用）
     * @author：zhongjianhui
     * @method  saveOrUpdateForSaas
     * @date：2018/9/27 17:22
     * @params： * @param List<SecurityPersonDTO>
     * @return void
     */
    AjaxResult batchAdjDeptForSaas(List<String> personDTOList,Long deptId);
    /**
     * 保安人员查询
     * @param p
     * @return
     */
    PageResult searchPersonList_table(Map<Object, Object> p);

	/**
	 * 保安人员查询
	 * @param id
	 * @return
	 */
	SecurityPerson findByIdGoodThing(Long id);

    /**
     * 新增或修改劳动合同
     * @param person
     */
    void saveOrUpdateHt(SecurityPerson person);

    /**
     * 更新人员背景筛查状态
     * @param securityPerson
     */
    void updateCensorStatus(SecurityPerson securityPerson);

    /**
     * 批量更新保安员身份认证状态(SAAS接口)
     *
     * @return
     */
    void batchUpdateIdentityAuthStateForSaas(List<SecurityPersonDTO> personList);
    /**
     * 批量更新保安员身份认证状态(用于更新头像)
     *
     * @return
     */
    void updatePersonidentityAuthStateBatchForPhoto(List<SecurityPersonDTO> personList);

    /**
     * 保安员分页查询
     * @param dto
     * @param page
     */
    void searchForPage(PersonPageSearchDto dto, AjaxPageResponse<PersonDto> page);

    /**
     * 保安员现实表现查询
     * @param dto
     * @param page
     */
    void searchForReality(PersonPageSearchDto dto, AjaxPageResponse<PersonDto> page);
    /**
     * 保安员分页查询频繁跳槽
     * @param dto
     * @param page
     */
    void searchForFrequently(PersonPageSearchDto dto, AjaxPageResponse<PersonDto> page);

    void batchUpdateCertificate(List<SecurityPersonDTO> personDTOList);

    //void updateComIdPhoto(SecurityPerson person);

    void updateIdPhoto(SecurityPerson person);

    /***
     * 更新身份证号信息
     * @param person 人员信息
     */
    void updateIdNumber(SecurityPerson person);


    /***
     * 将背景筛查通过人员重置重新背景筛查
     */
    void refreshPersonCensorStatus();

    /***
     * 将前科人员重置重新背景筛查
     */
    void refreshPersonCensorCriminalStatus();

    /***
     *统计在职人数数量
     * @return
     */
    Map<String,Object> countNewOldSystemPerson(PersonPageSearchDto dto);

	/**
	 * 根据部门id查询人员列表
	 * @param orgId
	 * @return
	 */
	List<SecurityPerson> findByOrgId(Long orgId);

    /**
     * 根据personId查询工作经历
     * @param id
     * @return
     */
    void selectExperienceById(Long id,Long relationId, AjaxPageResponse<PersonDto> page);
    /**
     * 批量更新保安员背景筛查状态
     * @param successPersonList
     */
    void updateCensorStatusList(@Param("lists") List<SecurityPerson> successPersonList);

    /**
     * 删除 人员证件照
     * @param person
     */
    void delIdPhoto(SecurityPerson person);

    List<SecurityPerson> findReCensor(int backGroupFrequency);
}
