package com.bcxin.ars.service;
import java.util.List;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.SbBusinessOutsideManagementSearchDto;
import com.bcxin.ars.dto.sb.SbSubsidiaryManagerSearchDto;
import com.bcxin.ars.model.SbBusinessOutsideManagement;
import com.bcxin.ars.model.SbSubsidiaryManager;

/**
 * 海外经营信息管理
 * @author Ethan
 */
public interface SbBusinessOutsideManagementService {


	/**
	 * 新增或更新海外经营信息
	 * @param sbBusinessOutsideManagement
	 */
	void saveOrUpdate(SbBusinessOutsideManagement sbBusinessOutsideManagement);

	/**
	 * 根据ID获取海外经营信息
	 * @param id
	 * @return
	 */
	public SbBusinessOutsideManagement findById(long id);

	/**
	 * 删除海外经营信息
	 * @param sbBusinessOutsideManagement
	 * @return
	 */
	void delete(SbBusinessOutsideManagement sbBusinessOutsideManagement);



	/**
	 * 查询海外经营信息
	 * @param dto
	 * @return
	 */
	public SbBusinessOutsideManagementSearchDto search(SbBusinessOutsideManagementSearchDto dto);

	List<SbBusinessOutsideManagement> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

	void saveOrUpdateForDS(SbBusinessOutsideManagement sbBusinessOutsideManagement);


}
