package com.bcxin.ars.service;

import java.util.List;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.model.Invoice;
import com.bcxin.ars.model.User;

/**
 * 发票服务类
 * @author Ethan
 */
public interface InvoiceService {
	
	/**
	 * 保存发票
	 * @author liumd
	 * @createTime 2017年4月5日
	 */
	void save(Invoice invoice);
	
	/**
	 * 更新发票
	 * @author liumd
	 * @createTime 2017年4月5日
	 */
	void update(Invoice invoice);
	
	/**
	 * 根据搜索条件加载发票列表
	 */
	public List<Invoice> getInvoiceList();
	
	public Invoice getMsg(Long userid);
	/**
	 *
	 * @Decription:通过userName查询信息
	 * @author：zhongjianhui
	 * @method  getMsgByUserName
	 * @date：2018/9/30 10:10
	 * @params： * @param userName
	 * @return com.bcxin.ars.model.Invoice
	 */
	Invoice getMsgByUserName(String userName);

	Invoice findById(Long id);

	AjaxResult saveOrUpdate(Invoice invoice, User user);

	
}
