package com.bcxin.ars.dao;

import java.util.List;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;

import com.bcxin.ars.model.Nation;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations = { "classpath:/ars-dao.xml" })
@Transactional
@TransactionConfiguration(transactionManager = "txManager", defaultRollback = true)
public class NationDaoTest {

	@Autowired
	private NationDao nationDao;
	
	@Test
	public void testFindAll() {
		List<Nation> nations = nationDao.findAll();
		System.out.println(nations.size());
		Assert.assertNotNull(nations);
//		Assert.assertTrue(nations.size()>0);
	}
	
	@Test
	public void testFindByCode() {
		String code="30";
		Nation nation = nationDao.findByCode(code);
		System.out.println(nation.getName());
		Assert.assertNotNull(nation);
	}
	
	@Test
	public void exportToMobile() {
		List<Nation> nations = nationDao.findAll();
		System.out.println("<string-array name=\"nation\">");
		for(Nation na : nations) {
			System.out.println("	<item>" + na.getName().trim() + "</item>");
		}
		System.out.println("</string-array>");
	}
	
}
