package com.bcxin.ars.dao;

import java.util.List;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;

import com.alibaba.fastjson.JSON;
import com.bcxin.ars.dao.task.TaskFeedbackDao;
import com.bcxin.ars.dto.TaskFeedbackSearchDto;
import com.bcxin.ars.dto.task.TaskDetailSearchDto;
import com.bcxin.ars.dto.task.TaskFeedBackDto;
import com.bcxin.ars.model.task.TaskFeedback;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations = { "classpath:/ars-dao.xml" })
@Transactional
@TransactionConfiguration(transactionManager = "txManager", defaultRollback = true)
public class TaskFeedbackDaoTest {

	@Autowired
	private TaskFeedbackDao taskFeedbackDao;

	@Test
	public void testFindById() {
		List<TaskFeedback> list = taskFeedbackDao.findByTaskId(1l);
		Assert.assertTrue(list.size() > 0);
	}
	
	@Test
	public void testFindNotFeedback() {
		List<TaskFeedback> list = taskFeedbackDao.findNotFeedback(6l);
		Assert.assertTrue(list.size() > 0);
	}
	
	@Test
	public void testSearch() {
		TaskFeedbackSearchDto dto = new TaskFeedbackSearchDto();
		dto.setPageNum(0);
		dto.setNumPerPage(2);
		List<TaskFeedback> list = taskFeedbackDao.search(dto);
		Assert.assertTrue(list.size() > 0);
		long count = taskFeedbackDao.searchCount(dto);
		Assert.assertTrue(count > 0);
	}

	@Test
	public void testFindFeedbackList() {
		//List<TaskFeedback> list = taskFeedbackDao.findFeedbackList(62l,1l,10);
	//	Assert.assertTrue(list.size() > 0);
	}
	
	@Test
	public void testFindFeedBasks(){
		TaskDetailSearchDto taskDetailDto = new TaskDetailSearchDto();
		taskDetailDto.setTaskid(163l);
		taskDetailDto.setPersonid(236l);
		taskDetailDto.setTaskdate("2017-06");
		List<TaskFeedBackDto> feedbacks=taskFeedbackDao.findFeedBasks(taskDetailDto);
		System.out.println(JSON.toJSONString(feedbacks));
		Assert.assertTrue(feedbacks.size() > 0);
	}
}
