package com.bcxin.ars.dao;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bcxin.ars.dao.task.TaskDao;
import com.bcxin.ars.dto.ReportData;
import com.bcxin.ars.dto.TaskSearchDto;
import com.bcxin.ars.dto.task.TaskDetailSearchDto;
import com.bcxin.ars.dto.task.TaskDto;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.SecurityCompanySchedule;
import com.bcxin.ars.model.task.Task;
import com.bcxin.ars.model.task.TaskCatalog;
import com.bcxin.ars.model.task.TaskLevel;
import com.bcxin.ars.model.task.TaskStatus;
import com.bcxin.ars.model.task.TaskType;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations = { "classpath:/ars-dao.xml" })
@Transactional
@TransactionConfiguration(transactionManager = "txManager", defaultRollback = true)
public class TaskDaoTest {

	@Autowired
	private TaskDao taskDao;

	@Test
	public void testFindById() {
		Task task = taskDao.findById(1l);
		Assert.assertNotNull(task);
		List<SecurityCompanySchedule> scheduleList = task.getScheduleList();
		Assert.assertTrue(scheduleList.size() > 0);
	}

	@Test
	public void testSearch() {
		TaskSearchDto dto = new TaskSearchDto();
//		dto.setKeyword("任务");
		dto.setPageNum(0);
		dto.setPersonId(62l);
		dto.setNumPerPage(5);
//		dto.setStartDate("2017-02-01");
//		dto.setEndDate("2017-12-03");
		List<Task> taskList = taskDao.searchForFeedback(dto);
		JSON.DEFFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
		
		System.out.println(JSON.toJSONString(taskList,SerializerFeature.WriteDateUseDateFormat));
		taskList.get(0).getPersonList().size();
		Assert.assertTrue(taskList.size() > 0);
		Long count = taskDao.searchCount(dto);
		Assert.assertTrue(count > 0);
		List<ReportData> data1 = taskDao.findAreaReport(null);
		Assert.assertTrue(data1.size() > 0);
		//List<ReportData> data2 = taskDao.findCatalogReport(62l);
		//Assert.assertTrue(data2.size() > 0);
		//List<ReportData> data3 = taskDao.findLevelReport(62l);
		//Assert.assertTrue(data3.size() > 0);
	}
	
	@Test
	@Ignore
	public void testFindByPerson() {
		List<Task> list = taskDao.findByPerson(6l, "2017-05-12", "2017-05-12", 10000);
		Assert.assertTrue(list.size() > 0);
		System.out.println(list);
	}
	
	@Test
	public void testFindByStatus() {
		List<Task> list = taskDao.findBefore("2017-02-20", "2017-02-20", 10);
//		Assert.assertTrue(list.size() > 0);
		list = taskDao.findEnd("2017-02-20", "2017-02-20", 10);
//		Assert.assertTrue(list.size() > 0);
		list = taskDao.findING("2017-02-20", "2017-02-20");
		Assert.assertTrue(list.size() > 0);
	}

	@Test
	public void testFindEndTask() {
		List<Task> list = taskDao.findEndTask();
		System.out.println(list);
	}
	
	@Test
	public void testUpdateStatus() {
		List<Task> taskList = new ArrayList<Task>();
		Task t1 = new Task();
		t1.setId(1l);
		taskList.add(t1);
		Task t2 = new Task();
		t2.setId(3l);
		taskList.add(t2);
		//taskDao.updateStatus(2l, taskList);
		t1 = taskDao.findById(1l);
		Assert.assertTrue(t1.getTaskStatus().getId().longValue() == 2);
		t2 = taskDao.findById(3l);
		Assert.assertTrue(t2.getTaskStatus().getId().longValue() == 2);
	}
	
	@Test
	public void testSaveAndUpdate() {
		Task task = buildTask();
		Long id = taskDao.save(task);
		Task data = taskDao.findById(id);
		Assert.assertNotNull(data);
		data.setAddress("cbvn");
		data.setName("yuio");
		data.setUpdateTime(new Date());
		taskDao.update(data);
		data = taskDao.findById(id);
		Assert.assertEquals("yuio", data.getName());
		Assert.assertEquals("cbvn", data.getAddress());
	}
	
	@Test
	public void testDelete() {
		Task task = buildTask();
		taskDao.save(task);
		TaskSearchDto dto = new TaskSearchDto();
		dto.setKeyword("asdf");
		dto.setPageNum(0);
		dto.setNumPerPage(5);
		List<Task> data = taskDao.search(dto);
		Assert.assertTrue(data.size() == 1);
		taskDao.delete(data.get(0));
		data = taskDao.search(dto);
		Assert.assertTrue(data.size() == 0);
	}
	
	public Task buildTask() {
		Task task = new Task();
		task.setActive(true);
		task.setAddress("asdf");
		SecurityCompany company = new SecurityCompany();
		company.setId(62l);
		task.setCompany(company);
		task.setCreater("test");
		task.setCreateTime(new Date());
		task.setDetail("detail");
		task.setLongitude("139.23412023");
		task.setLatitude("123.023023");
		task.setName("zxcv");
		task.setNativeCode(11l);
		task.setAutoHoliday(true);
		task.setRepeat(true);
		task.setScope(1000);
		TaskCatalog taskCatalog = new TaskCatalog();
		taskCatalog.setId(1l);
		task.setTaskCatalog(taskCatalog);
		TaskLevel taskLevel = new TaskLevel();
		taskLevel.setId(1l);
		task.setTaskLevel(taskLevel);
		TaskStatus taskStatus = new TaskStatus();
		taskStatus.setId(1l);
		task.setTaskStatus(taskStatus);
		TaskType taskType = new TaskType();
		taskType.setId(1l);
		task.setTaskType(taskType);
		task.setUpdateBy("test");
		task.setUpdateTime(new Date());
		return task;
	}
	
	@Test
	public void testfindTaskList(){
		Long taskStatus = 1l;
		Long personId = 189l;
		List<Task> tasklist = taskDao.findTaskList(personId ,taskStatus, null);
		System.out.println(JSON.toJSONString(tasklist));
		System.out.println(tasklist.size());
	}

	@Test
	public void testfindTaskDetail(){
		TaskDetailSearchDto taskDetailDto = new TaskDetailSearchDto();
		taskDetailDto.setTaskid(163l);
		taskDetailDto.setPersonid(236l);
		//		Long personId = 62l;
//		Long taskId = 206l;
//		Task task = taskDao.findDetailByIdPerson(taskId,personId);
//		System.out.println(JSON.toJSONString(task));
//		System.out.println(task.getAddress());
		TaskDto task = taskDao.findTaskDetail(taskDetailDto);
		System.out.println(JSON.toJSONString(task));
		System.out.println(task.getName());
	}
}
