package com.bcxin.ars.dao;

import java.util.Date;
import java.util.List;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;

import com.bcxin.ars.model.SecurityCompanySchedule;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations = { "classpath:/ars-dao.xml" })
@Transactional
@TransactionConfiguration(transactionManager = "txManager", defaultRollback = true)
public class SecurityCompanyScheduleDaoTest {

	@Autowired
	private SecurityCompanyScheduleDao scheduleDao;

	@Test
	public void testAll() {
		SecurityCompanySchedule schedule = new SecurityCompanySchedule();
		schedule.setNativeCode(11l);
		schedule.setCreateTime(new Date());
		schedule.setUpdateTime(schedule.getCreateTime());
		schedule.setUpdateBy("test");
		schedule.setName("test schedule");
		schedule.setStartTime("09:50:00");
		schedule.setEndTime("18:59:00");
		schedule.setCompanyId(62l);
		Long id = scheduleDao.save(schedule);
		SecurityCompanySchedule data1 = scheduleDao.findById(id);
		Assert.assertNotNull(data1);
		List<SecurityCompanySchedule> data2 = scheduleDao.findByCompanyId(62l);
		Assert.assertTrue(data2.size() > 0);
		schedule.setName("test2");
		schedule.setStartTime("10:00:00");
		schedule.setEndTime("19:00:00");
		scheduleDao.update(schedule);
		SecurityCompanySchedule data3 = scheduleDao.findById(id);
		Assert.assertEquals("test2", data3.getName());
		Assert.assertEquals("10:00:00", data3.getStartTime());
		Assert.assertEquals("19:00:00", data3.getEndTime());
		scheduleDao.delete(schedule);
		SecurityCompanySchedule data4 = scheduleDao.findById(id);
		Assert.assertFalse(data4.getActive());
	}

}
