package com.bcxin.ars.dao;

import com.bcxin.ars.dto.CompanySearchDto;
import com.bcxin.ars.dto.ReportData;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.SecurityScope;
import com.bcxin.ars.model.User;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations = { "classpath:/ars-dao.xml" })
@Transactional
@TransactionConfiguration(transactionManager = "txManager", defaultRollback = true)
public class SecurityCompanyDaoTest {
	
	@Autowired
	private UserDao userDao;

	@Autowired
	private SecurityCompanyDao securityCompanyDao;
	
	@Test
	public void testSave() {
		User user = new UserDaoTest().buildUser();
		userDao.save(user);
		SecurityCompany company = buildCompany();
		company.setUser(user);
		securityCompanyDao.save(company);
		SecurityCompany c1 = securityCompanyDao.findById(company.getId());
		Assert.assertNotNull(c1);
		SecurityScope scope = new SecurityScope();
		scope.setId(1l);
		SecurityScope scope2 = new SecurityScope();
		scope2.setId(2l);
		CompanySearchDto dto = new CompanySearchDto();
		dto.setKeyword("试2");
		dto.setPageNum(0);
		dto.setNumPerPage(2);
		List<SecurityCompany> c2 = securityCompanyDao.search(dto);
		Assert.assertTrue(c2.size() > 0);
		Long count = securityCompanyDao.searchCount(dto);
		Assert.assertTrue(count.longValue() > 0);
		List<SecurityScope> scopes = c2.get(0).getSecurityScope();
		Assert.assertTrue(scopes.size() > 0);
		SecurityCompany c = securityCompanyDao.findById(company.getId());
		Assert.assertEquals(0, c.getSecurityScope().size());
	}
	
	@Test
	public void testReport() {
		List<ReportData> data1 = securityCompanyDao.findNativeReport(62l);
		Assert.assertTrue(data1.size()>0);
		System.out.println(data1);
		List<ReportData> data2 = securityCompanyDao.findProfessionLevelReport(62l);
		Assert.assertTrue(data2.size()>0);
		System.out.println(data2);
		List<ReportData> data3 = securityCompanyDao.findTaskCatalogReport(62l);
		Assert.assertTrue(data3.size()>0);
		System.out.println(data3);
		List<ReportData> data4 = securityCompanyDao.findTaskLevelReport(62l);
		System.out.println(data4);
	/*//	List<ReportData> data5 = securityCompanyDao.findAllAreaReport();
		Assert.assertTrue(data5.size()>0);
		System.out.println(data5);
		List<ReportData> data6 = securityCompanyDao.findAllScaleReport();
		Assert.assertTrue(data6.size()>0);
		System.out.println(data6);
		List<ReportData> data7 = securityCompanyDao.findAllTaskLevelReport();
		Assert.assertTrue(data7.size()>0);
		System.out.println(data7);*/
	}
	
	public SecurityCompany buildCompany() {
		SecurityCompany company = new SecurityCompany();
		company.setNativeCode(11l);
		company.setActive(true);
		company.setCreateTime(new Date());
		company.setUpdateTime(new Date());
		company.setUpdateBy("zcxvx");
		company.setName("测试22");
		company.setSocialCode("socialCode");
		company.setCentralOfficeLegalPerson("asdfas");
		company.setCentralOfficeTel("23123123");
		company.setTel("zxcvx");
		company.setTaskAmount(12);
		company.setSecurityAmount(100);
		company.setProvince("zcxvzxcv");
		company.setCity("city");
		company.setArea("area");
		company.setLocation("location");
		company.setInsuranceNumber("cxvbxcvb");
		company.setEmergencyAgreement(true);
		company.setBusinessLicense("zxcvzxcvz");
		company.setPublicSecurityLicense("zxcvzxcv");
		return company;
	}
	
}
