package com.bcxin.ars.dao;

import java.util.Date;
import java.util.List;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;

import com.bcxin.ars.dto.HistorySearchDto;
import com.bcxin.ars.model.SearchHistory;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations = { "classpath:/ars-dao.xml" })
@Transactional
@TransactionConfiguration(transactionManager = "txManager", defaultRollback = true)
public class SearchHistoryDaoTest {

	@Autowired
	private SearchHistoryDao searchHistoryDao;

	@Test
	public void testSave() {
		SearchHistory searchHistory = new SearchHistory();
		searchHistory.setActive(true);
		searchHistory.setCreateTime(new Date());
		searchHistory.setUpdateBy("system");
		searchHistory.setUpdateTime(new Date());
		searchHistory.setContext("12123214");
		searchHistory.setSearchType("1");
		searchHistory.setUserid(123l);
		
		searchHistoryDao.save(searchHistory);
		SearchHistory dbSearchHistory = searchHistoryDao.findById(searchHistory.getId());
		Assert.assertNotNull(dbSearchHistory);
	}
	
	@Test
	public void testSearchHistory(){
		HistorySearchDto dto = new HistorySearchDto();
		dto.setUserid(4l);
		dto.setPageNum(0);
		dto.setNumPerPage(3);
		List<SearchHistory> list = searchHistoryDao.search(dto);
		Assert.assertNotNull(list);
	}
	
	@Test
	public void testDetele(){
		SearchHistory history = new SearchHistory();
		history.setId(40l);
		history.setUpdateBy("system");
		history.setUpdateTime(new Date());
		searchHistoryDao.delete(history);
	}
	
	@Test
	public void testDeteleByUserid(){
		SearchHistory history = new SearchHistory();
		history.setUserid(4l);
		history.setUpdateBy("system");
		history.setUpdateTime(new Date());
		searchHistoryDao.deleteByUserid(history);;
	}
}
