package com.bcxin.ars.dao;

import java.util.List;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;

import com.bcxin.ars.model.Native;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations = { "classpath:/ars-dao.xml" })
@Transactional
@TransactionConfiguration(transactionManager = "txManager", defaultRollback = true)
public class NativeDaoTest {

	@Autowired
	private NativeDao nativeDao;

	@Test
	public void testFindByCode() {
		Native nativeName = nativeDao.findByCode(11l);
		Assert.assertNotNull(nativeName);
	}
	
	@Test
	public void testFindProvince() {
		List<Native> natives = nativeDao.findProvince();
		Assert.assertTrue(natives.size() > 0);
	}
	
	@Test
	public void testFindByParentCode() {
		List<Native> natives = nativeDao.findByParentCode(11l);
		Assert.assertTrue(natives.size() > 0);
	}

}
