package com.bcxin.ars.dao;

import com.bcxin.ars.dao.task.ComTaskDao;
import com.bcxin.ars.model.task.ComTask;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;

/**
 * @author linqinglin
 * @date 2020/06/12 0012 16:17
 */
@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations = { "classpath:/ars-dao.xml" })
@Transactional
@TransactionConfiguration(transactionManager = "txManager", defaultRollback = true)
public class ComTaskDaoTest {

    @Autowired
    private ComTaskDao comTaskDao;

    @Test
    public void relationTask(){
        ComTask comTask = new ComTask();
        comTask.setId(634041141532033024l);
        comTaskDao.relationTask(comTask);
    }
    @Test
    public void removeRelationTask(){
        ComTask comTask = new ComTask();
        comTask.setId(634041141532033024l);
        comTaskDao.removeRelationTask(comTask);

    }
    @Test
    public void removeRelationTaskList(){
        List<ComTask> list = new ArrayList<>();
        ComTask comTask = new ComTask();
        comTask.setId(634041141532033024l);
        list.add(comTask);
        comTask = new ComTask();
        comTask.setId(634323718360793088l);
        list.add(comTask);
        comTaskDao.removeRelationTaskList(list);

    }
}
