package com.bcxin.ars.dao.task;

import com.abcxin.smart.validator.annotation.DataChangeAnnotation;
import com.abcxin.smart.validator.enums.ParamType;
import com.bcxin.ars.model.task.ComTask;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author linqinglin
 * @date 2020/06/18 0018 10:31
 */
@Service
public class ComTaskDaoAop {

    @Autowired
    private ComTaskDao comTaskDao;

    @DataChangeAnnotation(getEntityClazz = ComTask.class,
            getDaoClazz = ComTaskDao.class,
            getParamClazz = Long.class,
            getFieldName = "comTaskId",
            getSearchMethodName = "findByIdWithOutCache")
    public void delete(ComTask comTask){
        comTaskDao.delete(comTask);
    }

    @DataChangeAnnotation(getEntityClazz = ComTask.class,
            getDaoClazz = ComTaskDao.class,
            getParamClazz = Long.class,
            getFieldName = "comTaskId",
            getSearchMethodName = "findByIdWithOutCache")
    public void save(ComTask comTask){
        comTaskDao.save(comTask);
    }

    @DataChangeAnnotation(getEntityClazz = ComTask.class,
            getDaoClazz = ComTaskDao.class,
            getParamType = ParamType.ENTITY,
            getParamClazz = List.class,
            getFieldName = "comTaskId",
            getSearchMethodName = "findByBatchIdWithOutCache")
    public void deleteBatch(List<ComTask> list){
        comTaskDao.deleteBatch(list);
    }

    @DataChangeAnnotation(getEntityClazz = ComTask.class,
            getDaoClazz = ComTaskDao.class,
            getParamType = ParamType.ENTITY,
            getParamClazz = List.class,
            getFieldName = "comTaskId",
            getSearchMethodName = "findByBatchIdWithOutCache")
    public void saveBatch(List<ComTask> list){
        comTaskDao.saveBatch(list);
    }

    @DataChangeAnnotation(getEntityClazz = ComTask.class,
            getDaoClazz = ComTaskDao.class,
            getParamType = ParamType.ENTITY,
            getParamClazz = List.class,
            getFieldName = "comTaskId",
            getSearchMethodName = "findByBatchIdWithOutCache")
    public void endTaskStatus(List<ComTask> list){
        comTaskDao.endTaskStatus(list);
    }

}
