package com.bcxin.ars.dao.supervision;

import com.abcxin.smart.validator.annotation.DataChangeAnnotation;
import com.abcxin.smart.validator.enums.ParamType;
import com.bcxin.ars.model.supervision.PersonPunish;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author yyx
 * @date 2020/06/15
 */
@Service
public class PersonPunishDaoAop {
    @Autowired
    private PersonPunishDao personPunishDao;
    @DataChangeAnnotation(getEntityClazz = PersonPunish.class,
            getDaoClazz = CompanyComplaintDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public int delete(PersonPunish personPunish) {
        return personPunishDao.delete(personPunish);
    }
    @DataChangeAnnotation(getEntityClazz = PersonPunish.class,
            getDaoClazz = PersonPunishDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public void save(PersonPunish personPunish) {
        personPunishDao.save(personPunish);
    }

    @DataChangeAnnotation(getEntityClazz = PersonPunish.class,
            getDaoClazz = PersonPunishDao.class,
            getParamType = ParamType.ENTITY,
            getParamClazz = List.class,
            getSearchMethodName = "findByBatchIdWithOutCache")
    public void saveBatch(List<PersonPunish> list) {
        personPunishDao.saveBatch(list);
    }
}
