package com.bcxin.ars.dao.supervision;

import com.abcxin.smart.validator.annotation.DataChangeAnnotation;
import com.abcxin.smart.validator.enums.ParamType;
import com.bcxin.ars.model.supervision.CompanyAward;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.util.List;

/**
 * @author yyx
 * @date 2020/06/15
 */
@Service
public class CompanyAwardDaoAop {
    @Autowired
    private CompanyAwardDao companyAwardDao;
    @DataChangeAnnotation(getEntityClazz = CompanyAward.class,
            getDaoClazz = CompanyAwardDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public int delete(CompanyAward companyAward) {
        return companyAwardDao.delete(companyAward);
    }
    @DataChangeAnnotation(getEntityClazz = CompanyAward.class,
            getDaoClazz = CompanyAwardDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public void save(CompanyAward companyAward) {
        companyAwardDao.save(companyAward);
    }

    @DataChangeAnnotation(getEntityClazz = CompanyAward.class,
            getDaoClazz = CompanyAwardDao.class,
            getParamType = ParamType.ENTITY,
            getParamClazz = List.class,
            getSearchMethodName = "findByBatchIdWithOutCache")
    public void saveBatch(List<CompanyAward> list) {
        companyAwardDao.saveBatch(list);
    }
}
