package com.bcxin.ars.dao.sb;

import com.abcxin.smart.validator.annotation.DataChangeAnnotation;
import com.abcxin.smart.validator.enums.ParamType;
import com.bcxin.ars.model.sb.Traincompanyapply;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author linqinglin
 * @date 2020/06/18 0018 11:29
 */
@Service
public class TraincompanyapplyDaoAop {


    @Autowired
    private TraincompanyapplyDao traincompanyapplyDao;

    @DataChangeAnnotation(getEntityClazz = Traincompanyapply.class,
            getDaoClazz = TraincompanyapplyDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public void update(Traincompanyapply traincompanyapply) {
        traincompanyapplyDao.update(traincompanyapply);
    }


    @DataChangeAnnotation(getEntityClazz = Traincompanyapply.class,
            getDaoClazz = TraincompanyapplyDao.class,
            getParamType = ParamType.ENTITY,
            getParamClazz = List.class,
            getSearchMethodName = "findByBatchIdWithOutCache")
    public void updateBatch(List<Traincompanyapply> list){
        traincompanyapplyDao.updateBatch(list);
    }
}
