package com.bcxin.ars.dao.sb;

import com.abcxin.smart.validator.annotation.DataChangeAnnotation;
import com.abcxin.smart.validator.enums.ParamType;
import com.bcxin.ars.dto.SecurityPersonSearchRerurnDTO;
import com.bcxin.ars.model.sb.Personcertificate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author linqinglin
 * @date 2020/06/08 0008 13:14
 */
@Service
public class PersoncertificateDaoAop {


    @Autowired
    private PersoncertificateDao personcertificateDao;

    @DataChangeAnnotation(getEntityClazz = Personcertificate.class,
            getDaoClazz = PersoncertificateDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public void delete(Personcertificate personcertificate){
        personcertificateDao.delete(personcertificate);
    }

    @DataChangeAnnotation(getEntityClazz = Personcertificate.class,
            getDaoClazz = PersoncertificateDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public void updateSelective(Personcertificate personcertificate){
        personcertificateDao.updateSelective(personcertificate);
    }

    @DataChangeAnnotation(getEntityClazz = Personcertificate.class,
            getDaoClazz = PersoncertificateDao.class,
            getParamClazz = Long[].class,
            getParamType = ParamType.ENTITY,
            getSearchMethodName = "findByIdArrWithOutCache")
    public void cancelFeeState(Long[] ids){
        personcertificateDao.cancelFeeState(ids);
    }

    @DataChangeAnnotation(getEntityClazz = Personcertificate.class,
            getDaoClazz = PersoncertificateDao.class,
            getParamClazz = Long[].class,
            getParamType = ParamType.ENTITY,
            getSearchMethodName = "findByIdArrWithOutCache")
    public void batchSaveConfirmOrder(Long[] personIds, String username){
        personcertificateDao.batchSaveConfirmOrder(personIds,username);
    }

    @DataChangeAnnotation(getEntityClazz = Personcertificate.class,
            getDaoClazz = PersoncertificateDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public void update(Personcertificate personcertificate) {
        personcertificateDao.update(personcertificate);
    }

    @DataChangeAnnotation(getEntityClazz = Personcertificate.class,
            getDaoClazz = PersoncertificateDao.class,
            getParamType = ParamType.ENTITY,
            getParamClazz = List.class,
            getSearchMethodName = "findByBatchIdWithOutCache")
    public void updateBatch(List<Personcertificate> list) {
        personcertificateDao.updateBatch(list);
    }

    public void updateBktfeeStateByBatchID(List<SecurityPersonSearchRerurnDTO> personcertificateList) {
        personcertificateDao.updateBktfeeStateByBatchID(personcertificateList);
    }
}
