package com.bcxin.ars.dao.sb;

import com.abcxin.smart.validator.annotation.DataChangeAnnotation;
import com.abcxin.smart.validator.enums.ParamType;
import com.bcxin.ars.model.sb.PersonGrade;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author linqinglin
 * @date 2020/06/03 0003 15:41
 */
@Service
public class PersonGradeDaoAop {

    @Autowired
    private PersonGradeDao personGradeDao;


    @DataChangeAnnotation(getEntityClazz = PersonGrade.class,
            getDaoClazz = PersonGradeDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public void delete(PersonGrade personGrade) {
        personGradeDao.delete(personGrade);
    }

    @DataChangeAnnotation(getEntityClazz = PersonGrade.class,
            getDaoClazz = PersonGradeDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public void update(PersonGrade personGrade) {
        personGradeDao.update(personGrade);
    }

    @DataChangeAnnotation(getEntityClazz = PersonGrade.class,
            getDaoClazz = PersonGradeDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public void save(PersonGrade personGrade) {
        personGradeDao.save(personGrade);
    }

    @DataChangeAnnotation(getEntityClazz = PersonGrade.class,
            getDaoClazz = PersonGradeDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public void updateSelective(PersonGrade personGrade) {
        personGradeDao.updateSelective(personGrade);
    }

    @DataChangeAnnotation(getEntityClazz = PersonGrade.class,
            getDaoClazz = PersonGradeDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public void updatePast(PersonGrade personGrade) {
        personGradeDao.updatePast(personGrade);
    }


    @DataChangeAnnotation(getEntityClazz = PersonGrade.class,
            getDaoClazz = PersonGradeDao.class,
            getParamType = ParamType.ENTITY,
            getParamClazz = List.class,
            getSearchMethodName = "findByBatchIdWithOutCache")
    public void saveBatch(List<PersonGrade> rosterList) {
        personGradeDao.saveBatch(rosterList);
    }

    @DataChangeAnnotation(getEntityClazz = PersonGrade.class,
            getDaoClazz = PersonGradeDao.class,
            getParamType = ParamType.ENTITY,
            getParamClazz = List.class,
            getSearchMethodName = "findByBatchIdWithOutCache")
    public void saveBatchForDSIn2Out(List<PersonGrade> rosterList) {
        personGradeDao.saveBatchForDSIn2Out(rosterList);
    }

}
